/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.ebxml.ConnectionImpl;
import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import com.sun.xml.registry.ebxml.jaas.LoginModuleManager;
import com.sun.xml.registry.ebxml.util.ProviderProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.CapabilityProfile;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.commons.logging.Log;

public class JAXRClient {
    ConnectionImpl connection;
    LoginModuleManager lmm;
    BusinessQueryManager bqm;
    BusinessLifeCycleManager lcm;
    Log log = null;

    public void createConnection(String url) {
        try {
            Thread.currentThread().setContextClassLoader(RegistryBrowser.getInstance().classLoader);
            ProviderProperties.getInstance().put("javax.xml.registry.queryManagerURL", url);
            if (url.toLowerCase().indexOf("uddi") >= 0) {
                System.setProperty("javax.xml.registry.ConnectionFactoryClass", "com.sun.xml.registry.uddi.ConnectionFactoryImpl");
            } else {
                System.setProperty("javax.xml.registry.ConnectionFactoryClass", "com.sun.xml.registry.ebxml.ConnectionFactoryImpl");
            }
            ConnectionFactory connFactory = ConnectionFactory.newInstance();
            this.connection = (ConnectionImpl)connFactory.createConnection();
            RegistryService service = this.connection.getRegistryService();
            this.bqm = service.getBusinessQueryManager();
            this.lcm = service.getBusinessLifeCycleManager();
            this.log = ((RegistryServiceImpl)this.lcm.getRegistryService()).getConnection().getConnectionFactory().getLog();
            this.lmm = this.connection.getLoginModuleManager();
            this.lmm.setParentFrame(RegistryBrowser.getInstance());
            this.lmm.setParentLog(this.log);
        }
        catch (JAXRException e) {
            e.printStackTrace();
            System.err.println("Checking the cause");
            if (e.getCause() != null) {
                System.err.println(this.getStackTraceFromThrowable(e.getCause()));
            }
            RegistryBrowser.displayError("Error creating new Connection.", e);
        }
    }

    public String getStackTraceFromThrowable(Throwable t) {
        String trace = null;
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            trace = sw.toString();
        }
        return trace;
    }

    public Connection getConnection() throws JAXRException {
        if (this.connection == null) {
            throw new JAXRException("Connect to a registry by specifying Registry Location first.");
        }
        return this.connection;
    }

    public BusinessLifeCycleManager getBusinessLifeCycleManager() throws JAXRException {
        if (this.connection == null) {
            throw new JAXRException("Connect to a registry by specifying Registry Location first.");
        }
        return this.lcm;
    }

    public BusinessQueryManager getBusinessQueryManager() throws JAXRException {
        if (this.connection == null) {
            throw new JAXRException("Connect to a registry by specifying Registry Location first.");
        }
        return this.bqm;
    }

    Collection getClassificationSchemes() {
        Collection schemes = null;
        String errMsg = "Error getting ClassificationSchemes";
        try {
            ArrayList findQualifiers = new ArrayList();
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add("%");
            BulkResponse response = this.bqm.findClassificationSchemes(findQualifiers, namePatterns, null, null);
            this.checkBulkResponse(response);
            schemes = response.getCollection();
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(errMsg, e);
            schemes = new ArrayList();
        }
        return schemes;
    }

    CapabilityProfile getCapabilityProfile() {
        CapabilityProfile profile = null;
        try {
            profile = this.connection.getRegistryService().getCapabilityProfile();
        }
        catch (JAXRException e) {
            e.printStackTrace();
            RegistryBrowser.displayError(e);
        }
        return profile;
    }

    public BulkResponse saveObjects(Collection objectsToSave) throws JAXRException {
        BulkResponse resp = null;
        try {
            resp = this.lcm.saveObjects(objectsToSave);
            this.checkBulkResponse(resp);
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
            e.fillInStackTrace();
            throw e;
        }
        return resp;
    }

    public void exportObjects(Collection objectsToExport) {
        try {
            Iterator iter = objectsToExport.iterator();
            while (iter.hasNext()) {
                RegistryObject ro = (RegistryObject)iter.next();
                System.err.println(ro.toXML());
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public void checkBulkResponse(BulkResponse resp) {
        try {
            if (resp != null && resp.getStatus() != 0) {
                Collection exceptions = resp.getExceptions();
                Iterator iter = exceptions.iterator();
                while (iter.hasNext()) {
                    Exception e = (Exception)iter.next();
                    RegistryBrowser.displayError(e);
                }
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }
}

