/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.RegistryBrowser;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.xml.registry.JAXRException;

public class JBDialog
extends JDialog
implements PropertyChangeListener {
    protected JPanel mainPanel = null;
    protected JPanel buttonPanel = null;
    public static final int CANCEL_STATUS = 0;
    public static final int OK_STATUS = 1;
    public static final int ERROR_STATUS = 2;
    protected int status = 0;
    public static final String PROPERTY_DIALOG_OK = "DIALOG_OK";
    protected boolean editable = RegistryBrowser.getInstance().isAuthenticated();
    protected GridBagConstraints c = new GridBagConstraints();
    protected GridBagLayout gbl = new GridBagLayout();
    private JButton okButton = null;
    private JButton cancelButton = null;

    public JBDialog(JDialog parent, boolean modal) {
        this(parent, modal, null);
    }

    public JBDialog(JFrame parent, boolean modal) {
        this(parent, modal, null);
    }

    public JBDialog(JDialog parent, boolean modal, JPanel mainPanel) {
        super((Dialog)parent, modal);
        this.mainPanel = mainPanel;
        this.jbDialog_initialize();
    }

    public JBDialog(JFrame parent, boolean modal, JPanel mainPanel) {
        super((Frame)parent, modal);
        this.mainPanel = mainPanel;
        this.jbDialog_initialize();
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void jbDialog_initialize() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(this.gbl);
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
        }
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.fill = 1;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.mainPanel, this.c);
        contentPane.add(this.mainPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.okButton = new JButton("OK");
        this.okButton.setVisible(this.editable);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JBDialog.this.okAction();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JBDialog.this.cancelAction();
            }
        });
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        if (this.editable) {
            this.getRootPane().setDefaultButton(this.okButton);
        } else {
            this.getRootPane().setDefaultButton(this.cancelButton);
        }
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 13;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(buttonPanel, this.c);
        contentPane.add(buttonPanel);
        Point lastDialogLocation = this.getParent().getLocation();
        lastDialogLocation.x += 40;
        lastDialogLocation.y += 40;
        this.setLocation(lastDialogLocation);
        this.pack();
        RegistryBrowser.getInstance().addPropertyChangeListener(RegistryBrowser.PROPERTY_AUTHENTICATED, this);
    }

    public int getStatus() {
        return this.status;
    }

    protected void okAction() {
        try {
            this.validateInput();
            this.status = 1;
            this.dispose();
        }
        catch (Exception e) {
            this.status = 2;
            RegistryBrowser.displayError(e);
        }
    }

    protected void cancelAction() {
        this.status = 0;
        this.dispose();
    }

    protected void validateInput() throws JAXRException {
    }

    protected void clear() throws JAXRException {
        this.cancelAction();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.okButton.setVisible(editable);
        if (editable) {
            this.getRootPane().setDefaultButton(this.okButton);
        } else {
            this.getRootPane().setDefaultButton(this.cancelButton);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals(RegistryBrowser.PROPERTY_AUTHENTICATED)) {
            boolean authenticated = (Boolean)ev.getNewValue();
            this.setEditable(authenticated);
        }
    }
}

