/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.JBEditorDialog;
import com.sun.xml.registry.client.browser.JBListModel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.JAXRException;

public class JBList
extends JList {
    private JPopupMenu popup = null;
    private JMenuItem editMenuItem = null;
    private JMenuItem insertMenuItem = null;
    private JMenuItem removeMenuItem = null;
    private MouseListener popupListener;
    private String interfaceName = null;
    protected boolean editable = RegistryBrowser.getInstance().isAuthenticated();

    private JBList() {
    }

    public JBList(String interfaceName) {
        this.JBList_initialize(interfaceName);
    }

    public JBList(String interfaceName, JBListModel model) {
        super(model);
        this.JBList_initialize(interfaceName);
    }

    private void JBList_initialize(String interfaceName) {
        this.interfaceName = interfaceName;
        this.setToolTipText("Use right mouse button to perform actions (e.g. edit, insert, remove)");
        this.createPopup();
    }

    private void createPopup() {
        this.popup = new JPopupMenu();
        this.editMenuItem = this.editable ? new JMenuItem("Edit") : new JMenuItem("Show Details");
        this.popup.add(this.editMenuItem);
        this.insertMenuItem = new JMenuItem("Insert");
        this.removeMenuItem = new JMenuItem("Remove");
        if (this.editable) {
            this.popup.add(this.insertMenuItem);
            this.popup.add(this.removeMenuItem);
        }
        this.editMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JBList.this.editAction();
            }
        });
        this.insertMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JBList.this.insertAction();
            }
        });
        this.removeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JBList.this.removeAction();
            }
        });
        this.popupListener = new PopupListener();
        this.addMouseListener(this.popupListener);
    }

    protected void editAction() {
        int[] selectedIndices = this.getSelectedIndices();
        if (selectedIndices.length == 1) {
            Object selectedObject = this.getSelectedValue();
            if (selectedObject != null) {
                JBEditorDialog.showObjectDetails(this, selectedObject, true, this.editable);
            }
        } else if (this.getModel().getSize() > 0) {
            RegistryBrowser.displayError("Exactly one object must be selected in list for edit action.");
        } else {
            RegistryBrowser.displayInfo("Select action on list by clicking the right mouse button once.");
        }
    }

    protected void insertAction() {
        int index = this.getMaxSelectionIndex();
        JBListModel model = (JBListModel)this.getModel();
        if (index < 0) {
            index = model.getSize();
        }
        try {
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            BusinessLifeCycleManager lcm = client.getBusinessLifeCycleManager();
            Object elementModel = null;
            try {
                Class<?> cls = Class.forName(this.interfaceName);
                elementModel = cls.newInstance();
            }
            catch (ClassNotFoundException e) {
                elementModel = lcm.createObject(this.interfaceName);
            }
            catch (InstantiationException e) {
                throw new JAXRException(e);
            }
            catch (IllegalAccessException e) {
                throw new JAXRException(e);
            }
            JBEditorDialog dialog = JBEditorDialog.showObjectDetails(this, elementModel, true, this.editable);
            if (dialog.getStatus() == 1) {
                model.add(index, elementModel);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    protected void removeAction() {
        int[] selectedIndices = this.getSelectedIndices();
        if (selectedIndices.length >= 1) {
            Object selectedObject = this.getSelectedValue();
            if (selectedObject != null) {
                JBListModel model = (JBListModel)this.getModel();
                model.removeElementAt(selectedIndices[0]);
            }
        } else {
            RegistryBrowser.displayError("One or more objects must be selected in list for remove action.");
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.createPopup();
    }

    public boolean isEditable() {
        return this.editable;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() > 1) {
                JBList.this.editAction();
            } else {
                this.maybeShowPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int[] selectedIndices = JBList.this.getSelectedIndices();
                if (selectedIndices.length == 0) {
                    JBList.this.editMenuItem.setEnabled(false);
                    JBList.this.insertMenuItem.setEnabled(true);
                    JBList.this.removeMenuItem.setEnabled(false);
                } else if (selectedIndices.length == 1) {
                    JBList.this.editMenuItem.setEnabled(true);
                    JBList.this.insertMenuItem.setEnabled(true);
                    JBList.this.removeMenuItem.setEnabled(true);
                } else if (selectedIndices.length > 1) {
                    JBList.this.editMenuItem.setEnabled(false);
                    JBList.this.insertMenuItem.setEnabled(true);
                    JBList.this.removeMenuItem.setEnabled(true);
                }
                JBList.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

