/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JBDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class LocaleSelectorDialog
extends JBDialog {
    private JComboBox jcbAvailableLocales;
    private JComboBox jcbCustomCountry;
    private JLabel jlSelectLocale;
    private JCheckBox jchbCountry;
    private JCheckBox jchbVariant;
    private JRadioButton jrbAvailableLocales;
    private JRadioButton jrbCustom;
    private JComboBox jcbCustomLanguage;
    private JPanel jPanel1;
    private ButtonGroup bgSelectionMode;
    private JTextField jtfVariant;
    private Locale selectedLocale = null;

    public LocaleSelectorDialog(Locale initialLocale, JFrame parent, boolean modal) {
        super(parent, modal);
        this.LocaleSelectorDialog_initialize(initialLocale);
    }

    public LocaleSelectorDialog(Locale initialLocale, JDialog parent, boolean modal) {
        super(parent, modal);
        this.LocaleSelectorDialog_initialize(initialLocale);
    }

    private void LocaleSelectorDialog_initialize(Locale initialLocale) {
        this.setEditable(true);
        this.selectedLocale = initialLocale;
        this.setTitle("Locale Selector Dialog");
        this.jPanel1 = this.getMainPanel();
        this.jPanel1.setLayout(new GridBagLayout());
        this.bgSelectionMode = new ButtonGroup();
        this.jlSelectLocale = new JLabel();
        this.jrbAvailableLocales = new JRadioButton();
        this.jrbCustom = new JRadioButton();
        this.jcbAvailableLocales = new JComboBox();
        this.jcbCustomLanguage = new JComboBox();
        this.jcbCustomCountry = new JComboBox();
        this.jchbCountry = new JCheckBox();
        this.jchbVariant = new JCheckBox();
        this.jtfVariant = new JTextField();
        this.jlSelectLocale.setText("Select Locale : ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jlSelectLocale, gridBagConstraints);
        this.jrbAvailableLocales.setSelected(true);
        this.jrbAvailableLocales.setText("Available Locales : ");
        this.jrbAvailableLocales.setToolTipText("Select a Locale from the available Locales");
        this.bgSelectionMode.add(this.jrbAvailableLocales);
        this.jrbAvailableLocales.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleSelectorDialog.this.jrbAvailableLocalesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jrbAvailableLocales, gridBagConstraints);
        this.jrbCustom.setText("Custom Language:");
        this.jrbCustom.setToolTipText("Customize a Locale by selecting a language (and if needed, a country)");
        this.bgSelectionMode.add(this.jrbCustom);
        this.jrbCustom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleSelectorDialog.this.jrbCustomActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jrbCustom, gridBagConstraints);
        this.jcbAvailableLocales.setModel(this.getAvailableLocalesCBModel());
        this.jcbAvailableLocales.setSelectedItem(this.selectedLocale);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jcbAvailableLocales, gridBagConstraints);
        this.jcbCustomLanguage.setModel(this.getCustomLanguageCBModel());
        this.jcbCustomLanguage.setSelectedItem(this.selectedLocale.getLanguage());
        this.jcbCustomLanguage.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jcbCustomLanguage, gridBagConstraints);
        this.jcbCustomCountry.setModel(this.getCustomCountryCBModel());
        this.jcbCustomCountry.setSelectedItem(this.selectedLocale.getCountry());
        this.jcbCustomCountry.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jcbCustomCountry, gridBagConstraints);
        this.jchbCountry.setText("Custom Country : ");
        this.jchbCountry.setEnabled(false);
        this.jchbCountry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleSelectorDialog.this.jchbCountryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 12, 0, 4);
        this.jPanel1.add((Component)this.jchbCountry, gridBagConstraints);
        if (this.selectedLocale.getVariant() != null) {
            this.jtfVariant.setText(this.selectedLocale.getVariant());
        }
        this.jtfVariant.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jtfVariant, gridBagConstraints);
        this.jchbVariant.setText("Custom Variant : ");
        this.jchbVariant.setEnabled(false);
        this.jchbVariant.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleSelectorDialog.this.jchbVariantActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 12, 0, 4);
        this.jPanel1.add((Component)this.jchbVariant, gridBagConstraints);
        this.pack();
    }

    private void jchbCountryActionPerformed(ActionEvent evt) {
        this.jcbCustomCountry.setEnabled(this.jchbCountry.isSelected());
        this.jchbVariant.setEnabled(this.jchbCountry.isSelected());
        this.jtfVariant.setEnabled(this.jchbCountry.isSelected() && this.jchbVariant.isSelected());
    }

    private void jchbVariantActionPerformed(ActionEvent evt) {
        this.jtfVariant.setEnabled(this.jchbVariant.isSelected());
    }

    private void jrbCustomActionPerformed(ActionEvent evt) {
        this.jcbAvailableLocales.setEnabled(false);
        this.jcbCustomLanguage.setEnabled(true);
        this.jchbCountry.setEnabled(true);
        this.jcbCustomCountry.setEnabled(this.jchbCountry.isSelected());
        this.jchbVariant.setEnabled(this.jchbCountry.isSelected());
        this.jtfVariant.setEnabled(this.jchbVariant.isSelected());
    }

    private void jrbAvailableLocalesActionPerformed(ActionEvent evt) {
        this.jcbAvailableLocales.setEnabled(true);
        this.jcbCustomLanguage.setEnabled(false);
        this.jcbCustomCountry.setEnabled(false);
        this.jchbCountry.setEnabled(false);
        this.jchbVariant.setEnabled(false);
        this.jtfVariant.setEnabled(false);
    }

    private ComboBoxModel getAvailableLocalesCBModel() {
        return new DefaultComboBoxModel<Locale>(Locale.getAvailableLocales());
    }

    private ComboBoxModel getCustomLanguageCBModel() {
        return new DefaultComboBoxModel<String>(Locale.getISOLanguages());
    }

    private ComboBoxModel getCustomCountryCBModel() {
        return new DefaultComboBoxModel<String>(Locale.getISOCountries());
    }

    protected void okAction() {
        super.okAction();
        this.selectedLocale = this.jrbAvailableLocales.isSelected() ? (Locale)this.jcbAvailableLocales.getSelectedItem() : (!this.jchbCountry.isSelected() ? new Locale((String)this.jcbCustomLanguage.getSelectedItem()) : (!this.jchbVariant.isSelected() || this.jtfVariant.getText().trim().length() == 0 ? new Locale((String)this.jcbCustomLanguage.getSelectedItem(), (String)this.jcbCustomCountry.getSelectedItem()) : new Locale((String)this.jcbCustomLanguage.getSelectedItem(), (String)this.jcbCustomCountry.getSelectedItem(), this.jtfVariant.getText())));
        Locale.setDefault(this.selectedLocale);
        this.dispose();
    }

    public Locale getSelectedLocale() {
        return this.selectedLocale;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        LocaleSelectorDialog localeSelector = new LocaleSelectorDialog(Locale.getDefault(), frame, true);
        localeSelector.show();
        System.out.println("Selected Locale was: " + localeSelector.getSelectedLocale());
        frame.dispose();
    }
}

