/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JBList;
import com.sun.xml.registry.client.browser.JBListModel;
import com.sun.xml.registry.client.browser.JBPanel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Slot;

public class SlotPanel
extends JBPanel {
    JTextField nameText = null;
    JTextField typeText = null;
    JBList valuesList = null;
    protected GridBagConstraints c = null;
    protected GridBagLayout gbl = null;

    public SlotPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Slot Details"));
        this.gbl = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(this.gbl);
        JLabel nameLabel = new JLabel("Name:", 2);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(nameLabel, this.c);
        this.add(nameLabel);
        this.nameText = new JTextField();
        this.nameText.setEditable(this.editable);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 13;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(this.nameText, this.c);
        this.add(this.nameText);
        JLabel typeLabel = new JLabel("Type:", 2);
        this.c.gridx = 1;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(typeLabel, this.c);
        this.add(typeLabel);
        this.typeText = new JTextField();
        this.typeText.setEditable(this.editable);
        this.c.gridx = 1;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.typeText, this.c);
        this.add(this.typeText);
        JLabel idLabel = new JLabel("Values:", 2);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(idLabel, this.c);
        this.add(idLabel);
        this.valuesList = new JBList("java.lang.StringBuffer");
        this.valuesList.setEditable(this.editable);
        this.valuesList.setModel(new JBListModel());
        this.valuesList.setVisibleRowCount(5);
        JScrollPane valuesListScrollPane = new JScrollPane(this.valuesList);
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(valuesListScrollPane, this.c);
        this.add(valuesListScrollPane);
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof Slot)) {
            throw new InvalidRequestException("Expecting a Slot. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        Slot slot = (Slot)obj;
        try {
            if (slot != null) {
                Collection values;
                String slotType;
                String slotName = slot.getName();
                if (slotName != null) {
                    this.nameText.setText(slotName);
                }
                if ((slotType = slot.getSlotType()) != null) {
                    this.typeText.setText(slotType);
                }
                if ((values = slot.getValues()) != null) {
                    JBListModel valuesListModel = (JBListModel)this.valuesList.getModel();
                    Iterator iter = values.iterator();
                    while (iter.hasNext()) {
                        StringBuffer value = new StringBuffer((String)iter.next());
                        valuesListModel.addElement(value);
                    }
                }
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            Slot slot = (Slot)this.model;
            slot.setName(this.nameText.getText());
            slot.setSlotType(this.typeText.getText());
            JBListModel valuesListModel = (JBListModel)this.valuesList.getModel();
            ArrayList<String> values = new ArrayList<String>();
            Object[] valuesArray = valuesListModel.toArray();
            for (int i = 0; i < valuesArray.length; ++i) {
                values.add(valuesArray[i].toString());
            }
            slot.setValues(values);
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        Slot slot = (Slot)this.model;
        if (this.nameText.getText().length() > 128) {
            throw new JAXRException("Error. Slot.name length must be <= 128");
        }
        JBListModel valuesListModel = (JBListModel)this.valuesList.getModel();
        ArrayList values = new ArrayList();
        Object[] valuesArray = valuesListModel.toArray();
        for (int i = 0; i < valuesArray.length; ++i) {
            String value = valuesArray[i].toString();
            if (value.length() <= 128) continue;
            throw new JAXRException("Error. Slot.value length must be <= 128");
        }
    }

    public void clear() throws JAXRException {
        super.clear();
        this.nameText.setText("");
        this.typeText.setText("");
        this.valuesList.setModel(new JBListModel());
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.nameText.setEditable(editable);
        this.typeText.setEditable(editable);
        this.valuesList.setEditable(editable);
    }
}

