/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.EmailAddressPanel;
import com.sun.xml.registry.client.browser.PersonNamePanel;
import com.sun.xml.registry.client.browser.PostalAddressPanel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectPanel;
import com.sun.xml.registry.client.browser.TelephoneNumberPanel;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class UserPanel
extends RegistryObjectPanel {
    PersonNamePanel personNamePanel = null;
    PostalAddressPanel addressPanel = null;
    TelephoneNumberPanel phonePanel = null;
    EmailAddressPanel emailPanel = null;
    private int firstChildIndex = this.getComponents().length;

    public UserPanel() {
        this.setBorder(BorderFactory.createTitledBorder("User Details"));
        this.personNamePanel = new PersonNamePanel();
        this.personNamePanel.setBorder(BorderFactory.createTitledBorder("Name"));
        this.c.gridx = 0;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 1;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.personNamePanel, this.c);
        this.add(this.personNamePanel);
        this.emailPanel = new EmailAddressPanel();
        this.emailPanel.setBorder(BorderFactory.createTitledBorder("Email Address"));
        this.c.gridx = 1;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 1;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.emailPanel, this.c);
        this.add(this.emailPanel);
        this.addressPanel = new PostalAddressPanel();
        this.addressPanel.setBorder(BorderFactory.createTitledBorder("Postal Address"));
        this.c.gridx = 0;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 1;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.addressPanel, this.c);
        this.add(this.addressPanel);
        this.phonePanel = new TelephoneNumberPanel();
        this.phonePanel.setBorder(BorderFactory.createTitledBorder("Telephone Number"));
        this.c.gridx = 1;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 1;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.phonePanel, this.c);
        this.add(this.phonePanel);
        this.row += 2;
    }

    protected void hideRegistryObjectAttributes() {
        Component[] children = this.getComponents();
        for (int i = 0; i < this.firstChildIndex; ++i) {
            this.remove(children[i]);
        }
    }

    public User getUser() throws JAXRException {
        User user = null;
        if (this.model != null) {
            user = (User)this.getModel();
        }
        return user;
    }

    public void setUser(User user) throws JAXRException {
        this.setModel(user);
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof User)) {
            throw new InvalidRequestException("Expecting a User. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        User user = (User)obj;
        try {
            if (user != null) {
                ArrayList<TelephoneNumber> phones;
                ArrayList<EmailAddress> emails;
                PersonName personName = user.getPersonName();
                if (personName == null) {
                    personName = user.getLifeCycleManager().createPersonName("", "", "");
                    user.setPersonName(personName);
                }
                this.personNamePanel.setModel(personName);
                ArrayList<PostalAddress> addrs = user.getPostalAddresses();
                if (addrs != null) {
                    PostalAddress address = null;
                    if (addrs.size() == 0) {
                        address = user.getLifeCycleManager().createPostalAddress("", "", "", "", "", "", "");
                        addrs = new ArrayList<PostalAddress>();
                        addrs.add(address);
                        user.setPostalAddresses(addrs);
                    } else {
                        address = (PostalAddress)addrs.iterator().next();
                    }
                    this.addressPanel.setModel(address);
                }
                if ((emails = user.getEmailAddresses()) != null) {
                    EmailAddress email = null;
                    if (emails.size() == 0) {
                        email = user.getLifeCycleManager().createEmailAddress("");
                        emails = new ArrayList<EmailAddress>();
                        emails.add(email);
                        user.setEmailAddresses(emails);
                    } else {
                        email = (EmailAddress)emails.iterator().next();
                    }
                    this.emailPanel.setModel(email);
                }
                if ((phones = user.getTelephoneNumbers(null)) != null) {
                    TelephoneNumber phone = null;
                    if (phones.size() == 0) {
                        phone = user.getLifeCycleManager().createTelephoneNumber();
                        phones = new ArrayList<TelephoneNumber>();
                        phones.add(phone);
                        user.setTelephoneNumbers(phones);
                    } else {
                        phone = (TelephoneNumber)phones.iterator().next();
                    }
                    this.phonePanel.setModel(phones.iterator().next());
                }
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            this.personNamePanel.getModel();
            this.addressPanel.getModel();
            this.emailPanel.getModel();
            this.phonePanel.getModel();
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        User user = (User)this.model;
        this.personNamePanel.validateInput();
        this.addressPanel.validateInput();
        this.emailPanel.validateInput();
        this.phonePanel.validateInput();
    }

    public void clear() throws JAXRException {
        super.clear();
        this.personNamePanel.clear();
        this.addressPanel.clear();
        this.emailPanel.clear();
        this.phonePanel.clear();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.personNamePanel.setEditable(editable);
        this.addressPanel.setEditable(editable);
        this.emailPanel.setEditable(editable);
        this.phonePanel.setEditable(editable);
    }
}

