/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.graph;

import com.jgraph.graph.BasicMarqueeHandler;
import com.jgraph.graph.CellView;
import com.jgraph.graph.DefaultGraphCell;
import com.jgraph.graph.GraphConstants;
import com.jgraph.graph.Port;
import com.jgraph.graph.PortView;
import com.sun.xml.registry.client.browser.graph.JBGraph;
import com.sun.xml.registry.client.browser.graph.JBGraphCell;
import com.sun.xml.registry.ebxml.infomodel.ExtrinsicObjectImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class JBMarqueeHandler
extends BasicMarqueeHandler {
    JBGraph graph = null;
    protected Point start;
    protected Point current;
    protected PortView port;
    protected PortView firstPort;

    public JBMarqueeHandler(JBGraph graph) {
        this.graph = graph;
    }

    public boolean isForceMarqueeEvent(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return true;
        }
        this.port = this.getSourcePortAt(e.getPoint());
        if (this.port != null && this.graph.isPortsVisible()) {
            return true;
        }
        return super.isForceMarqueeEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            JBGraphCell _cell;
            Point loc = this.graph.fromScreen(e.getPoint());
            Object cell = this.graph.getFirstCellForLocation(loc.x, loc.y);
            if (!(cell instanceof JBGraphCell) && cell instanceof DefaultGraphCell && (_cell = this.graph.getJBGraphCellAt((DefaultGraphCell)cell, loc.x, loc.y)) != null) {
                cell = _cell;
            }
            JPopupMenu menu = this.createPopupMenu(e.getPoint(), cell);
            menu.show((Component)((Object)this.graph), e.getX(), e.getY());
        } else if (this.port != null && !e.isConsumed() && this.graph.isPortsVisible()) {
            this.start = this.graph.toScreen(this.port.getLocation(null));
            this.firstPort = this.port;
            e.consume();
        } else {
            super.mousePressed(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.start != null && !e.isConsumed()) {
            Graphics g = this.graph.getGraphics();
            this.paintConnector(Color.black, this.graph.getBackground(), g);
            this.port = this.getTargetPortAt(e.getPoint());
            this.current = this.port != null ? this.graph.toScreen(this.port.getLocation(null)) : this.graph.snap(e.getPoint());
            this.paintConnector(this.graph.getBackground(), Color.black, g);
            e.consume();
        }
        super.mouseDragged(e);
    }

    public PortView getSourcePortAt(Point point) {
        Point tmp = this.graph.fromScreen(new Point(point));
        return this.graph.getPortViewAt(tmp.x, tmp.y);
    }

    protected PortView getTargetPortAt(Point point) {
        Object cell = this.graph.getFirstCellForLocation(point.x, point.y);
        for (int i = 0; i < this.graph.getModel().getChildCount(cell); ++i) {
            Object tmp = this.graph.getModel().getChild(cell, i);
            tmp = this.graph.getView().getMapping(tmp, false);
            if (!(tmp instanceof PortView) || tmp == this.firstPort) continue;
            return (PortView)tmp;
        }
        return this.getSourcePortAt(point);
    }

    public void mouseReleased(MouseEvent e) {
        if (e != null && !e.isConsumed() && this.port != null && this.firstPort != null && this.firstPort != this.port) {
            this.graph.connect((Port)this.firstPort.getCell(), (Port)this.port.getCell());
            e.consume();
        } else {
            this.graph.repaint();
        }
        this.port = null;
        this.firstPort = null;
        this.current = null;
        this.start = null;
        super.mouseReleased(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (e != null && this.getSourcePortAt(e.getPoint()) != null && !e.isConsumed() && this.graph.isPortsVisible()) {
            this.graph.setCursor(new Cursor(12));
            e.consume();
        }
        super.mouseReleased(e);
    }

    protected void paintConnector(Color fg, Color bg, Graphics g) {
        g.setColor(fg);
        g.setXORMode(bg);
        this.paintPort(this.graph.getGraphics());
        if (this.firstPort != null && this.start != null && this.current != null) {
            g.drawLine(this.start.x, this.start.y, this.current.x, this.current.y);
        }
    }

    protected void paintPort(Graphics g) {
        if (this.port != null) {
            boolean o = GraphConstants.getOffset((Map)this.port.getAttributes()) != null;
            Rectangle r = o ? this.port.getBounds() : this.port.getParentView().getBounds();
            r = this.graph.toScreen(new Rectangle(r));
            r.setBounds(r.x - 3, r.y - 3, r.width + 6, r.height + 6);
            this.graph.getUI().paintCell(g, (CellView)this.port, r, true);
        }
    }

    public JPopupMenu createPopupMenu(final Point pt, final Object cell) {
        JPopupMenu menu = new JPopupMenu();
        boolean editable = this.graph.isEditable();
        if (cell != null && cell instanceof JBGraphCell) {
            String editLabel = null;
            editLabel = editable ? "Edit" : "Show Details";
            menu.add(new AbstractAction(editLabel){

                public void actionPerformed(ActionEvent e) {
                    JBMarqueeHandler.this.graph.editCell((JBGraphCell)((Object)cell));
                }
            });
            menu.add(new AbstractAction("Show Related Objects"){

                public void actionPerformed(ActionEvent e) {
                    JBMarqueeHandler.this.graph.showRelatedObjects((JBGraphCell)((Object)cell));
                }
            });
            menu.add(new AbstractAction("Browse as Graph"){

                public void actionPerformed(ActionEvent e) {
                    JBMarqueeHandler.this.graph.browseObject((JBGraphCell)((Object)cell));
                }
            });
            menu.add(new AbstractAction("Show Audit Trail"){

                public void actionPerformed(ActionEvent e) {
                    JBMarqueeHandler.this.graph.showAuditTrail((JBGraphCell)((Object)cell));
                }
            });
            if (((JBGraphCell)((Object)cell)).getRegistryObject() instanceof ExtrinsicObjectImpl) {
                menu.add(new AbstractAction("Retrieve Item"){

                    public void actionPerformed(ActionEvent e) {
                        JBMarqueeHandler.this.graph.retrieveItem((JBGraphCell)((Object)cell));
                    }
                });
            }
        }
        if (!this.graph.isSelectionEmpty()) {
            menu.addSeparator();
            if (editable) {
                menu.add(new AbstractAction("Remove"){

                    public void actionPerformed(ActionEvent e) {
                        JBMarqueeHandler.this.graph.remove.actionPerformed(e);
                    }
                });
            }
            if (this.graph.getSelectionCount() > 1) {
                menu.add(new AbstractAction("ReLayout"){

                    public void actionPerformed(ActionEvent e) {
                        JBGraph.circleLayout(JBMarqueeHandler.this.graph);
                    }
                });
            }
        }
        menu.addSeparator();
        if (editable) {
            menu.add(new AbstractAction("Insert"){

                public void actionPerformed(ActionEvent ev) {
                    JBMarqueeHandler.this.graph.insert(pt);
                }
            });
            menu.add(new AbstractAction("Save"){

                public void actionPerformed(ActionEvent ev) {
                    JBMarqueeHandler.this.graph.save();
                }
            });
        }
        menu.add(new AbstractAction("Export"){

            public void actionPerformed(ActionEvent ev) {
                JBMarqueeHandler.this.graph.export();
            }
        });
        return menu;
    }
}

