/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.registration;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.security.Identity;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.registry.JAXRException;
import sun.misc.BASE64Encoder;
import sun.security.pkcs.PKCS10;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;
import sun.security.util.DerOutputStream;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class KeyTool {
    private boolean debug = false;
    private String command = null;
    private String sigAlgName = null;
    private String keyAlgName = "DSA";
    private boolean verbose = false;
    private int keysize = 1024;
    private boolean rfc = false;
    private int validity = 90;
    private String alias = null;
    private String dname = null;
    private String keyAlias = "mykey";
    private String dest = null;
    private String filename = null;
    private Vector providers = null;
    private String storetype = null;
    private char[] storePass = null;
    private char[] storePassNew = null;
    private char[] keyPass = null;
    private char[] keyPassNew = null;
    private char[] oldPass = null;
    private char[] newPass = null;
    private String ksfname = null;
    private File ksfile = null;
    private InputStream ksStream = null;
    private InputStream inStream = null;
    private KeyStore keyStore = null;
    private boolean kssave = false;
    private boolean noprompt = false;
    private boolean trustcacerts = false;
    private CertificateFactory cf = null;
    private KeyStore caks = null;
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.Resources");
    private static final Collator collator = Collator.getInstance();

    public static void main(String[] args) {
        try {
            KeyTool keytool = new KeyTool();
            keytool.run(args, System.out);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void run(String[] as, PrintStream printstream) throws Exception {
        this.parseArgs(as);
        this.doCommands(printstream);
        if (this.storePass != null) {
            Arrays.fill(this.storePass, ' ');
            this.storePass = null;
        }
        if (this.storePassNew != null) {
            Arrays.fill(this.storePassNew, ' ');
            this.storePassNew = null;
        }
        if (this.keyPass != null) {
            Arrays.fill(this.keyPass, ' ');
            this.keyPass = null;
        }
        if (this.keyPassNew != null) {
            Arrays.fill(this.keyPassNew, ' ');
            this.keyPassNew = null;
        }
        if (this.oldPass != null) {
            Arrays.fill(this.oldPass, ' ');
            this.oldPass = null;
        }
        if (this.newPass != null) {
            Arrays.fill(this.newPass, ' ');
            this.newPass = null;
        }
        if (this.storePass != null) {
            Arrays.fill(this.storePass, ' ');
            this.storePass = null;
        }
        if (this.storePassNew != null) {
            Arrays.fill(this.storePassNew, ' ');
            this.storePassNew = null;
        }
        if (this.keyPass != null) {
            Arrays.fill(this.keyPass, ' ');
            this.keyPass = null;
        }
        if (this.keyPassNew != null) {
            Arrays.fill(this.keyPassNew, ' ');
            this.keyPassNew = null;
        }
        if (this.oldPass != null) {
            Arrays.fill(this.oldPass, ' ');
            this.oldPass = null;
        }
        if (this.newPass != null) {
            Arrays.fill(this.newPass, ' ');
            this.newPass = null;
        }
        JAXRException exception1 = new JAXRException("Unknown 2");
        if (this.storePass != null) {
            Arrays.fill(this.storePass, ' ');
            this.storePass = null;
        }
        if (this.storePassNew != null) {
            Arrays.fill(this.storePassNew, ' ');
            this.storePassNew = null;
        }
        if (this.keyPass != null) {
            Arrays.fill(this.keyPass, ' ');
            this.keyPass = null;
        }
        if (this.keyPassNew != null) {
            Arrays.fill(this.keyPassNew, ' ');
            this.keyPassNew = null;
        }
        if (this.oldPass != null) {
            Arrays.fill(this.oldPass, ' ');
            this.oldPass = null;
        }
        if (this.newPass != null) {
            Arrays.fill(this.newPass, ' ');
            this.newPass = null;
        }
    }

    void parseArgs(String[] as) {
        if (as.length == 0) {
            this.usage();
        }
        int i = 0;
        for (i = 0; i < as.length && as[i].startsWith("-"); ++i) {
            String s = as[i];
            if (collator.compare(s, "-certreq") == 0) {
                this.command = "certreq";
                continue;
            }
            if (collator.compare(s, "-delete") == 0) {
                this.command = "delete";
                continue;
            }
            if (collator.compare(s, "-export") == 0) {
                this.command = "export";
                continue;
            }
            if (collator.compare(s, "-genkey") == 0) {
                this.command = "genkey";
                continue;
            }
            if (collator.compare(s, "-help") == 0) {
                this.usage();
                return;
            }
            if (collator.compare(s, "-identitydb") == 0) {
                this.command = "identitydb";
                continue;
            }
            if (collator.compare(s, "-import") == 0) {
                this.command = "import";
                continue;
            }
            if (collator.compare(s, "-keyclone") == 0) {
                this.command = "keyclone";
                continue;
            }
            if (collator.compare(s, "-keypasswd") == 0) {
                this.command = "keypasswd";
                continue;
            }
            if (collator.compare(s, "-list") == 0) {
                this.command = "list";
                continue;
            }
            if (collator.compare(s, "-printcert") == 0) {
                this.command = "printcert";
                continue;
            }
            if (collator.compare(s, "-selfcert") == 0) {
                this.command = "selfcert";
                continue;
            }
            if (collator.compare(s, "-storepasswd") == 0) {
                this.command = "storepasswd";
                continue;
            }
            if (collator.compare(s, "-keystore") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.ksfname = as[i];
                continue;
            }
            if (collator.compare(s, "-storepass") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.storePass = as[i].toCharArray();
                continue;
            }
            if (collator.compare(s, "-storetype") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.storetype = as[i];
                continue;
            }
            if (collator.compare(s, "-keypass") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.keyPass = as[i].toCharArray();
                continue;
            }
            if (collator.compare(s, "-new") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.newPass = as[i].toCharArray();
                continue;
            }
            if (collator.compare(s, "-alias") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.alias = as[i];
                continue;
            }
            if (collator.compare(s, "-dest") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.dest = as[i];
                continue;
            }
            if (collator.compare(s, "-dname") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.dname = as[i];
                continue;
            }
            if (collator.compare(s, "-keysize") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.keysize = Integer.parseInt(as[i]);
                continue;
            }
            if (collator.compare(s, "-keyalg") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.keyAlgName = as[i];
                continue;
            }
            if (collator.compare(s, "-sigalg") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.sigAlgName = as[i];
                continue;
            }
            if (collator.compare(s, "-validity") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.validity = Integer.parseInt(as[i]);
                continue;
            }
            if (collator.compare(s, "-file") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                this.filename = as[i];
                continue;
            }
            if (collator.compare(s, "-provider") == 0) {
                if (++i == as.length) {
                    this.usage();
                }
                if (this.providers == null) {
                    this.providers = new Vector(3);
                }
                this.providers.add(as[i]);
                continue;
            }
            if (collator.compare(s, "-v") == 0) {
                this.verbose = true;
                continue;
            }
            if (collator.compare(s, "-debug") == 0) {
                this.debug = true;
                continue;
            }
            if (collator.compare(s, "-rfc") == 0) {
                this.rfc = true;
                continue;
            }
            if (collator.compare(s, "-noprompt") == 0) {
                this.noprompt = true;
                continue;
            }
            if (collator.compare(s, "-trustcacerts") == 0) {
                this.trustcacerts = true;
                continue;
            }
            System.err.println(rb.getString("Illegal option:  ") + s);
            this.usage();
        }
        if (i < as.length || this.command == null) {
            this.usage();
        }
    }

    void doCommands(PrintStream printstream) throws Exception {
        block69: {
            if (this.validity <= 0) {
                throw new Exception(rb.getString("Validity must be greater than zero"));
            }
            if (this.providers != null) {
                ClassLoader classloader = ClassLoader.getSystemClassLoader();
                Enumeration enumeration = this.providers.elements();
                while (enumeration.hasMoreElements()) {
                    String s1 = (String)enumeration.nextElement();
                    Class<?> class1 = classloader != null ? classloader.loadClass(s1) : Class.forName(s1);
                    Object obj3 = class1.newInstance();
                    if (!(obj3 instanceof Provider)) {
                        MessageFormat messageformat3 = new MessageFormat(rb.getString("provName not a provider"));
                        Object[] aobj3 = new Object[]{s1};
                        throw new Exception(messageformat3.format(aobj3));
                    }
                    Security.addProvider((Provider)obj3);
                }
            }
            if (this.command.equals("list") && this.verbose && this.rfc) {
                System.err.println(rb.getString("Must not specify both -v and -rfc with 'list' command"));
                this.usage();
            }
            if (this.command.equals("genkey") && this.keyPass != null && this.keyPass.length < 6) {
                throw new Exception(rb.getString("Key password must be at least 6 characters"));
            }
            if (this.newPass != null && this.newPass.length < 6) {
                throw new Exception(rb.getString("New password must be at least 6 characters"));
            }
            if (!this.command.equals("printcert")) {
                if (this.ksfname == null) {
                    this.ksfname = System.getProperty("user.home") + File.separator + ".keystore";
                }
                try {
                    this.ksfile = new File(this.ksfname);
                    if (this.ksfile.exists() && this.ksfile.length() == 0L) {
                        throw new Exception(rb.getString("Keystore file exists, but is empty: ") + this.ksfname);
                    }
                    this.ksStream = new FileInputStream(this.ksfile);
                }
                catch (FileNotFoundException filenotfoundexception) {
                    if (this.command.equals("genkey") || this.command.equals("identitydb") || this.command.equals("import")) break block69;
                    throw new Exception(rb.getString("Keystore file does not exist: ") + this.ksfname);
                }
            }
        }
        if (this.command.equals("keyclone") && this.dest == null) {
            this.dest = this.getAlias("destination");
            if (this.dest.equals("")) {
                throw new Exception(rb.getString("Must specify destination alias"));
            }
        }
        if (this.command.equals("delete") && this.alias == null) {
            this.alias = this.getAlias(null);
            if (this.alias.equals("")) {
                throw new Exception(rb.getString("Must specify alias"));
            }
        }
        this.keyStore = this.storetype != null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(KeyStore.getDefaultType());
        this.keyStore.load(this.ksStream, this.storePass);
        if (this.ksStream != null) {
            this.ksStream.close();
        }
        if (this.storePass != null) {
            if (this.ksStream == null && this.storePass.length < 6) {
                throw new Exception(rb.getString("Keystore password must be at least 6 characters"));
            }
        } else {
            if (this.command.equals("certreq") || this.command.equals("delete") || this.command.equals("genkey") || this.command.equals("import") || this.command.equals("keyclone") || this.command.equals("selfcert") || this.command.equals("storepasswd") || this.command.equals("keypasswd") || this.command.equals("identitydb")) {
                int i = 0;
                do {
                    System.err.print(rb.getString("Enter keystore password:  "));
                    System.err.flush();
                    this.storePass = this.readPasswd(System.in);
                    if (this.ksStream != null || this.storePass.length >= 6) continue;
                    System.err.println(rb.getString("Keystore password is too short - must be at least 6 characters"));
                    this.storePass = null;
                } while (this.storePass == null && ++i < 3);
                if (this.storePass == null) {
                    System.err.println(rb.getString("Too many failures - try later"));
                    return;
                }
            } else if (!this.command.equals("printcert")) {
                System.err.print(rb.getString("Enter keystore password:  "));
                System.err.flush();
                this.storePass = this.readPasswd(System.in);
            }
            if (this.ksStream != null) {
                this.ksStream = new FileInputStream(this.ksfile);
                this.keyStore.load(this.ksStream, this.storePass);
                this.ksStream.close();
            }
        }
        if (this.command.equals("printcert") || this.command.equals("import") || this.command.equals("identitydb")) {
            this.cf = CertificateFactory.getInstance("X509");
        }
        if (this.trustcacerts) {
            this.caks = this.getCacertsKeyStore();
        }
        if (this.command.equals("certreq")) {
            if (this.filename != null) {
                PrintStream printstream1;
                printstream = printstream1 = new PrintStream(new FileOutputStream(this.filename));
            }
            this.doCertReq(this.alias, this.sigAlgName, printstream);
            if (this.verbose && this.filename != null) {
                MessageFormat messageformat = new MessageFormat(rb.getString("Certification request stored in file <filename>"));
                Object[] aobj = new Object[]{this.filename};
                System.err.println(messageformat.format(aobj));
                System.err.println(rb.getString("Submit this to your CA"));
            }
        } else if (this.command.equals("delete")) {
            this.doDeleteEntry(this.alias);
            this.kssave = true;
        } else if (this.command.equals("export")) {
            if (this.filename != null) {
                PrintStream printstream2;
                printstream = printstream2 = new PrintStream(new FileOutputStream(this.filename));
            }
            this.doExportCert(this.alias, printstream);
            if (this.filename != null) {
                MessageFormat messageformat1 = new MessageFormat(rb.getString("Certificate stored in file <filename>"));
                Object[] aobj1 = new Object[]{this.filename};
                System.err.println(messageformat1.format(aobj1));
            }
        } else if (this.command.equals("genkey")) {
            this.doGenKeyPair(this.alias, this.dname, this.keyAlgName, this.keysize, this.sigAlgName);
            this.kssave = true;
        } else if (this.command.equals("identitydb")) {
            InputStream obj = System.in;
            if (this.filename != null) {
                obj = new FileInputStream(this.filename);
            }
            this.doImportIdentityDatabase(obj);
        } else if (this.command.equals("import")) {
            String s;
            InputStream obj1 = System.in;
            if (this.filename != null) {
                obj1 = new FileInputStream(this.filename);
            }
            String string = s = this.alias == null ? this.keyAlias : this.alias;
            if (this.keyStore.isKeyEntry(s)) {
                this.kssave = this.installReply(s, obj1);
                if (this.kssave) {
                    System.err.println(rb.getString("Certificate reply was installed in keystore"));
                } else {
                    System.err.println(rb.getString("Certificate reply was not installed in keystore"));
                }
            } else {
                this.kssave = this.addTrustedCert(s, obj1);
                if (this.kssave) {
                    System.err.println(rb.getString("Certificate was added to keystore"));
                } else {
                    System.err.println(rb.getString("Certificate was not added to keystore"));
                }
            }
        } else if (this.command.equals("keyclone")) {
            this.keyPassNew = this.newPass;
            this.doCloneKey(this.alias, this.dest);
            this.kssave = true;
        } else if (this.command.equals("keypasswd")) {
            this.keyPassNew = this.newPass;
            this.doChangeKeyPasswd(this.alias);
            this.kssave = true;
        } else if (this.command.equals("list")) {
            if (this.alias != null) {
                this.doPrintEntry(this.alias, printstream, true);
            } else {
                this.doPrintEntries(printstream);
            }
        } else if (this.command.equals("printcert")) {
            InputStream obj2 = System.in;
            if (this.filename != null) {
                obj2 = new FileInputStream(this.filename);
            }
            this.doPrintCert(obj2, printstream);
        } else if (this.command.equals("selfcert")) {
            this.doSelfCert(this.alias, this.dname, this.sigAlgName);
            this.kssave = true;
        } else if (this.command.equals("storepasswd")) {
            this.storePassNew = this.newPass;
            if (this.storePassNew == null) {
                this.storePassNew = this.getNewPasswd("keystore password", this.storePass);
            }
            this.kssave = true;
        }
        if (this.kssave) {
            if (this.verbose) {
                MessageFormat messageformat2 = new MessageFormat(rb.getString("[Saving ksfname]"));
                Object[] aobj2 = new Object[]{this.ksfname};
                System.err.println(messageformat2.format(aobj2));
            }
            FileOutputStream fileoutputstream = new FileOutputStream(this.ksfname);
            this.keyStore.store(fileoutputstream, this.storePassNew == null ? this.storePass : this.storePassNew);
            fileoutputstream.close();
        }
    }

    private void doCertReq(String s, String s1, PrintStream printstream) throws Exception {
        Certificate certificate;
        if (s == null) {
            s = this.keyAlias;
        }
        Object[] aobj = this.recoverPrivateKey(s, this.storePass, this.keyPass);
        PrivateKey privatekey = (PrivateKey)aobj[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])aobj[1];
        }
        if ((certificate = this.keyStore.getCertificate(s)) == null) {
            MessageFormat messageformat = new MessageFormat(rb.getString("alias has no public key (certificate)"));
            Object[] aobj1 = new Object[]{s};
            throw new Exception(messageformat.format(aobj1));
        }
        PKCS10 pkcs10 = new PKCS10(certificate.getPublicKey());
        if (s1 == null) {
            String s2 = privatekey.getAlgorithm();
            if (s2.equalsIgnoreCase("DSA") || s2.equalsIgnoreCase("DSS")) {
                s1 = "SHA1WithDSA";
            } else if (s2.equalsIgnoreCase("RSA")) {
                s1 = "MD5WithRSA";
            } else {
                throw new Exception(rb.getString("Cannot derive signature algorithm"));
            }
        }
        Signature signature = Signature.getInstance(s1);
        signature.initSign(privatekey);
        X500Name x500name = new X500Name(((Object)((X509Certificate)certificate).getSubjectDN()).toString());
        X500Signer x500signer = new X500Signer(signature, x500name);
        pkcs10.encodeAndSign(x500signer);
        pkcs10.print(printstream);
    }

    private void doDeleteEntry(String s) throws Exception {
        if (!this.keyStore.containsAlias(s)) {
            MessageFormat messageformat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] aobj = new Object[]{s};
            throw new Exception(messageformat.format(aobj));
        }
        this.keyStore.deleteEntry(s);
    }

    private void doExportCert(String s, PrintStream printstream) throws Exception {
        if (this.storePass == null) {
            this.printWarning();
        }
        if (s == null) {
            s = this.keyAlias;
        }
        if (!this.keyStore.containsAlias(s)) {
            MessageFormat messageformat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] aobj = new Object[]{s};
            throw new Exception(messageformat.format(aobj));
        }
        X509Certificate x509certificate = (X509Certificate)this.keyStore.getCertificate(s);
        if (x509certificate == null) {
            MessageFormat messageformat1 = new MessageFormat(rb.getString("Alias <alias> has no certificate"));
            Object[] aobj1 = new Object[]{s};
            throw new Exception(messageformat1.format(aobj1));
        }
        this.dumpCert(x509certificate, printstream);
    }

    private void doGenKeyPair(String s, String s1, String s2, int i, String s3) throws Exception {
        if (s == null) {
            s = this.keyAlias;
        }
        if (this.keyStore.containsAlias(s)) {
            MessageFormat messageformat = new MessageFormat(rb.getString("Key pair not generated, alias <alias> already exists"));
            Object[] aobj = new Object[]{s};
            throw new Exception(messageformat.format(aobj));
        }
        if (s3 == null) {
            if (s2.equalsIgnoreCase("DSA")) {
                s3 = "SHA1WithDSA";
            } else if (s2.equalsIgnoreCase("RSA")) {
                s3 = "MD5WithRSA";
            } else {
                throw new Exception(rb.getString("Cannot derive signature algorithm"));
            }
        }
        CertAndKeyGen certandkeygen = new CertAndKeyGen(s2, s3);
        X500Name x500name = s1 == null ? this.getX500Name() : new X500Name(s1);
        if (this.verbose) {
            MessageFormat messageformat1 = new MessageFormat(rb.getString("Generating keysize bit keyAlgName key pair and self-signed certificate (sigAlgName)\n\tfor: x500Name"));
            Object[] aobj1 = new Object[]{new Integer(i), s2, s3, x500name};
            System.err.println(messageformat1.format(aobj1));
        }
        certandkeygen.generate(i);
        PrivateKey privatekey = certandkeygen.getPrivateKey();
        Certificate[] ax509certificate = new X509Certificate[]{certandkeygen.getSelfCertificate(x500name, (long)(this.validity * 24 * 60 * 60))};
        if (this.keyPass == null) {
            int j;
            for (j = 0; j < 3 && this.keyPass == null; ++j) {
                MessageFormat messageformat2 = new MessageFormat(rb.getString("Enter key password for <alias>"));
                Object[] aobj2 = new Object[]{s};
                System.err.println(messageformat2.format(aobj2));
                System.err.print(rb.getString("\t(RETURN if same as keystore password):  "));
                System.err.flush();
                this.keyPass = this.readPasswd(System.in);
                if (this.keyPass == null) {
                    this.keyPass = this.storePass;
                    continue;
                }
                if (this.keyPass.length >= 6) continue;
                System.err.println(rb.getString("Key password is too short - must be at least 6 characters"));
                this.keyPass = null;
            }
            if (j == 3) {
                throw new Exception(rb.getString("Too many failures - key not added to keystore"));
            }
        }
        this.keyStore.setKeyEntry(s, privatekey, this.keyPass, ax509certificate);
    }

    private void doCloneKey(String s, String s1) throws Exception {
        if (s == null) {
            s = this.keyAlias;
        }
        if (this.keyStore.containsAlias(s1)) {
            MessageFormat messageformat = new MessageFormat(rb.getString("Destination alias <dest> already exists"));
            Object[] aobj1 = new Object[]{s1};
            throw new Exception(messageformat.format(aobj1));
        }
        Object[] aobj = this.recoverPrivateKey(s, this.storePass, this.keyPass);
        PrivateKey privatekey = (PrivateKey)aobj[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])aobj[1];
        }
        if (this.keyPassNew == null) {
            int i = 0;
            do {
                this.keyPassNew = this.getKeyPasswd(s1, s, this.keyPass);
                if (this.keyPassNew.length >= 6) continue;
                System.err.println(rb.getString("Password is too short - must be at least 6 characters"));
                this.keyPassNew = null;
            } while (this.keyPassNew == null && ++i < 3);
            if (this.keyPassNew == null) {
                throw new Exception(rb.getString("Too many failures. Key entry not cloned"));
            }
        }
        this.keyStore.setKeyEntry(s1, privatekey, this.keyPassNew, this.keyStore.getCertificateChain(s));
    }

    private void doChangeKeyPasswd(String s) throws Exception {
        if (s == null) {
            s = this.keyAlias;
        }
        Object[] aobj = this.recoverPrivateKey(s, this.storePass, this.keyPass);
        PrivateKey privatekey = (PrivateKey)aobj[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])aobj[1];
        }
        if (this.keyPassNew == null) {
            MessageFormat messageformat = new MessageFormat(rb.getString("key password for <alias>"));
            Object[] aobj1 = new Object[]{s};
            this.keyPassNew = this.getNewPasswd(messageformat.format(aobj1), this.keyPass);
        }
        this.keyStore.setKeyEntry(s, privatekey, this.keyPassNew, this.keyStore.getCertificateChain(s));
    }

    private void doImportIdentityDatabase(InputStream inputstream) throws Exception {
        Certificate[] acertificate = null;
        boolean flag = false;
        IdentityDatabase identitydatabase = IdentityDatabase.fromStream((InputStream)inputstream);
        Enumeration enumeration = identitydatabase.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            X509Certificate x509certificate = null;
            if ((!(identity instanceof SystemSigner) || !((SystemSigner)identity).isTrusted()) && (!(identity instanceof SystemIdentity) || !((SystemIdentity)identity).isTrusted())) continue;
            if (this.keyStore.containsAlias(identity.getName())) {
                MessageFormat messageformat = new MessageFormat(rb.getString("Keystore entry for <id.getName()> already exists"));
                Object[] aobj = new Object[]{identity.getName()};
                System.err.println(messageformat.format(aobj));
                continue;
            }
            java.security.Certificate[] acertificate1 = identity.certificates();
            if (acertificate1 == null || acertificate1.length <= 0) continue;
            DerOutputStream deroutputstream = new DerOutputStream();
            acertificate1[0].encode(deroutputstream);
            byte[] abyte0 = deroutputstream.toByteArray();
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
            x509certificate = (X509Certificate)this.cf.generateCertificate(bytearrayinputstream);
            bytearrayinputstream.close();
            if (this.isSelfSigned(x509certificate)) {
                PublicKey publickey = x509certificate.getPublicKey();
                try {
                    x509certificate.verify(publickey);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (identity instanceof SystemSigner) {
                MessageFormat messageformat1 = new MessageFormat(rb.getString("Creating keystore entry for <id.getName()> ..."));
                Object[] aobj1 = new Object[]{identity.getName()};
                System.err.println(messageformat1.format(aobj1));
                if (acertificate == null) {
                    acertificate = new Certificate[]{x509certificate};
                }
                PrivateKey privatekey = ((SystemSigner)identity).getPrivateKey();
                this.keyStore.setKeyEntry(identity.getName(), privatekey, this.storePass, acertificate);
            } else {
                this.keyStore.setCertificateEntry(identity.getName(), x509certificate);
            }
            this.kssave = true;
        }
        if (!this.kssave) {
            System.err.println(rb.getString("No entries from identity database added"));
        }
    }

    private void doPrintEntry(String s, PrintStream printstream, boolean flag) throws Exception {
        if (this.storePass == null && flag) {
            this.printWarning();
        }
        if (!this.keyStore.containsAlias(s)) {
            MessageFormat messageformat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] aobj = new Object[]{s};
            throw new Exception(messageformat.format(aobj));
        }
        if (this.verbose || this.rfc || this.debug) {
            MessageFormat messageformat1 = new MessageFormat(rb.getString("Alias name: alias"));
            Object[] aobj1 = new Object[]{s};
            printstream.println(messageformat1.format(aobj1));
            messageformat1 = new MessageFormat(rb.getString("Creation date: keyStore.getCreationDate(alias)"));
            Object[] aobj3 = new Object[]{this.keyStore.getCreationDate(s)};
            printstream.println(messageformat1.format(aobj3));
        } else {
            MessageFormat messageformat2 = new MessageFormat(rb.getString("alias, keyStore.getCreationDate(alias), "));
            Object[] aobj2 = new Object[]{s, this.keyStore.getCreationDate(s)};
            printstream.print(messageformat2.format(aobj2));
        }
        if (this.keyStore.isKeyEntry(s)) {
            if (this.verbose || this.rfc || this.debug) {
                printstream.println(rb.getString("Entry type: keyEntry"));
            } else {
                printstream.println(rb.getString("keyEntry,"));
            }
            Certificate[] acertificate = this.keyStore.getCertificateChain(s);
            if (acertificate != null) {
                if (this.verbose || this.rfc || this.debug) {
                    printstream.println(rb.getString("Certificate chain length: ") + acertificate.length);
                    for (int i = 0; i < acertificate.length; ++i) {
                        MessageFormat messageformat3 = new MessageFormat(rb.getString("Certificate[(i + 1)]:"));
                        Object[] aobj4 = new Object[]{new Integer(i + 1)};
                        printstream.println(messageformat3.format(aobj4));
                        if (this.verbose && acertificate[i] instanceof X509Certificate) {
                            this.printX509Cert((X509Certificate)acertificate[i], printstream);
                            continue;
                        }
                        if (this.debug) {
                            printstream.println(acertificate[i].toString());
                            continue;
                        }
                        this.dumpCert(acertificate[i], printstream);
                    }
                } else {
                    printstream.println(rb.getString("Certificate fingerprint (MD5): ") + this.getCertFingerPrint("MD5", acertificate[0]));
                }
            }
        } else {
            Certificate certificate = this.keyStore.getCertificate(s);
            if (this.verbose && certificate instanceof X509Certificate) {
                printstream.println(rb.getString("Entry type: trustedCertEntry\n"));
                this.printX509Cert((X509Certificate)certificate, printstream);
            } else if (this.rfc) {
                printstream.println(rb.getString("Entry type: trustedCertEntry\n"));
                this.dumpCert(certificate, printstream);
            } else if (this.debug) {
                printstream.println(certificate.toString());
            } else {
                printstream.println(rb.getString("trustedCertEntry,"));
                printstream.println(rb.getString("Certificate fingerprint (MD5): ") + this.getCertFingerPrint("MD5", certificate));
            }
        }
    }

    private void doPrintEntries(PrintStream printstream) throws Exception {
        if (this.storePass == null) {
            this.printWarning();
        } else {
            printstream.println();
        }
        printstream.println(rb.getString("Keystore type: ") + this.keyStore.getType());
        printstream.println(rb.getString("Keystore provider: ") + this.keyStore.getProvider().getName());
        printstream.println();
        MessageFormat messageformat = this.keyStore.size() != 1 ? new MessageFormat(rb.getString("Your keystore contains keyStore.size() entries")) : new MessageFormat(rb.getString("Your keystore contains keyStore.size() entry"));
        Object[] aobj = new Object[]{new Integer(this.keyStore.size())};
        printstream.println(messageformat.format(aobj));
        printstream.println();
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String s = enumeration.nextElement();
            this.doPrintEntry(s, printstream, false);
            if (!this.verbose && !this.rfc) continue;
            printstream.println(rb.getString("\n"));
            printstream.println(rb.getString("*******************************************"));
            printstream.println(rb.getString("*******************************************\n\n"));
        }
    }

    private void doPrintCert(InputStream inputstream, PrintStream printstream) throws Exception {
        Collection<? extends Certificate> collection = null;
        try {
            collection = this.cf.generateCertificates(inputstream);
        }
        catch (CertificateException certificateexception) {
            throw new Exception(rb.getString("Failed to parse input"), certificateexception);
        }
        if (collection.isEmpty()) {
            throw new Exception(rb.getString("Empty input"));
        }
        Certificate[] acertificate = collection.toArray(new Certificate[collection.size()]);
        for (int i = 0; i < acertificate.length; ++i) {
            X509Certificate x509certificate = null;
            try {
                x509certificate = (X509Certificate)acertificate[i];
            }
            catch (ClassCastException classcastexception) {
                throw new Exception(rb.getString("Not X.509 certificate"));
            }
            if (acertificate.length > 1) {
                MessageFormat messageformat = new MessageFormat(rb.getString("Certificate[(i + 1)]:"));
                Object[] aobj = new Object[]{new Integer(i + 1)};
                printstream.println(messageformat.format(aobj));
            }
            this.printX509Cert(x509certificate, printstream);
            if (i >= acertificate.length - 1) continue;
            printstream.println();
        }
    }

    private void doSelfCert(String s, String s1, String s2) throws Exception {
        X500Name x500name;
        Certificate certificate;
        if (s == null) {
            s = this.keyAlias;
        }
        Object[] aobj = this.recoverPrivateKey(s, this.storePass, this.keyPass);
        PrivateKey privatekey = (PrivateKey)aobj[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])aobj[1];
        }
        if (s2 == null) {
            String s3 = privatekey.getAlgorithm();
            if (s3.equalsIgnoreCase("DSA") || s3.equalsIgnoreCase("DSS")) {
                s2 = "SHA1WithDSA";
            } else if (s3.equalsIgnoreCase("RSA")) {
                s2 = "MD5WithRSA";
            } else {
                throw new Exception(rb.getString("Cannot derive signature algorithm"));
            }
        }
        if ((certificate = this.keyStore.getCertificate(s)) == null) {
            MessageFormat messageformat = new MessageFormat(rb.getString("alias has no public key"));
            Object[] aobj1 = new Object[]{s};
            throw new Exception(messageformat.format(aobj1));
        }
        if (!(certificate instanceof X509Certificate)) {
            MessageFormat messageformat1 = new MessageFormat(rb.getString("alias has no X.509 certificate"));
            Object[] aobj2 = new Object[]{s};
            throw new Exception(messageformat1.format(aobj2));
        }
        byte[] abyte0 = certificate.getEncoded();
        X509CertImpl x509certimpl = new X509CertImpl(abyte0);
        X509CertInfo x509certinfo = (X509CertInfo)x509certimpl.get("x509.info");
        Date date = new Date();
        Date date1 = new Date();
        date1.setTime(date1.getTime() + (long)this.validity * 1000L * 24L * 60L * 60L);
        CertificateValidity certificatevalidity = new CertificateValidity(date, date1);
        x509certinfo.set("validity", certificatevalidity);
        x509certinfo.set("serialNumber", new CertificateSerialNumber((int)(date.getTime() / 1000L)));
        if (s1 == null) {
            x500name = (X500Name)x509certinfo.get("subject.dname");
        } else {
            x500name = new X500Name(s1);
            x509certinfo.set("subject.dname", x500name);
        }
        x509certinfo.set("issuer.dname", x500name);
        X509CertImpl x509certimpl1 = new X509CertImpl(x509certinfo);
        x509certimpl1.sign(privatekey, s2);
        AlgorithmId algorithmid = (AlgorithmId)x509certimpl1.get("x509.algorithm");
        x509certinfo.set("algorithmID.algorithm", algorithmid);
        x509certimpl1 = new X509CertImpl(x509certinfo);
        x509certimpl1.sign(privatekey, s2);
        this.keyStore.setKeyEntry(s, privatekey, this.keyPass == null ? this.storePass : this.keyPass, new Certificate[]{x509certimpl1});
        if (this.verbose) {
            System.err.println(rb.getString("New certificate (self-signed):"));
            System.err.print(x509certimpl1.toString());
            System.err.println();
        }
    }

    private boolean installReply(String s, InputStream inputstream) throws Exception {
        Certificate certificate;
        if (s == null) {
            s = this.keyAlias;
        }
        Object[] aobj = this.recoverPrivateKey(s, this.storePass, this.keyPass);
        PrivateKey privatekey = (PrivateKey)aobj[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])aobj[1];
        }
        if ((certificate = this.keyStore.getCertificate(s)) == null) {
            MessageFormat messageformat = new MessageFormat(rb.getString("alias has no public key (certificate)"));
            Object[] aobj1 = new Object[]{s};
            throw new Exception(messageformat.format(aobj1));
        }
        Collection<? extends Certificate> collection = this.cf.generateCertificates(inputstream);
        if (collection.isEmpty()) {
            throw new Exception(rb.getString("Reply has no certificates"));
        }
        Certificate[] acertificate = collection.toArray(new Certificate[collection.size()]);
        Certificate[] acertificate1 = acertificate.length == 1 ? this.establishCertChain(certificate, acertificate[0]) : this.validateReply(s, certificate, acertificate);
        if (acertificate1 != null) {
            this.keyStore.setKeyEntry(s, privatekey, this.keyPass == null ? this.storePass : this.keyPass, acertificate1);
            return true;
        }
        return false;
    }

    private boolean addTrustedCert(String s, InputStream inputstream) throws Exception {
        if (s == null) {
            throw new Exception(rb.getString("Must specify alias"));
        }
        if (this.keyStore.containsAlias(s)) {
            MessageFormat messageformat = new MessageFormat(rb.getString("Certificate not imported, alias <alias> already exists"));
            Object[] aobj = new Object[]{s};
            throw new Exception(messageformat.format(aobj));
        }
        X509Certificate x509certificate = null;
        try {
            x509certificate = (X509Certificate)this.cf.generateCertificate(inputstream);
        }
        catch (ClassCastException classcastexception) {
            throw new Exception(rb.getString("Input not an X.509 certificate"));
        }
        catch (CertificateException certificateexception) {
            throw new Exception(rb.getString("Input not an X.509 certificate"));
        }
        boolean flag = false;
        if (this.isSelfSigned(x509certificate)) {
            x509certificate.verify(x509certificate.getPublicKey());
            flag = true;
        }
        if (this.noprompt) {
            this.keyStore.setCertificateEntry(s, x509certificate);
            return true;
        }
        String s1 = null;
        String s3 = this.keyStore.getCertificateAlias(x509certificate);
        if (s3 != null) {
            MessageFormat messageformat1 = new MessageFormat(rb.getString("Certificate already exists in keystore under alias <trustalias>"));
            Object[] aobj1 = new Object[]{s3};
            System.err.println(messageformat1.format(aobj1));
            s1 = this.getYesNoReply(rb.getString("Do you still want to add it? [no]:  "));
        } else if (flag) {
            if (this.trustcacerts && this.caks != null && (s3 = this.caks.getCertificateAlias(x509certificate)) != null) {
                MessageFormat messageformat2 = new MessageFormat(rb.getString("Certificate already exists in system-wide CA keystore under alias <trustalias>"));
                Object[] aobj2 = new Object[]{s3};
                System.err.println(messageformat2.format(aobj2));
                s1 = this.getYesNoReply(rb.getString("Do you still want to add it to your own keystore? [no]:  "));
            }
            if (s3 == null) {
                this.printX509Cert(x509certificate, System.out);
                s1 = this.getYesNoReply(rb.getString("Trust this certificate? [no]:  "));
            }
        }
        if (s1 != null) {
            if (s1.equals("YES")) {
                this.keyStore.setCertificateEntry(s, x509certificate);
                return true;
            }
            return false;
        }
        Certificate[] acertificate = this.establishCertChain(null, x509certificate);
        this.keyStore.setCertificateEntry(s, x509certificate);
        return true;
    }

    private char[] getNewPasswd(String s, char[] ac) throws Exception {
        Object obj = null;
        char[] ac2 = null;
        for (int i = 0; i < 3; ++i) {
            MessageFormat messageformat = new MessageFormat(rb.getString("New prompt: "));
            Object[] aobj = new Object[]{s};
            System.err.print(messageformat.format(aobj));
            char[] ac1 = this.readPasswd(System.in);
            if (ac1.length < 6) {
                System.err.println(rb.getString("Password is too short - must be at least 6 characters"));
            } else if (Arrays.equals(ac1, ac)) {
                System.err.println(rb.getString("Passwords must differ"));
            } else {
                MessageFormat messageformat1 = new MessageFormat(rb.getString("Re-enter new prompt: "));
                Object[] aobj1 = new Object[]{s};
                System.err.print(messageformat1.format(aobj1));
                ac2 = this.readPasswd(System.in);
                if (!Arrays.equals(ac1, ac2)) {
                    System.err.println(rb.getString("They don't match; try again"));
                } else {
                    Arrays.fill(ac2, ' ');
                    return ac1;
                }
            }
            if (ac1 != null) {
                Arrays.fill(ac1, ' ');
                ac1 = null;
            }
            if (ac2 == null) continue;
            Arrays.fill(ac2, ' ');
            ac2 = null;
        }
        throw new Exception(rb.getString("Too many failures - try later"));
    }

    private String getAlias(String s) throws Exception {
        if (s != null) {
            MessageFormat messageformat = new MessageFormat(rb.getString("Enter prompt alias name:  "));
            Object[] aobj = new Object[]{s};
            System.err.print(messageformat.format(aobj));
        } else {
            System.err.print(rb.getString("Enter alias name:  "));
        }
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private char[] getKeyPasswd(String s, String s1, char[] ac) throws Exception {
        int i = 0;
        char[] ac1 = null;
        do {
            if (ac != null) {
                MessageFormat messageformat = new MessageFormat(rb.getString("Enter key password for <alias>"));
                Object[] aobj = new Object[]{s};
                System.err.println(messageformat.format(aobj));
                messageformat = new MessageFormat(rb.getString("\t(RETURN if same as for <otherAlias>)"));
                Object[] aobj2 = new Object[]{s1};
                System.err.print(messageformat.format(aobj2));
            } else {
                MessageFormat messageformat1 = new MessageFormat(rb.getString("Enter key password for <alias>"));
                Object[] aobj1 = new Object[]{s};
                System.err.print(messageformat1.format(aobj1));
            }
            System.err.flush();
            ac1 = this.readPasswd(System.in);
            if (ac1 != null) continue;
            ac1 = ac;
        } while (ac1 == null && ++i < 3);
        if (ac1 == null) {
            throw new Exception(rb.getString("Too many failures - try later"));
        }
        return ac1;
    }

    /*
     * WARNING - void declaration
     */
    private char[] readPasswd(InputStream inputstream) throws IOException {
        char[] ac;
        char[] ac1 = ac = new char[128];
        int i = ac1.length;
        int j = 0;
        block4: while (true) {
            int k = inputstream.read();
            switch (k) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int l = inputstream.read();
                    if (l == 10 || l == -1) break block4;
                    if (!(inputstream instanceof PushbackInputStream)) {
                        inputstream = new PushbackInputStream(inputstream);
                    }
                    ((PushbackInputStream)inputstream).unread(l);
                }
                default: {
                    void var6_6;
                    if (--i < 0) {
                        ac1 = new char[j + 128];
                        i = ac1.length - j - 1;
                        System.arraycopy(ac, 0, ac1, 0, j);
                        Arrays.fill(ac, ' ');
                        ac = ac1;
                    }
                    ac1[j++] = (char)var6_6;
                    continue block4;
                }
            }
            break;
        }
        if (j == 0) {
            return null;
        }
        char[] ac2 = new char[j];
        System.arraycopy(ac1, 0, ac2, 0, j);
        Arrays.fill(ac1, ' ');
        return ac2;
    }

    private void printX509Cert(X509Certificate x509certificate, PrintStream printstream) throws Exception {
        MessageFormat messageformat = new MessageFormat(rb.getString("*PATTERN* printX509Cert"));
        Object[] aobj = new Object[]{((Object)x509certificate.getSubjectDN()).toString(), ((Object)x509certificate.getIssuerDN()).toString(), x509certificate.getSerialNumber().toString(16), x509certificate.getNotBefore().toString(), x509certificate.getNotAfter().toString(), this.getCertFingerPrint("MD5", x509certificate), this.getCertFingerPrint("SHA1", x509certificate)};
        printstream.println(messageformat.format(aobj));
    }

    private boolean isSelfSigned(X509Certificate x509certificate) {
        return ((Object)x509certificate.getSubjectDN()).equals(x509certificate.getIssuerDN());
    }

    private boolean isTrusted(Certificate certificate) throws Exception {
        if (this.keyStore.getCertificateAlias(certificate) != null) {
            return true;
        }
        return this.trustcacerts && this.caks != null && this.caks.getCertificateAlias(certificate) != null;
    }

    private X500Name getX500Name() throws IOException {
        X500Name x500name;
        Object[] aobj;
        MessageFormat messageformat;
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(System.in));
        String s = "Unknown";
        String s1 = "Unknown";
        String s2 = "Unknown";
        String s3 = "Unknown";
        String s4 = "Unknown";
        String s5 = "Unknown";
        String s6 = null;
        do {
            s = this.inputString(bufferedreader, rb.getString("What is your first and last name?"), s);
            s1 = this.inputString(bufferedreader, rb.getString("What is the name of your organizational unit?"), s1);
            s2 = this.inputString(bufferedreader, rb.getString("What is the name of your organization?"), s2);
            s3 = this.inputString(bufferedreader, rb.getString("What is the name of your City or Locality?"), s3);
            s4 = this.inputString(bufferedreader, rb.getString("What is the name of your State or Province?"), s4);
            s5 = this.inputString(bufferedreader, rb.getString("What is the two-letter country code for this unit?"), s5);
            x500name = new X500Name(s, s1, s2, s3, s4, s5);
        } while (collator.compare(s6 = this.inputString(bufferedreader, (messageformat = new MessageFormat(rb.getString("Is <name> correct?"))).format(aobj = new Object[]{x500name}), rb.getString("no")), rb.getString("yes")) != 0 && collator.compare(s6, rb.getString("y")) != 0);
        System.err.println();
        return x500name;
    }

    private String inputString(BufferedReader bufferedreader, String s, String s1) throws IOException {
        System.err.println(s);
        MessageFormat messageformat = new MessageFormat(rb.getString("  [defaultValue]:  "));
        Object[] aobj = new Object[]{s1};
        System.err.print(messageformat.format(aobj));
        System.err.flush();
        String s2 = bufferedreader.readLine();
        if (s2 == null || collator.compare(s2, "") == 0) {
            s2 = s1;
        }
        return s2;
    }

    private void dumpCert(Certificate certificate, PrintStream printstream) throws IOException, CertificateException {
        if (this.rfc) {
            BASE64Encoder base64encoder = new BASE64Encoder();
            printstream.println("-----BEGIN CERTIFICATE-----");
            base64encoder.encodeBuffer(certificate.getEncoded(), (OutputStream)printstream);
            printstream.println("-----END CERTIFICATE-----");
        } else {
            printstream.write(certificate.getEncoded());
        }
    }

    private void byte2hex(byte byte0, StringBuffer stringbuffer) {
        char[] ac = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int i = (byte0 & 0xF0) >> 4;
        int j = byte0 & 0xF;
        stringbuffer.append(ac[i]);
        stringbuffer.append(ac[j]);
    }

    private String toHexString(byte[] abyte0) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = abyte0.length;
        for (int j = 0; j < i; ++j) {
            this.byte2hex(abyte0[j], stringbuffer);
            if (j >= i - 1) continue;
            stringbuffer.append(":");
        }
        return stringbuffer.toString();
    }

    private Object[] recoverPrivateKey(String s, char[] ac, char[] ac1) throws Exception {
        Key key = null;
        if (!this.keyStore.containsAlias(s)) {
            MessageFormat messageformat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] aobj = new Object[]{s};
            throw new Exception(messageformat.format(aobj));
        }
        if (!this.keyStore.isKeyEntry(s)) {
            MessageFormat messageformat1 = new MessageFormat(rb.getString("Alias <alias> has no (private) key"));
            Object[] aobj1 = new Object[]{s};
            throw new Exception(messageformat1.format(aobj1));
        }
        if (ac1 == null) {
            try {
                key = this.keyStore.getKey(s, ac);
                ac1 = ac;
            }
            catch (UnrecoverableKeyException unrecoverablekeyexception) {
                ac1 = this.getKeyPasswd(s, null, null);
                key = this.keyStore.getKey(s, ac1);
            }
        } else {
            key = this.keyStore.getKey(s, ac1);
        }
        if (!(key instanceof PrivateKey)) {
            throw new Exception(rb.getString("Recovered key is not a private key"));
        }
        return new Object[]{(PrivateKey)key, ac1};
    }

    private String getCertFingerPrint(String s, Certificate certificate) throws Exception {
        byte[] abyte0 = certificate.getEncoded();
        MessageDigest messagedigest = MessageDigest.getInstance(s);
        byte[] abyte1 = messagedigest.digest(abyte0);
        return this.toHexString(abyte1);
    }

    private void printWarning() {
        System.err.println();
        System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
        System.err.println(rb.getString("* The integrity of the information stored in your keystore  *"));
        System.err.println(rb.getString("* has NOT been verified!  In order to verify its integrity, *"));
        System.err.println(rb.getString("* you must provide your keystore password.                  *"));
        System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
        System.err.println();
    }

    private Certificate[] validateReply(String s, Certificate certificate, Certificate[] acertificate) throws Exception {
        int i;
        PublicKey publickey = certificate.getPublicKey();
        for (i = 0; i < acertificate.length && !publickey.equals(acertificate[i].getPublicKey()); ++i) {
        }
        if (i == acertificate.length) {
            MessageFormat messageformat = new MessageFormat(rb.getString("Certificate reply does not contain public key for <alias>"));
            Object[] aobj = new Object[]{s};
            throw new Exception(messageformat.format(aobj));
        }
        Certificate certificate1 = acertificate[0];
        acertificate[0] = acertificate[i];
        acertificate[i] = certificate1;
        Principal principal = ((X509Certificate)acertificate[0]).getIssuerDN();
        for (int j = 1; j < acertificate.length - 1; ++j) {
            int l;
            for (l = j; l < acertificate.length; ++l) {
                Principal principal1 = ((X509Certificate)acertificate[l]).getSubjectDN();
                if (!((Object)principal1).equals(principal)) continue;
                Certificate certificate2 = acertificate[j];
                acertificate[j] = acertificate[l];
                acertificate[l] = certificate2;
                principal = ((X509Certificate)acertificate[j]).getIssuerDN();
                break;
            }
            if (l != acertificate.length) continue;
            throw new Exception(rb.getString("Incomplete certificate chain in reply"));
        }
        for (int k = 0; k < acertificate.length - 1; ++k) {
            PublicKey publickey1 = acertificate[k + 1].getPublicKey();
            try {
                acertificate[k].verify(publickey1);
                continue;
            }
            catch (Exception exception) {
                throw new Exception(rb.getString("Certificate chain in reply does not verify: ") + exception.getMessage());
            }
        }
        if (this.noprompt) {
            return acertificate;
        }
        Certificate certificate3 = acertificate[acertificate.length - 1];
        if (!this.isTrusted(certificate3)) {
            boolean flag = false;
            Certificate certificate4 = null;
            if (this.trustcacerts && this.caks != null) {
                Enumeration<String> enumeration = this.caks.aliases();
                while (enumeration.hasMoreElements()) {
                    String s2 = enumeration.nextElement();
                    certificate4 = this.caks.getCertificate(s2);
                    if (certificate4 == null) continue;
                    try {
                        certificate3.verify(certificate4.getPublicKey());
                        flag = true;
                        break;
                    }
                    catch (Exception exception1) {
                    }
                }
            }
            if (!flag) {
                System.err.println();
                System.err.println(rb.getString("Top-level certificate in reply:\n"));
                this.printX509Cert((X509Certificate)certificate3, System.out);
                System.err.println();
                System.err.print(rb.getString("... is not trusted. "));
                String s1 = this.getYesNoReply(rb.getString("Install reply anyway? [no]:  "));
                if (s1.equals("NO")) {
                    return null;
                }
            } else if (!this.isSelfSigned((X509Certificate)certificate3)) {
                Certificate[] acertificate1 = new Certificate[acertificate.length + 1];
                System.arraycopy(acertificate, 0, acertificate1, 0, acertificate.length);
                acertificate1[acertificate1.length - 1] = certificate4;
                acertificate = acertificate1;
            }
        }
        return acertificate;
    }

    private Certificate[] establishCertChain(Certificate certificate, Certificate certificate1) throws Exception {
        Vector vector;
        if (certificate != null) {
            PublicKey publickey1;
            PublicKey publickey = certificate.getPublicKey();
            if (!publickey.equals(publickey1 = certificate1.getPublicKey())) {
                throw new Exception(rb.getString("Public keys in reply and keystore don't match"));
            }
            if (certificate1.equals(certificate)) {
                throw new Exception(rb.getString("Certificate reply and certificate in keystore are identical"));
            }
        }
        Hashtable hashtable = null;
        if (this.keyStore.size() > 0) {
            hashtable = new Hashtable(11);
            this.keystorecerts2Hashtable(this.keyStore, hashtable);
        }
        if (this.trustcacerts && this.caks != null && this.caks.size() > 0) {
            if (hashtable == null) {
                hashtable = new Hashtable(11);
            }
            this.keystorecerts2Hashtable(this.caks, hashtable);
        }
        if (this.buildChain((X509Certificate)certificate1, vector = new Vector(2), hashtable)) {
            Certificate[] acertificate = new Certificate[vector.size()];
            int i = 0;
            for (int j = vector.size() - 1; j >= 0; --j) {
                acertificate[i] = (Certificate)vector.elementAt(j);
                ++i;
            }
            return acertificate;
        }
        throw new Exception(rb.getString("Failed to establish chain from reply"));
    }

    private boolean buildChain(X509Certificate x509certificate, Vector vector, Hashtable hashtable) {
        Principal principal1;
        Principal principal = x509certificate.getSubjectDN();
        if (((Object)principal).equals(principal1 = x509certificate.getIssuerDN())) {
            vector.addElement(x509certificate);
            return true;
        }
        Vector vector1 = (Vector)hashtable.get(principal1);
        if (vector1 == null) {
            return false;
        }
        Enumeration enumeration = vector1.elements();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509certificate1 = (X509Certificate)enumeration.nextElement();
            PublicKey publickey = x509certificate1.getPublicKey();
            try {
                x509certificate.verify(publickey);
            }
            catch (Exception exception) {
                continue;
            }
            if (!this.buildChain(x509certificate1, vector, hashtable)) continue;
            vector.addElement(x509certificate);
            return true;
        }
        return false;
    }

    private String getYesNoReply(String s) throws IOException {
        String s1 = null;
        do {
            System.err.print(s);
            System.err.flush();
            s1 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (collator.compare(s1, "") == 0 || collator.compare(s1, rb.getString("n")) == 0 || collator.compare(s1, rb.getString("no")) == 0) {
                s1 = "NO";
                continue;
            }
            if (collator.compare(s1, rb.getString("y")) == 0 || collator.compare(s1, rb.getString("yes")) == 0) {
                s1 = "YES";
                continue;
            }
            System.err.println(rb.getString("Wrong answer, try again"));
            s1 = null;
        } while (s1 == null);
        return s1;
    }

    private KeyStore getCacertsKeyStore() throws Exception {
        String s = File.separator;
        File file = new File(System.getProperty("java.home") + s + "lib" + s + "security" + s + "cacerts");
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileinputstream = new FileInputStream(file);
        KeyStore keystore = KeyStore.getInstance("jks");
        keystore.load(fileinputstream, null);
        fileinputstream.close();
        return keystore;
    }

    private void keystorecerts2Hashtable(KeyStore keystore, Hashtable hashtable) throws Exception {
        Enumeration<String> enumeration = keystore.aliases();
        while (enumeration.hasMoreElements()) {
            String s = enumeration.nextElement();
            Certificate certificate = keystore.getCertificate(s);
            if (certificate == null) continue;
            Principal principal = ((X509Certificate)certificate).getSubjectDN();
            Vector<Certificate> vector = (Vector<Certificate>)hashtable.get(principal);
            if (vector == null) {
                vector = new Vector<Certificate>();
                vector.addElement(certificate);
            } else if (!vector.contains(certificate)) {
                vector.addElement(certificate);
            }
            hashtable.put(principal, vector);
        }
    }

    private void usage() {
        System.err.println(rb.getString("keytool usage:\n"));
        System.err.println(rb.getString("-certreq     [-v] [-alias <alias>] [-sigalg <sigalg>]"));
        System.err.println(rb.getString("\t     [-file <csr_file>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-delete      [-v] -alias <alias>"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-export      [-v] [-rfc] [-alias <alias>] [-file <cert_file>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-genkey      [-v] [-alias <alias>] [-keyalg <keyalg>]"));
        System.err.println(rb.getString("\t     [-keysize <keysize>] [-sigalg <sigalg>]"));
        System.err.println(rb.getString("\t     [-dname <dname>] [-validity <valDays>]"));
        System.err.println(rb.getString("\t     [-keypass <keypass>] [-keystore <keystore>]"));
        System.err.println(rb.getString("\t     [-storepass <storepass>] [-storetype <storetype>]"));
        System.err.println(rb.getString("\t     [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-help"));
        System.err.println();
        System.err.println(rb.getString("-identitydb  [-v] [-file <idb_file>] [-keystore <keystore>]"));
        System.err.println(rb.getString("\t     [-storepass <storepass>] [-storetype <storetype>]"));
        System.out.println(rb.getString("\t     [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-import      [-v] [-noprompt] [-trustcacerts] [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-file <cert_file>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-keyclone    [-v] [-alias <alias>] -dest <dest_alias>"));
        System.err.println(rb.getString("\t     [-keypass <keypass>] [-new <new_keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-keypasswd   [-v] [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-keypass <old_keypass>] [-new <new_keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-list        [-v | -rfc] [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-printcert   [-v] [-file <cert_file>]"));
        System.err.println();
        System.err.println(rb.getString("-selfcert    [-v] [-alias <alias>] [-sigalg <sigalg>]"));
        System.err.println(rb.getString("\t     [-dname <dname>] [-validity <valDays>]"));
        System.err.println(rb.getString("\t     [-keypass <keypass>] [-keystore <keystore>]"));
        System.err.println(rb.getString("\t     [-storepass <storepass>] [-storetype <storetype>]"));
        System.err.println(rb.getString("\t     [-provider <provider_class_name>] ..."));
        System.err.println();
        System.err.println(rb.getString("-storepasswd [-v] [-new <new_storepass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-provider <provider_class_name>] ..."));
        System.err.println();
        System.exit(1);
    }

    static {
        collator.setStrength(0);
    }
}

