/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.registration;

import com.sun.xml.registry.client.browser.swing.RegistryMappedModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class TelephoneNumberModel
extends RegistryMappedModel {
    public static final String[] PHONE_TYPES = new String[]{"Office Phone", "Home Phone", "Mobile Phone", "Beeper", "FAX"};
    private final User user;
    private final Map numbers = new HashMap();

    TelephoneNumberModel(User u) {
        super(PHONE_TYPES[0]);
        this.user = u;
    }

    public void setCountryCode(String countryCode) throws JAXRException {
        countryCode = countryCode.trim();
        if (this.numbers.containsKey(this.key)) {
            TelephoneNumber phoneNumber = (TelephoneNumber)this.numbers.get(this.key);
            phoneNumber.setCountryCode(countryCode);
        } else {
            TelephoneNumber phoneNumber = this.user.getLifeCycleManager().createTelephoneNumber();
            phoneNumber.setCountryCode(countryCode);
            this.numbers.put(this.key, phoneNumber);
            this.user.setTelephoneNumbers(this.numbers.values());
        }
    }

    public void setAreaCode(String areaCode) throws JAXRException {
        areaCode = areaCode.trim();
        if (this.numbers.containsKey(this.key)) {
            TelephoneNumber phoneNumber = (TelephoneNumber)this.numbers.get(this.key);
            phoneNumber.setAreaCode(areaCode);
        } else {
            TelephoneNumber phoneNumber = this.user.getLifeCycleManager().createTelephoneNumber();
            phoneNumber.setAreaCode(areaCode);
            this.numbers.put(this.key, phoneNumber);
            this.user.setTelephoneNumbers(this.numbers.values());
        }
    }

    public void setNumber(String number) throws JAXRException {
        number = number.trim();
        if (this.numbers.containsKey(this.key)) {
            TelephoneNumber phoneNumber = (TelephoneNumber)this.numbers.get(this.key);
            phoneNumber.setNumber(number);
        } else {
            TelephoneNumber phoneNumber = this.user.getLifeCycleManager().createTelephoneNumber();
            phoneNumber.setNumber(number);
            this.numbers.put(this.key, phoneNumber);
            this.user.setTelephoneNumbers(this.numbers.values());
        }
    }

    public void setExtension(String extension) throws JAXRException {
        extension = extension.trim();
        if (this.numbers.containsKey(this.key)) {
            TelephoneNumber phoneNumber = (TelephoneNumber)this.numbers.get(this.key);
            phoneNumber.setExtension(extension);
        } else {
            TelephoneNumber phoneNumber = this.user.getLifeCycleManager().createTelephoneNumber();
            phoneNumber.setExtension(extension);
            this.numbers.put(this.key, phoneNumber);
            this.user.setTelephoneNumbers(this.numbers.values());
        }
    }

    public void setURL(String url) throws JAXRException {
        url = url.trim();
        if (this.numbers.containsKey(this.key)) {
            TelephoneNumber phoneNumber = (TelephoneNumber)this.numbers.get(this.key);
            phoneNumber.setUrl(url);
        } else {
            TelephoneNumber phoneNumber = this.user.getLifeCycleManager().createTelephoneNumber();
            phoneNumber.setUrl(url);
            this.numbers.put(this.key, phoneNumber);
            this.user.setTelephoneNumbers(this.numbers.values());
        }
    }

    public TelephoneNumber getNumber() {
        TelephoneNumber number = (TelephoneNumber)this.numbers.get(this.key);
        return number;
    }

    public void validate() throws JAXRException {
        Collection numberSet = this.numbers.values();
        TelephoneNumber number = null;
        Iterator i = numberSet.iterator();
        while (i.hasNext()) {
            number = (TelephoneNumber)i.next();
            String areaCode = number.getAreaCode();
            String countryCode = number.getCountryCode();
            String extension = number.getExtension();
            String phoneNumber = number.getNumber();
            String url = number.getUrl();
            if (areaCode != null && areaCode.length() != 0 || countryCode != null && countryCode.length() != 0 || extension != null && extension.length() != 0 || phoneNumber != null && phoneNumber.length() != 0 || url != null && url.length() != 0) continue;
            this.numbers.remove(number.getType());
        }
        this.user.setTelephoneNumbers(this.numbers.values());
        if (this.numbers.isEmpty()) {
            throw new JAXRException("Missing required TelephoneNumber on User");
        }
    }
}

