/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.registration;

import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.registration.KeyTool;
import com.sun.xml.registry.client.browser.registration.UserModel;
import com.sun.xml.registry.client.browser.registration.UserRegistrationDialog;
import com.sun.xml.registry.client.browser.registration.UserRegistrationPanel;
import com.sun.xml.registry.ebxml.ConnectionImpl;
import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import com.sun.xml.registry.ebxml.util.KeystoreUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.User;
import org.apache.commons.logging.Log;

public class UserManager {
    private static final UserManager instance = new UserManager();
    private static Log log = null;

    private UserManager() {
    }

    public static UserManager getInstance() {
        return instance;
    }

    public void registerNewUser() throws Exception {
        try {
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            BusinessLifeCycleManager lcm = client.getBusinessLifeCycleManager();
            UserModel userModel = new UserModel(lcm.createUser());
            UserRegistrationPanel userRegPanel = new UserRegistrationPanel(userModel);
            UserRegistrationDialog dialog = new UserRegistrationDialog(userRegPanel, userModel);
            dialog.setVisible(true);
            if (dialog.getStatus() != 1) {
                return;
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public static void authenticateAndSaveUser(UserModel userModel) throws Exception {
        try {
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            BusinessLifeCycleManager lcm = client.getBusinessLifeCycleManager();
            RegistryServiceImpl rs = (RegistryServiceImpl)lcm.getRegistryService();
            ConnectionImpl connection = rs.getConnection();
            if (!UserManager.certificateExists(userModel.getAlias(), userModel.getStorePassword())) {
                UserManager.generateSelfSignedCertificate(userModel.getUser(), userModel.getAlias(), userModel.getKeyPassword(), userModel.getStorePassword());
            }
            connection.authenticate();
            RegistryBrowser.setWaitCursor();
            ArrayList<User> objects = new ArrayList<User>();
            objects.add(userModel.getUser());
            client.saveObjects(objects);
            log.info((Object)("Saved user \"" + userModel.getUser().getPersonName().getFullName() + "\" on server."));
        }
        catch (Exception e) {
            try {
                String alias;
                if (userModel != null && (alias = userModel.getAlias()) != null) {
                    UserManager.removeCertificate(alias, userModel.getStorePassword());
                }
            }
            catch (Exception removeCertException) {
                log.warn((Object)"Failed to remove the certificate from the keystore that was generated during the self-registration process.", (Throwable)removeCertException);
            }
            throw e;
        }
        finally {
            RegistryBrowser.setDefaultCursor();
        }
    }

    public static boolean certificateExists(String alias, char[] storePass) throws Exception {
        boolean exists = false;
        try {
            File keystoreFile = KeystoreUtil.getKeystoreFile();
            KeystoreUtil.createKeystoreDirectory(keystoreFile);
            String[] args = new String[]{"-list", "-alias", alias, "-keystore", keystoreFile.getAbsolutePath(), "-storepass", new String(storePass)};
            KeyTool keytool = new KeyTool();
            keytool.run(args, System.out);
            exists = true;
            log.info((Object)("Alias exists \"" + alias + "\" in keystore \"" + keystoreFile.getAbsolutePath() + "\""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    public static void generateSelfSignedCertificate(User user, String alias, char[] keyPass, char[] storePass) throws Exception {
        String dname = UserManager.getDNameFromUser(user);
        File keystoreFile = KeystoreUtil.getKeystoreFile();
        KeystoreUtil.createKeystoreDirectory(keystoreFile);
        String[] args = new String[]{"-genkey", "-alias", alias, "-keypass", new String(keyPass), "-keystore", keystoreFile.getAbsolutePath(), "-storepass", new String(storePass), "-dname", dname};
        KeyTool keytool = new KeyTool();
        keytool.run(args, System.out);
        log.info((Object)("Stored user \"" + alias + "\" in keystore \"" + keystoreFile.getAbsolutePath() + "\""));
    }

    public static void removeCertificate(String alias, char[] storePass) throws Exception {
        File keystoreFile = KeystoreUtil.getKeystoreFile();
        String[] args = new String[]{"-delete", "-alias", alias, "-keystore", keystoreFile.getAbsolutePath(), "-storepass", new String(storePass)};
        KeyTool keytool = new KeyTool();
        keytool.run(args, System.out);
        log.info((Object)("Removed user \"" + alias + "\" from keystore \"" + keystoreFile.getAbsolutePath() + "\""));
    }

    private static String getDNameFromUser(User user) throws JAXRException {
        String country;
        String state;
        PostalAddress address;
        String city;
        String dname = "CN=";
        JAXRClient client = RegistryBrowser.getInstance().getClient();
        BusinessLifeCycleManager lcm = client.getBusinessLifeCycleManager();
        Collection addresses = user.getPostalAddresses();
        PersonName personName = user.getPersonName();
        if (personName == null) {
            personName = lcm.createPersonName("firstName", "middleName", "lastName");
        }
        if ((city = (address = addresses != null && addresses.size() > 0 ? (PostalAddress)addresses.iterator().next() : lcm.createPostalAddress("number", "street", "city", "state", "country", "postalCode", "Office")).getCity()) == null || city.length() == 0) {
            city = "Unknown";
        }
        if ((state = address.getStateOrProvince()) == null || state.length() == 0) {
            state = "Unknown";
        }
        if ((country = address.getCountry()) == null || country.length() == 0) {
            country = "US";
        }
        if (country.length() > 0) {
            country = country.substring(0, 2);
        }
        dname = dname + personName.getFirstName() + " " + personName.getMiddleName() + " " + personName.getLastName() + ", OU=Unknown, O=Unknown, L=" + city + ", ST=" + state + ", C=" + country;
        return dname;
    }

    static {
        try {
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            BusinessLifeCycleManager lcm = client.getBusinessLifeCycleManager();
            log = ((RegistryServiceImpl)lcm.getRegistryService()).getConnection().getConnectionFactory().getLog();
        }
        catch (JAXRException e) {
            e.printStackTrace();
        }
    }
}

