/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.registration;

import com.sun.xml.registry.client.browser.registration.EmailAddressPanel;
import com.sun.xml.registry.client.browser.registration.PersonNamePanel;
import com.sun.xml.registry.client.browser.registration.PostalAddressPanel;
import com.sun.xml.registry.client.browser.registration.TelephoneNumberPanel;
import com.sun.xml.registry.client.browser.registration.UserModel;
import com.sun.xml.registry.client.browser.swing.RegistryDocumentListener;
import com.sun.xml.registry.client.browser.swing.RegistryMappedPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.xml.registry.JAXRException;

public class UserRegistrationPanel
extends JPanel {
    private final JPanel panel = this;
    private final UserModel model;

    public UserRegistrationPanel(UserModel user) throws JAXRException {
        this.model = user;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gbl);
        this.setBorder(BorderFactory.createTitledBorder("User Details"));
        PersonNamePanel personNamePanel = new PersonNamePanel(user.getPersonNameModel());
        personNamePanel.setBorder(BorderFactory.createTitledBorder("Name"));
        RegistryMappedPanel.setConstraints(personNamePanel, c, gbl, 0, 0, 1, 0.5, 1, 17);
        this.add(personNamePanel);
        EmailAddressPanel emailPanel = new EmailAddressPanel(user.getEmailAddressModel());
        emailPanel.setBorder(BorderFactory.createTitledBorder("Email Address"));
        RegistryMappedPanel.setConstraints(emailPanel, c, gbl, 1, 0, 1, 0.5, 1, 17);
        this.add(emailPanel);
        PostalAddressPanel addressPanel = new PostalAddressPanel(user.getPostalAddressModel());
        addressPanel.setBorder(BorderFactory.createTitledBorder("Postal Address"));
        RegistryMappedPanel.setConstraints(addressPanel, c, gbl, 0, 1, 1, 0.5, 1, 17);
        this.add(addressPanel);
        TelephoneNumberPanel phonePanel = new TelephoneNumberPanel(user.getTelephoneNumberModel());
        phonePanel.setBorder(BorderFactory.createTitledBorder("Telephone Number"));
        RegistryMappedPanel.setConstraints(phonePanel, c, gbl, 1, 1, 1, 0.5, 1, 17);
        this.add(phonePanel);
        JPanel panel = new JPanel();
        RegistryMappedPanel.setConstraints(panel, c, gbl, 0, 2, 2, 0.5, 2, 17);
        this.add(panel);
        GridBagLayout gbl2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        panel.setLayout(gbl2);
        JLabel aliasLabel = new JLabel("Keystore Alias:", 2);
        RegistryMappedPanel.setConstraints(aliasLabel, c2, gbl2, 0, 0, 1, 0.0, 0, 17);
        panel.add(aliasLabel);
        JTextField aliasText = new JTextField();
        aliasText.getDocument().addDocumentListener(new AliasListener());
        RegistryMappedPanel.setConstraints(aliasText, c2, gbl2, 0, 1, 1, 0.5, 2, 10);
        panel.add(aliasText);
        JLabel keyPassLabel = new JLabel("Private Key Password:", 2);
        RegistryMappedPanel.setConstraints(keyPassLabel, c2, gbl2, 2, 0, 1, 0.0, 0, 17);
        panel.add(keyPassLabel);
        JPasswordField keyPassText = new JPasswordField();
        keyPassText.getDocument().addDocumentListener(new KeyPassListener());
        RegistryMappedPanel.setConstraints(keyPassText, c2, gbl2, 2, 1, 1, 0.5, 2, 10);
        panel.add(keyPassText);
    }

    public UserModel getUserModel() {
        return this.model;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    class KeyPassListener
    extends RegistryDocumentListener {
        public KeyPassListener() {
            super(UserRegistrationPanel.this.getPanel(), "Could not set private key password: ");
        }

        protected void setText(String text) throws JAXRException {
            UserRegistrationPanel.this.getUserModel().setKeyPassword(text.toCharArray());
        }
    }

    class AliasListener
    extends RegistryDocumentListener {
        public AliasListener() {
            super(UserRegistrationPanel.this.getPanel(), "Could not set keystore alias: ");
        }

        protected void setText(String text) throws JAXRException {
            UserRegistrationPanel.this.getUserModel().setAlias(text);
        }
    }
}

