/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.swing;

import com.sun.xml.registry.client.browser.swing.MappedPanel;
import com.sun.xml.registry.client.browser.swing.RegistryMappedModel;
import com.sun.xml.registry.client.browser.swing.TextField;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.Document;

public class RegistryMappedPanel
extends JPanel
implements Observer,
MappedPanel {
    private boolean mappingIsChanging = false;
    private final List textFields = new ArrayList();
    private final String errorMessage;

    protected RegistryMappedPanel(RegistryMappedModel model, String updateError) {
        this.errorMessage = updateError;
        model.addObserver(this);
    }

    public final RegistryMappedPanel getRegistryMappedPanel() {
        return this;
    }

    public void update(Observable o, Object arg) {
        TextField field = null;
        Document doc = null;
        Iterator i = this.textFields.iterator();
        while (i.hasNext()) {
            field = (TextField)i.next();
            try {
                doc = field.getTextField().getDocument();
                doc.remove(0, doc.getLength());
                String text = field.getText();
                if (text == null) continue;
                doc.insertString(0, text, null);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, this.errorMessage + e.getMessage(), "Error", 0);
            }
        }
    }

    public void setMappingIsChanging(boolean changing) {
        this.mappingIsChanging = changing;
    }

    public boolean mappingIsChanging() {
        return this.mappingIsChanging;
    }

    public void addTextField(TextField field) {
        this.add(field.getTextField());
        this.textFields.add(field);
    }

    public static void setConstraints(JComponent component, GridBagConstraints c, GridBagLayout gbl, int gridx, int gridy, int gridwidth, double weightx, int fill, int anchor) {
        c.gridx = gridx;
        c.gridy = gridy;
        c.gridwidth = gridwidth;
        c.gridheight = 1;
        c.weightx = weightx;
        c.weighty = 0.0;
        c.fill = fill;
        c.anchor = anchor;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(component, c);
    }
}

