/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.ObjectCache;
import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import com.sun.xml.registry.ebxml.infomodel.AssociationImpl;
import com.sun.xml.registry.ebxml.infomodel.AuditableEventImpl;
import com.sun.xml.registry.ebxml.infomodel.ClassificationImpl;
import com.sun.xml.registry.ebxml.infomodel.ClassificationSchemeImpl;
import com.sun.xml.registry.ebxml.infomodel.ConceptImpl;
import com.sun.xml.registry.ebxml.infomodel.ExternalIdentifierImpl;
import com.sun.xml.registry.ebxml.infomodel.ExternalLinkImpl;
import com.sun.xml.registry.ebxml.infomodel.ExtrinsicObjectImpl;
import com.sun.xml.registry.ebxml.infomodel.OrganizationImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryPackageImpl;
import com.sun.xml.registry.ebxml.infomodel.ServiceBindingImpl;
import com.sun.xml.registry.ebxml.infomodel.ServiceImpl;
import com.sun.xml.registry.ebxml.infomodel.SpecificationLinkImpl;
import com.sun.xml.registry.ebxml.infomodel.UserImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.FindException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryException;
import javax.xml.registry.infomodel.RegistryObject;
import org.oasis.ebxml.registry.bindings.query.AdhocQueryResponse;
import org.oasis.ebxml.registry.bindings.query.FilterQueryResult;
import org.oasis.ebxml.registry.bindings.query.GetContentResponse;
import org.oasis.ebxml.registry.bindings.query.SQLQueryResult;
import org.oasis.ebxml.registry.bindings.rim.Association;
import org.oasis.ebxml.registry.bindings.rim.AuditableEvent;
import org.oasis.ebxml.registry.bindings.rim.Classification;
import org.oasis.ebxml.registry.bindings.rim.ClassificationNode;
import org.oasis.ebxml.registry.bindings.rim.ClassificationScheme;
import org.oasis.ebxml.registry.bindings.rim.ExternalIdentifier;
import org.oasis.ebxml.registry.bindings.rim.ExternalLink;
import org.oasis.ebxml.registry.bindings.rim.ExtrinsicObject;
import org.oasis.ebxml.registry.bindings.rim.LeafRegistryObjectListTypeItem;
import org.oasis.ebxml.registry.bindings.rim.Organization;
import org.oasis.ebxml.registry.bindings.rim.RegistryPackage;
import org.oasis.ebxml.registry.bindings.rim.Service;
import org.oasis.ebxml.registry.bindings.rim.ServiceBinding;
import org.oasis.ebxml.registry.bindings.rim.SpecificationLink;
import org.oasis.ebxml.registry.bindings.rim.User;
import org.oasis.ebxml.registry.bindings.rs.RegistryError;
import org.oasis.ebxml.registry.bindings.rs.RegistryErrorList;
import org.oasis.ebxml.registry.bindings.rs.RegistryResponse;
import org.oasis.ebxml.registry.bindings.rs.RegistryResponseChoice;
import org.oasis.ebxml.registry.bindings.rs.types.StatusType;

public class BulkResponseImpl
implements BulkResponse {
    String requestId = null;
    private int status;
    private ArrayList collection = new ArrayList();
    private ArrayList registryExceptions;

    BulkResponseImpl() throws JAXRException {
        this.status = 0;
    }

    public BulkResponseImpl(LifeCycleManagerImpl lcm, RegistryResponse ebResponse, HashMap responseAttachments) throws JAXRException {
        RegistryErrorList errList;
        this.requestId = lcm.createId();
        StatusType statusType = ebResponse.getStatus();
        this.status = statusType == StatusType.SUCCESS ? 0 : (statusType == StatusType.UNAVAILABLE ? 3 : 2);
        RegistryResponseChoice rrc = ebResponse.getRegistryResponseChoice();
        if (rrc != null) {
            AdhocQueryResponse aqr = rrc.getAdhocQueryResponse();
            if (aqr != null) {
                SQLQueryResult sqlResult = aqr.getSQLQueryResult();
                if (sqlResult != null) {
                    this.processSqlQueryResult(sqlResult, lcm);
                } else {
                    FilterQueryResult filterResult = aqr.getFilterQueryResult();
                    this.processFilterQueryResult(filterResult, lcm);
                }
            } else {
                GetContentResponse gcr = rrc.getGetContentResponse();
                this.processGetContentResponse(responseAttachments, lcm);
            }
        }
        if ((errList = ebResponse.getRegistryErrorList()) != null) {
            RegistryError[] errs = errList.getRegistryError();
            for (int i = 0; i < errs.length; ++i) {
                this.addRegistryException(new FindException(errs[i].getContent()));
            }
        }
    }

    public Collection getCollection() throws JAXRException {
        return this.collection;
    }

    void setCollection(Collection c) {
        this.collection.clear();
        this.collection.addAll(c);
    }

    public Collection getExceptions() throws JAXRException {
        return this.registryExceptions;
    }

    public boolean isPartialResponse() throws JAXRException {
        return false;
    }

    public String getRequestId() throws JAXRException {
        return this.requestId;
    }

    public int getStatus() throws JAXRException {
        return this.status;
    }

    void setStatus(int status) throws JAXRException {
        this.status = status;
    }

    public boolean isAvailable() throws JAXRException {
        return true;
    }

    void addExceptions(Collection exes) {
        if (this.registryExceptions == null) {
            this.registryExceptions = new ArrayList();
        }
        this.registryExceptions.addAll(exes);
    }

    private void addRegistryException(RegistryException rex) {
        if (this.registryExceptions == null) {
            this.registryExceptions = new ArrayList();
        }
        this.registryExceptions.add(rex);
    }

    private void processSqlQueryResult(SQLQueryResult sqlResult, LifeCycleManagerImpl lcm) throws JAXRException {
        ObjectCache objCache = ((RegistryServiceImpl)lcm.getRegistryService()).getObjectCache();
        LeafRegistryObjectListTypeItem[] items = sqlResult.getLeafRegistryObjectListTypeItem();
        for (int i = 0; i < items.length; ++i) {
            ClassificationScheme ebScheme = items[i].getClassificationScheme();
            if (ebScheme != null) {
                ClassificationSchemeImpl scheme = new ClassificationSchemeImpl(lcm, ebScheme);
                objCache.putRegistryObject(scheme);
                this.collection.add(scheme);
                continue;
            }
            Classification ebClass = items[i].getClassification();
            if (ebClass != null) {
                ClassificationImpl cls = null;
                cls = new ClassificationImpl(lcm, ebClass, null);
                objCache.putRegistryObject(cls);
                this.collection.add(cls);
                continue;
            }
            Organization ebOrg = items[i].getOrganization();
            if (ebOrg != null) {
                OrganizationImpl org = new OrganizationImpl(lcm, ebOrg);
                objCache.putRegistryObject(org);
                this.collection.add(org);
                continue;
            }
            Association ebAss = items[i].getAssociation();
            if (ebAss != null) {
                AssociationImpl ass = new AssociationImpl(lcm, ebAss);
                objCache.putRegistryObject(ass);
                this.collection.add(ass);
                continue;
            }
            RegistryPackage ebPkg = items[i].getRegistryPackage();
            if (ebPkg != null) {
                RegistryPackageImpl pkg = new RegistryPackageImpl(lcm, ebPkg);
                objCache.putRegistryObject(pkg);
                this.collection.add(pkg);
                continue;
            }
            ExternalLink ebExtLink = items[i].getExternalLink();
            if (ebExtLink != null) {
                ExternalLinkImpl extLink = new ExternalLinkImpl(lcm, ebExtLink);
                objCache.putRegistryObject(extLink);
                this.collection.add(extLink);
                continue;
            }
            ExternalIdentifier ebExtIdentifier = items[i].getExternalIdentifier();
            if (ebExtIdentifier != null) {
                ExternalIdentifierImpl extIdentifier = new ExternalIdentifierImpl(lcm, ebExtIdentifier, null);
                objCache.putRegistryObject(extIdentifier);
                this.collection.add(extIdentifier);
                continue;
            }
            ExtrinsicObject ebExtrinsicObj = items[i].getExtrinsicObject();
            if (ebExtrinsicObj != null) {
                ExtrinsicObjectImpl extrinsicObj = new ExtrinsicObjectImpl(lcm, ebExtrinsicObj);
                objCache.putRegistryObject(extrinsicObj);
                this.collection.add(extrinsicObj);
                continue;
            }
            Service ebService = items[i].getService();
            if (ebService != null) {
                ServiceImpl service = new ServiceImpl(lcm, ebService);
                objCache.putRegistryObject(service);
                this.collection.add(service);
                continue;
            }
            ServiceBinding ebBinding = items[i].getServiceBinding();
            if (ebBinding != null) {
                ServiceBindingImpl binding = new ServiceBindingImpl(lcm, ebBinding);
                objCache.putRegistryObject(binding);
                this.collection.add(binding);
                continue;
            }
            SpecificationLink ebSpecLink = items[i].getSpecificationLink();
            if (ebSpecLink != null) {
                SpecificationLinkImpl specLink = new SpecificationLinkImpl(lcm, ebSpecLink);
                objCache.putRegistryObject(specLink);
                this.collection.add(specLink);
                continue;
            }
            ClassificationNode ebCNode = items[i].getClassificationNode();
            if (ebCNode != null) {
                ConceptImpl concept = new ConceptImpl(lcm, ebCNode);
                objCache.putRegistryObject(concept);
                this.collection.add(concept);
                continue;
            }
            if (items[i].getObjectRef() != null) continue;
            AuditableEvent ebAE = items[i].getAuditableEvent();
            if (ebAE != null) {
                AuditableEventImpl ae = new AuditableEventImpl(lcm, ebAE);
                objCache.putRegistryObject(ae);
                this.collection.add(ae);
                continue;
            }
            User ebUser = items[i].getUser();
            if (ebUser != null) {
                UserImpl user = new UserImpl(lcm, ebUser);
                objCache.putRegistryObject(user);
                this.collection.add(user);
                continue;
            }
            System.err.println("Not implemented " + sqlResult);
        }
    }

    private void processFilterQueryResult(FilterQueryResult filterResult, LifeCycleManagerImpl lcm) throws JAXRException {
        throw new JAXRException("Only SQLQueryResult is implemented");
    }

    private void processGetContentResponse(HashMap attachments, LifeCycleManagerImpl lcm) throws JAXRException {
        if (attachments == null) {
            return;
        }
        ObjectCache objCache = ((RegistryServiceImpl)lcm.getRegistryService()).getObjectCache();
        Iterator it = attachments.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String contentId = (String)entry.getKey();
            ExtrinsicObjectImpl extrinsicObj = (ExtrinsicObjectImpl)objCache.getReference(contentId, "ExtrinsicObject").get();
            DataHandler dh = (DataHandler)entry.getValue();
            extrinsicObj.setRepositoryItem(dh);
            this.collection.add(extrinsicObj);
        }
    }

    RegistryObject getRegistryObject() throws JAXRException {
        Collection results;
        Iterator iter;
        RegistryObject ro = null;
        Collection exceptions = this.getExceptions();
        if (exceptions != null) {
            Iterator iter2 = exceptions.iterator();
            Exception exception = null;
            if (iter2.hasNext()) {
                exception = (Exception)iter2.next();
                throw new JAXRException(exception);
            }
        }
        if ((iter = (results = this.getCollection()).iterator()).hasNext()) {
            ro = (RegistryObject)iter.next();
        }
        return ro;
    }
}

