/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.infomodel.ConceptImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryEntryImpl;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.Query;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.rim.ClassificationSchemeType;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;
import org.oasis.ebxml.registry.bindings.rim.types.NodeTypeType;

public class ClassificationSchemeImpl
extends RegistryEntryImpl
implements ClassificationScheme {
    private boolean external = false;
    private int valueType = 0;
    private ArrayList children = new ArrayList();
    private boolean childrenLoaded = false;

    public ClassificationSchemeImpl(LifeCycleManagerImpl lcm) throws JAXRException {
        super(lcm);
        this.childrenLoaded = true;
    }

    public ClassificationSchemeImpl(LifeCycleManagerImpl lcm, Concept concept) throws JAXRException {
        super(lcm);
        if (concept.getParent() != null) {
            throw new InvalidRequestException("Cannot use a Concept that has a parent to create a ClassificationScheme");
        }
        this.setName(concept.getName());
        this.setDescription(concept.getDescription());
        this.addClassifications(concept.getClassifications());
        this.addExternalIdentifiers(concept.getExternalIdentifiers());
    }

    public ClassificationSchemeImpl(LifeCycleManagerImpl lcm, ClassificationSchemeType ebScheme) throws JAXRException {
        super(lcm, ebScheme);
        this.external = !ebScheme.getIsInternal();
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public String toXML() throws JAXRException {
        org.oasis.ebxml.registry.bindings.rim.ClassificationScheme ebObj = this.toBindingObject();
        StringWriter sw = new StringWriter();
        try {
            ((RegistryObjectType)ebObj).marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException(x);
        }
        catch (ValidationException x) {
            throw new JAXRException(x);
        }
        return sw.toString();
    }

    public void addChildConcept(Concept c) throws JAXRException {
        this.children.add(c);
        ((ConceptImpl)c).setClassificationScheme(this);
    }

    public void addChildConcepts(Collection par1) throws JAXRException {
        Iterator iter = par1.iterator();
        while (iter.hasNext()) {
            ConceptImpl concept = (ConceptImpl)iter.next();
            concept.setClassificationScheme(this);
        }
        this.children.addAll(par1);
    }

    public void removeChildConcept(Concept par1) throws JAXRException {
        this.children.remove(par1);
    }

    public void removeChildConcepts(Collection par1) throws JAXRException {
        this.children.removeAll(par1);
    }

    public int getChildConceptCount() throws JAXRException {
        return this.getChildrenConcepts().size();
    }

    public Collection getChildrenConcepts() throws JAXRException {
        if (!this.childrenLoaded) {
            DeclarativeQueryManager dqm = this.lcm.getRegistryService().getDeclarativeQueryManager();
            String qs = "SELECT * FROM ClassificationNode WHERE path LIKE '%/" + this.getKey().getId() + "/%' ORDER BY CODE";
            Query query = dqm.createQuery(0, qs);
            this.children.addAll(dqm.executeQuery(query).getCollection());
            this.childrenLoaded = true;
        }
        return this.children;
    }

    public Collection getDescendantConcepts() throws JAXRException {
        ArrayList descendants = new ArrayList(this.children);
        Iterator iter = this.getChildrenConcepts().iterator();
        while (iter.hasNext()) {
            Concept child = (Concept)iter.next();
            if (child.getChildConceptCount() <= 0) continue;
            descendants.addAll(child.getDescendantConcepts());
        }
        return descendants;
    }

    public boolean isExternal() throws JAXRException {
        return this.external || this.getChildConceptCount() == 0;
    }

    public void setValueType(int param) throws JAXRException {
        this.valueType = param;
        this.setModified(true);
    }

    public int getValueType() throws JAXRException {
        return this.valueType;
    }

    public org.oasis.ebxml.registry.bindings.rim.ClassificationScheme toBindingObject() throws JAXRException {
        org.oasis.ebxml.registry.bindings.rim.ClassificationScheme ebScheme = new org.oasis.ebxml.registry.bindings.rim.ClassificationScheme();
        this.setBindingObject(ebScheme);
        return ebScheme;
    }

    public void getComposedObjects(HashSet composedObjects) throws JAXRException {
        super.getComposedObjects(composedObjects);
        composedObjects.addAll(this.children);
    }

    protected void setBindingObject(ClassificationSchemeType ebClassificationScheme) throws JAXRException {
        super.setBindingObject(ebClassificationScheme);
        ebClassificationScheme.setIsInternal(!this.isExternal());
        switch (this.getValueType()) {
            case 1: {
                ebClassificationScheme.setNodeType(NodeTypeType.EMBEDDEDPATH);
                break;
            }
            case 2: {
                ebClassificationScheme.setNodeType(NodeTypeType.NONUNIQUECODE);
                break;
            }
            case 0: {
                ebClassificationScheme.setNodeType(NodeTypeType.UNIQUECODE);
            }
        }
    }
}

