/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.infomodel.SlotImpl;
import com.sun.xml.registry.ebxml.util.I18nUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ExtensibleObject;
import javax.xml.registry.infomodel.Slot;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;

public abstract class ExtensibleObjectImpl
implements ExtensibleObject {
    protected static final I18nUtil i18nUtil = I18nUtil.getInstance();
    private TreeMap slots = new TreeMap();
    protected LifeCycleManagerImpl lcm = null;
    private boolean _new = false;
    private boolean modified = false;
    private boolean loaded = false;

    ExtensibleObjectImpl(LifeCycleManagerImpl lcm) {
        this.lcm = lcm;
        this._new = true;
    }

    ExtensibleObjectImpl(LifeCycleManagerImpl lcm, RegistryObjectType ebObject) throws JAXRException {
        this(lcm);
        this._new = false;
        org.oasis.ebxml.registry.bindings.rim.Slot[] ebSlots = ebObject.getSlot();
        for (int i = 0; i < ebSlots.length; ++i) {
            this.internalAddSlot(new SlotImpl(lcm, ebSlots[i]));
        }
    }

    protected BusinessQueryManager getBusinessQueryManager() throws JAXRException {
        return this.lcm.getRegistryService().getBusinessQueryManager();
    }

    protected DeclarativeQueryManager getDeclarativeQueryManager() throws JAXRException {
        return this.lcm.getRegistryService().getDeclarativeQueryManager();
    }

    public boolean isNew() {
        return this._new;
    }

    public void setNew(boolean _new) {
        this._new = _new;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    private void internalAddSlot(Slot slot) throws JAXRException {
        if (slot != null) {
            String slotName = slot.getName();
            if (!this.slots.keySet().contains(slotName)) {
                if (!this.slots.entrySet().contains(slot)) {
                    this.removeSlot(slot.getName());
                }
                ((SlotImpl)slot).setParent(this);
                this.slots.put(slotName, slot);
            } else {
                Object[] objs = new Object[]{slotName};
                throw new JAXRException(i18nUtil.getMessage("slot.name.duplicate", objs));
            }
        }
    }

    public void addSlot(Slot slot) throws JAXRException {
        this.internalAddSlot(slot);
        this.setModified(true);
    }

    public void addSlots(Collection _slots) throws JAXRException {
        Iterator iter = _slots.iterator();
        while (iter.hasNext()) {
            SlotImpl obj = (SlotImpl)iter.next();
            if (!(obj instanceof SlotImpl)) {
                throw new InvalidRequestException("Expected SlotImpl, got " + obj);
            }
            SlotImpl slot = obj;
            this.addSlot(slot);
        }
    }

    public void removeSlot(String slotName) throws JAXRException {
        Object removed = this.slots.remove(slotName);
        if (removed != null) {
            this.removeSlotInternal((SlotImpl)removed);
        }
    }

    private void removeSlotInternal(SlotImpl slot) throws JAXRException {
        slot.setParent(null);
        this.setModified(true);
    }

    public void removeSlots(Collection slotNames) throws JAXRException {
        Iterator iter = slotNames.iterator();
        while (iter.hasNext()) {
            String slotName = (String)iter.next();
            this.removeSlot(slotName);
        }
    }

    public void removeAllSlots() throws JAXRException {
        TreeMap _slots = (TreeMap)this.slots.clone();
        Iterator iter = _slots.values().iterator();
        while (iter.hasNext()) {
            SlotImpl slot = (SlotImpl)iter.next();
            this.removeSlotInternal(slot);
        }
        this.slots = new TreeMap();
    }

    public Slot getSlot(String slotName) throws JAXRException {
        return (Slot)this.slots.get(slotName);
    }

    public Collection getSlots() throws JAXRException {
        return ((TreeMap)this.slots.clone()).values();
    }

    public void setSlots(Collection slots) throws JAXRException {
        this.removeAllSlots();
        this.addSlots(slots);
    }

    protected void setBindingObject(RegistryObjectType ebObject) throws JAXRException {
        Iterator iter = this.getSlots().iterator();
        while (iter.hasNext()) {
            SlotImpl slot = (SlotImpl)iter.next();
            org.oasis.ebxml.registry.bindings.rim.Slot ebSlot = new org.oasis.ebxml.registry.bindings.rim.Slot();
            slot.setBindingObject(ebSlot);
            ebObject.addSlot(ebSlot);
        }
    }

    public void getComposedObjects(HashSet composedObjects) throws JAXRException {
        composedObjects.addAll(this.slots.values());
    }
}

