/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.infomodel.ExtensibleObjectImpl;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.Slot;
import org.oasis.ebxml.registry.bindings.rim.PostalAddressType;

public class PostalAddressImpl
extends ExtensibleObjectImpl
implements PostalAddress {
    private String street = null;
    private String streetNumber = null;
    private String city = null;
    private String stateOrProvince = null;
    private String postalCode = null;
    private String country = null;
    private String type = null;
    private ClassificationScheme postalScheme = null;

    private PostalAddressImpl() {
        super(null);
    }

    public PostalAddressImpl(LifeCycleManagerImpl lcm) {
        super(lcm);
    }

    public PostalAddressImpl(LifeCycleManagerImpl lcm, PostalAddressType address) {
        super(lcm);
        if (address == null) {
            return;
        }
        this.city = address.getCity();
        this.country = address.getCountry();
        this.postalCode = address.getPostalCode();
        this.stateOrProvince = address.getStateOrProvince();
        this.street = address.getStreet();
        this.streetNumber = address.getStreetNumber();
    }

    public String getStreet() throws JAXRException {
        if (this.street == null) {
            this.street = "";
        }
        return this.street;
    }

    public void setStreet(String par1) throws JAXRException {
        this.street = par1;
    }

    public String getStreetNumber() throws JAXRException {
        if (this.streetNumber == null) {
            this.streetNumber = "";
        }
        return this.streetNumber;
    }

    public void setStreetNumber(String par1) throws JAXRException {
        this.streetNumber = par1;
    }

    public String getCity() throws JAXRException {
        if (this.city == null) {
            this.city = "";
        }
        return this.city;
    }

    public void setCity(String par1) throws JAXRException {
        this.city = par1;
    }

    public String getStateOrProvince() throws JAXRException {
        if (this.stateOrProvince == null) {
            this.stateOrProvince = "";
        }
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String par1) throws JAXRException {
        this.stateOrProvince = par1;
    }

    public String getPostalCode() throws JAXRException {
        if (this.postalCode == null) {
            this.postalCode = "";
        }
        return this.postalCode;
    }

    public void setPostalCode(String par1) throws JAXRException {
        this.postalCode = par1;
    }

    public String getCountry() throws JAXRException {
        if (this.country == null) {
            this.country = "";
        }
        return this.country;
    }

    public void setCountry(String par1) throws JAXRException {
        this.country = par1;
    }

    public String getType() throws JAXRException {
        if (this.type == null) {
            this.type = "";
        }
        return this.type;
    }

    public void setType(String par1) throws JAXRException {
        this.type = par1;
    }

    public void setPostalScheme(ClassificationScheme par1) throws JAXRException {
        this.postalScheme = par1;
    }

    public ClassificationScheme getPostalScheme() throws JAXRException {
        return this.postalScheme;
    }

    void setBindingObject(PostalAddressType ebAddr) throws JAXRException {
        ebAddr.setStreet(this.street);
        ebAddr.setStreetNumber(this.streetNumber);
        ebAddr.setCity(this.city);
        ebAddr.setStateOrProvince(this.stateOrProvince);
        ebAddr.setPostalCode(this.postalCode);
        ebAddr.setCountry(this.country);
    }

    public String toString() {
        String addrStr = "";
        try {
            addrStr = this.getStreetNumber() + " " + this.getStreet() + ", " + this.getCity() + " " + this.getStateOrProvince() + " " + this.getPostalCode() + ", " + this.getCountry();
            Collection slots = this.getSlots();
            Iterator slotsIter = slots.iterator();
            while (slotsIter.hasNext()) {
                Slot slot = (Slot)slotsIter.next();
                Collection values = slot.getValues();
                Iterator valuesIter = values.iterator();
                while (valuesIter.hasNext()) {
                    String value = (String)valuesIter.next();
                    addrStr = addrStr + " " + value;
                }
                if (!slotsIter.hasNext()) continue;
                addrStr = addrStr + ",";
            }
        }
        catch (JAXRException e) {
            e.printStackTrace();
            addrStr = e.toString();
        }
        return addrStr;
    }
}

