/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import java.lang.ref.Reference;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.commons.logging.Log;
import org.oasis.ebxml.registry.bindings.rim.ObjectRef;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;

public class RegistryObjectRef {
    private LifeCycleManagerImpl lcm = null;
    private String id = null;
    private Reference ref = null;

    public String getId() throws JAXRException {
        return this.id;
    }

    private RegistryObjectRef() {
    }

    RegistryObjectRef(LifeCycleManagerImpl lcm, Object obj) throws JAXRException {
        if (obj instanceof RegistryObject) {
            this.init(lcm, (RegistryObject)obj);
        } else if (obj instanceof RegistryObjectType) {
            this.init(lcm, (RegistryObjectType)obj);
        } else if (obj instanceof ObjectRef) {
            this.init(lcm, (ObjectRef)obj);
        } else {
            JAXRException e = new JAXRException("Unexpected object: " + obj);
            e.printStackTrace();
            throw e;
        }
    }

    RegistryObjectRef(LifeCycleManagerImpl lcm, RegistryObject ro) throws JAXRException {
        if (ro != null) {
            this.init(lcm, ro);
        }
    }

    RegistryObjectRef(LifeCycleManagerImpl lcm, RegistryObjectType ro) throws JAXRException {
        this.init(lcm, ro.getId());
    }

    RegistryObjectRef(LifeCycleManagerImpl lcm, ObjectRef or) throws JAXRException {
        this.init(lcm, or.getId());
    }

    RegistryObjectRef(LifeCycleManagerImpl lcm, String id) throws JAXRException {
        this.init(lcm, id);
    }

    private void init(LifeCycleManagerImpl lcm, RegistryObject ro) throws JAXRException {
        Key key = ro.getKey();
        String id = "";
        if (key != null) {
            id = key.getId();
        }
        this.init(lcm, id);
        ((RegistryServiceImpl)lcm.getRegistryService()).getObjectCache().putRegistryObject(ro);
    }

    private void init(LifeCycleManagerImpl lcm, RegistryObjectType ro) throws JAXRException {
        this.init(lcm, ro.getId());
    }

    private void init(LifeCycleManagerImpl lcm, ObjectRef or) throws JAXRException {
        this.init(lcm, or.getId());
    }

    private void init(LifeCycleManagerImpl lcm, String id) throws JAXRException {
        this.lcm = lcm;
        this.id = id;
        if (id == null) {
            throw new JAXRException("Cannot create ref with id null");
        }
        this.ref = null;
    }

    public Reference getReference(String objectType) throws JAXRException {
        if (this.ref == null || this.ref.get() == null) {
            this.ref = ((RegistryServiceImpl)this.lcm.getRegistryService()).getObjectCache().getReference(this.id, objectType);
        }
        return this.ref;
    }

    public RegistryObject getRegistryObject(String objectType) throws JAXRException {
        RegistryObject ro = null;
        Reference ref = null;
        try {
            ref = this.getReference(objectType);
            if (ref != null) {
                ro = (RegistryObject)ref.get();
            }
        }
        catch (JAXRException e) {
            System.err.println("RegistryObjectRef:" + e.getMessage());
            ref = this.getReference(objectType);
        }
        catch (NullPointerException ne) {
            System.err.println("RegistryObjectRef:NullPointerException.Ignore");
        }
        return ro;
    }

    public String toString() {
        String str = super.toString();
        try {
            str = this.getId() + "," + str;
        }
        catch (JAXRException e) {
            try {
                this.getLog().warn((Object)"Error getting id", (Throwable)e);
            }
            catch (JAXRException jAXRException) {
                // empty catch block
            }
        }
        return str;
    }

    protected Log getLog() throws JAXRException {
        Log log = ((RegistryServiceImpl)this.lcm.getRegistryService()).getConnection().getConnectionFactory().getLog();
        return log;
    }
}

