/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.infomodel.OrganizationImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryEntryImpl;
import com.sun.xml.registry.ebxml.infomodel.ServiceBindingImpl;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.Query;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;
import org.oasis.ebxml.registry.bindings.rim.ServiceBinding;
import org.oasis.ebxml.registry.bindings.rim.ServiceType;

public class ServiceImpl
extends RegistryEntryImpl
implements Service {
    private HashSet bindings = new HashSet();
    private Organization providingOrg = null;
    private boolean loadedOrg;

    public ServiceImpl(LifeCycleManagerImpl lcm) throws JAXRException {
        super(lcm);
    }

    public ServiceImpl(LifeCycleManagerImpl lcm, ServiceType ebService) throws JAXRException {
        super(lcm, ebService);
        ServiceBinding[] ebBindings = ebService.getServiceBinding();
        for (int i = 0; i < ebBindings.length; ++i) {
            this.addServiceBinding(new ServiceBindingImpl(lcm, ebBindings[i]));
        }
    }

    public String toXML() throws JAXRException {
        org.oasis.ebxml.registry.bindings.rim.Service ebObj = this.toBindingObject();
        StringWriter sw = new StringWriter();
        try {
            ((RegistryObjectType)ebObj).marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException(x);
        }
        catch (ValidationException x) {
            throw new JAXRException(x);
        }
        return sw.toString();
    }

    public void setProvidingOrganization(Organization org) throws JAXRException {
        if (org != this.providingOrg) {
            if (!(org instanceof OrganizationImpl)) {
                throw new InvalidRequestException("Expected OrganizationImpl, got " + org);
            }
            this.providingOrg = (OrganizationImpl)org;
            this.setModified(true);
            if (this.providingOrg != null) {
                this.providingOrg.addService(this);
            }
            this.loadedOrg = true;
        }
    }

    public void addServiceBinding(javax.xml.registry.infomodel.ServiceBinding binding) throws JAXRException {
        this.bindings.add(binding);
        ((ServiceBindingImpl)binding).setService(this);
    }

    public void addServiceBindings(Collection _bindings) throws JAXRException {
        Iterator iter = _bindings.iterator();
        while (iter.hasNext()) {
            ServiceBindingImpl obj = (ServiceBindingImpl)iter.next();
            if (!(obj instanceof ServiceBindingImpl)) {
                throw new InvalidRequestException("Expected ServiceBindingImpl, got " + obj);
            }
            ServiceBindingImpl binding = obj;
            this.addServiceBinding(binding);
        }
    }

    public void removeServiceBinding(javax.xml.registry.infomodel.ServiceBinding binding) throws JAXRException {
        this.bindings.remove(binding);
        ((ServiceBindingImpl)binding).setService(null);
    }

    public void removeServiceBindings(Collection _bindings) throws JAXRException {
        Iterator iter = _bindings.iterator();
        while (iter.hasNext()) {
            ServiceBindingImpl obj = (ServiceBindingImpl)iter.next();
            if (!(obj instanceof ServiceBindingImpl)) {
                throw new InvalidRequestException("Expected ServiceBindingImpl, got " + obj);
            }
            ServiceBindingImpl binding = obj;
            this.removeServiceBinding(binding);
        }
    }

    public Collection getServiceBindings() throws JAXRException {
        return this.bindings;
    }

    public Organization getProvidingOrganization() throws JAXRException {
        if (!this.loadedOrg) {
            String id = this.getKey().getId();
            String queryStr = "SELECT id FROM Association WHERE targetObject = '" + id + "'";
            Query query = this.dqm.createQuery(0, queryStr);
            BulkResponse response = this.dqm.executeQuery(query);
            this.checkBulkResponseExceptions(response);
            Iterator i = response.getCollection().iterator();
            while (i.hasNext()) {
                Association a = (Association)i.next();
                if (!a.getAssociationType().getValue().equalsIgnoreCase("OffersService")) continue;
                RegistryObject org = a.getSourceObject();
                if (!(org instanceof Organization)) {
                    throw new IllegalStateException("Source object is not Organization but " + org.getClass().getName());
                }
                this.setProvidingOrganization((Organization)org);
            }
        }
        return this.providingOrg;
    }

    public org.oasis.ebxml.registry.bindings.rim.Service toBindingObject() throws JAXRException {
        org.oasis.ebxml.registry.bindings.rim.Service ebService = new org.oasis.ebxml.registry.bindings.rim.Service();
        this.setBindingObject(ebService);
        return ebService;
    }

    protected void setBindingObject(ServiceType ebService) throws JAXRException {
        super.setBindingObject(ebService);
        Iterator iter = this.getServiceBindings().iterator();
        while (iter.hasNext()) {
            ServiceBindingImpl binding = (ServiceBindingImpl)iter.next();
            ebService.addServiceBinding(binding.toBindingObject());
        }
    }

    public void getComposedObjects(HashSet composedObjects) throws JAXRException {
        super.getComposedObjects(composedObjects);
        Collection bindings = this.getServiceBindings();
        composedObjects.addAll(bindings);
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            ServiceBindingImpl binding = (ServiceBindingImpl)iter.next();
            binding.getComposedObjects(composedObjects);
        }
    }
}

