/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.jaas;

import com.sun.security.auth.login.ConfigFile;
import com.sun.xml.registry.ebxml.jaas.DialogAuthenticationCallbackHandler;
import com.sun.xml.registry.ebxml.util.KeystoreUtil;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.xml.registry.JAXRException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginModuleManager {
    private static final int MAX_FIXED_ATTRIBUTES = 25;
    private static final int MAX_BACKUP_LOGIN_FILES = 10;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String DEFAULT_APPLICATION_NAME = "jaxr-ebxml-provider";
    private static final String DEFAULT_LOGIN_MODULE_CLASSNAME = "com.sun.security.auth.module.KeyStoreLoginModule";
    private static final String DEFAULT_KEYSTORE_FILENAME = "${user.home}${/}jaxr-ebxml${/}security${/}keystore.jks";
    private static boolean _createLoginFile = false;
    private static boolean _createDefaultLoginFile = false;
    private static boolean _getCallbackHandler = false;
    private String _applicationName;
    private CallbackHandler _callbackHandler;
    private CallbackHandler _defaultCallbackHandler;
    private String _propertiesName = "jaxr-ebxml";
    private Properties _bundledProperties;
    private String _bundledCfgFileContents;
    private Properties _securityProps;
    private static final Log log = LogFactory.getLog((Class)(class$com$sun$xml$registry$ebxml$jaas$LoginModuleManager == null ? (class$com$sun$xml$registry$ebxml$jaas$LoginModuleManager = LoginModuleManager.class$("com.sun.xml.registry.ebxml.jaas.LoginModuleManager")) : class$com$sun$xml$registry$ebxml$jaas$LoginModuleManager));
    private Frame _parentFrame;
    private Log _parentLog = log;
    static /* synthetic */ Class class$com$sun$xml$registry$ebxml$jaas$LoginModuleManager;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$org$apache$commons$logging$Log;

    public LoginModuleManager() {
    }

    public LoginModuleManager(String applicationName) {
        this._applicationName = this._applicationName == null ? DEFAULT_APPLICATION_NAME : applicationName;
    }

    public void setParentFrame(Frame frame) {
        this._parentFrame = frame;
    }

    public Frame getParentFrame() {
        if (this._parentFrame == null) {
            this._parentFrame = new Frame();
        }
        return this._parentFrame;
    }

    public void setParentLog(Log log) {
        this._parentLog = log;
    }

    public void createLoginConfigFile() throws JAXRException {
        log.debug((Object)"start creating login config file");
        String bundledCfgFileContents = this.getBundledCfgFileContents();
        if (bundledCfgFileContents == null) {
            this.createDefaultLoginConfigFile();
        } else {
            this.createLoginConfigFileInternal(bundledCfgFileContents);
        }
        log.debug((Object)"finish creating login config file");
    }

    public String getApplicationName() {
        log.debug((Object)"start getting application name");
        if (this._applicationName == null) {
            try {
                String bundledCfgFileContents = this.getBundledCfgFileContents();
                if (bundledCfgFileContents != null) {
                    this._applicationName = this.getLoginName(bundledCfgFileContents);
                }
                log.info((Object)("authentication application name: " + this._applicationName));
            }
            catch (Throwable t) {
                log.warn((Object)"problem reading bundled login config file. Use default jaxr-ebxml-provider", t);
            }
            if (this._applicationName == null) {
                log.warn((Object)"problem reading bundled login config file. Use default jaxr-ebxml-provider");
                this._applicationName = DEFAULT_APPLICATION_NAME;
            }
        }
        log.debug((Object)"finish getting application name");
        return this._applicationName;
    }

    public void setDefaultCallbackHandler(CallbackHandler handler) {
        this._defaultCallbackHandler = handler;
    }

    public CallbackHandler getCallbackHandler() throws JAXRException {
        log.debug((Object)"start getting CallbackHandler name");
        if (this._callbackHandler == null) {
            Properties properties = this.getBundledProperties();
            String callbackHandlerClassName = properties.getProperty(this._propertiesName + ".security.jaas.callbackHandlerClassName");
            if (callbackHandlerClassName != null) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(callbackHandlerClassName);
                }
                catch (ClassNotFoundException ex) {
                    throw new JAXRException("Could not instantiate CallbackHandler " + callbackHandlerClassName + " Is this class in the classpath?", ex);
                }
                Class[] clazzes = new Class[]{class$java$awt$Frame == null ? (class$java$awt$Frame = LoginModuleManager.class$("java.awt.Frame")) : class$java$awt$Frame, class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LoginModuleManager.class$("org.apache.commons.logging.Log")) : class$org$apache$commons$logging$Log};
                Constructor<?> constructor = null;
                try {
                    constructor = clazz.getDeclaredConstructor(clazzes);
                    Object[] objs = new Object[]{this.getParentFrame(), this._parentLog};
                    this._callbackHandler = (CallbackHandler)constructor.newInstance(objs);
                }
                catch (NoSuchMethodException ex) {
                    log.debug((Object)"Could not find constructor that takes a Frame and Log as parameters. Trying default constructor");
                    try {
                        this._callbackHandler = (CallbackHandler)Class.forName(callbackHandlerClassName).newInstance();
                    }
                    catch (Throwable t) {
                        throw new JAXRException("Could not instantiate CallbackHandler " + callbackHandlerClassName + " reason", t);
                    }
                }
                catch (Throwable t) {
                    throw new JAXRException("Could not instantiate CallbackHandler " + callbackHandlerClassName + " Details:" + t.getMessage());
                }
            }
            if (this._callbackHandler == null) {
                log.info((Object)"Using default CallbackHandler");
                this._callbackHandler = this._defaultCallbackHandler != null ? this._defaultCallbackHandler : new DialogAuthenticationCallbackHandler(this.getParentFrame(), log);
            }
            log.info((Object)("CallbackHandler name: " + this._callbackHandler.getClass().getName()));
        }
        log.debug((Object)"finish getting CallbackHandler name");
        return this._callbackHandler;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void createDefaultLoginConfigFile() throws JAXRException {
        log.debug((Object)"start creation of default login config file");
        File keystoreFile = KeystoreUtil.getKeystoreFile();
        KeystoreUtil.canReadKeystoreFile(keystoreFile);
        String userHomeFileName = System.getProperty("user.home");
        if (userHomeFileName == null || userHomeFileName.length() == 0) {
            throw new JAXRException("Could not get system property user.home");
        }
        File configFile = new File(userHomeFileName, ".java.login.config");
        if (configFile.exists()) {
            if (!configFile.canRead()) {
                throw new JAXRException("File " + configFile.getAbsolutePath() + " exists but is not readable.");
            }
            Configuration config = ConfigFile.getConfiguration();
            String appName = this.getApplicationName();
            AppConfigurationEntry[] defaultAppConfigEntries = this.getReloadedAppConfigurationEntries(ConfigFile.getConfiguration(), configFile.getPath() + ".tmp", this.getDefaultConfigFileContents("jaxr-ebxml-provider.tmp"), appName + ".tmp");
            AppConfigurationEntry[] userAppConfigEntries = config.getAppConfigurationEntry(appName);
            boolean isCorrect = this.checkLoginModules(userAppConfigEntries, defaultAppConfigEntries);
            if (isCorrect) {
                log.info((Object)("using existing config file: " + configFile.getName()));
                return;
            }
            String userCfgFileName = configFile.getName();
            log.warn((Object)"User login config file does not have the same login modules as the default");
            this.renameCfgFile(userCfgFileName, userCfgFileName + ".bak");
            this.writeCfgFile(configFile, this.getDefaultConfigFileContents());
            config.refresh();
            log.info((Object)("created new login config file: " + configFile.getName()));
        } else {
            this.writeCfgFile(configFile, this.getDefaultConfigFileContents());
            log.info((Object)("created new login config file: " + configFile.getName()));
        }
        log.debug((Object)"finish creation of default login config file");
    }

    private boolean getDebugSetting() {
        boolean debug = false;
        Configuration config = ConfigFile.getConfiguration();
        AppConfigurationEntry[] userAppConfigEntries = config.getAppConfigurationEntry(this.getApplicationName());
        for (int i = 0; i < userAppConfigEntries.length; ++i) {
            Map<String, ?> options = userAppConfigEntries[i].getOptions();
            String debugStr = (String)options.get("debug");
            if (debugStr == null) continue;
            if (!debugStr.equalsIgnoreCase("true")) break;
            debug = true;
            break;
        }
        return debug;
    }

    private String getBundledCfgFilename() {
        URL url = this.getClass().getClassLoader().getResource("java.login.config");
        String fileName = url.getFile();
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties getBundledProperties() {
        BufferedReader in;
        block8: {
            if (this._bundledProperties != null) return this._bundledProperties;
            this._bundledProperties = new Properties();
            in = null;
            InputStream propInputStream = this.getClass().getClassLoader().getResourceAsStream("com/sun/xml/registry/ebxml/util/jaxr-ebxml-defaults.properties");
            if (propInputStream == null) break block8;
            this._bundledProperties.load(propInputStream);
        }
        Object var4_4 = null;
        if (in == null) return this._bundledProperties;
        try {
            in.close();
            return this._bundledProperties;
        }
        catch (IOException ex) {
            log.warn((Object)"could not close input stream", (Throwable)ex);
        }
        return this._bundledProperties;
        {
            catch (Throwable t) {
                log.warn((Object)"Problem reading bundled jaxr-ebxml.properties file");
                Object var4_5 = null;
                if (in == null) return this._bundledProperties;
                try {
                    in.close();
                    return this._bundledProperties;
                }
                catch (IOException ex) {
                    log.warn((Object)"could not close input stream", (Throwable)ex);
                }
                return this._bundledProperties;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                log.warn((Object)"could not close input stream", (Throwable)ex);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getBundledCfgFileContents() {
        block14: {
            if (this._bundledCfgFileContents == null) {
                BufferedReader in;
                block13: {
                    in = null;
                    InputStream cfgFileInputStream = this.getClass().getClassLoader().getResourceAsStream("com/sun/xml/registry/ebxml/util/jaxr.java.login.config");
                    if (cfgFileInputStream == null) break block13;
                    log.info((Object)"found com/sun/xml/registry/ebxml/util/jaxr.java.login.config file");
                    StringBuffer sb = new StringBuffer();
                    String line = null;
                    in = new BufferedReader(new InputStreamReader(cfgFileInputStream));
                    while ((line = in.readLine()) != null) {
                        sb.append(line).append(LINE_SEPARATOR);
                    }
                    this._bundledCfgFileContents = sb.toString();
                    this.checkKeystoreOption();
                }
                Object var6_6 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block14;
                }
                catch (IOException ex2) {}
                break block14;
                {
                    catch (IOException ex) {
                        log.warn((Object)"problem reading bundled login config file. Use default", (Throwable)ex);
                        this._bundledCfgFileContents = null;
                        Object var6_7 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                            break block14;
                        }
                        catch (IOException ex2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return this._bundledCfgFileContents;
    }

    private void createLoginConfigFileInternal(String bundledFileContents) throws JAXRException {
        log.debug((Object)"start creating login config file - internal");
        try {
            String userCfgFileName = this.getUserCfgFileName();
            log.info((Object)("User's config file name: " + userCfgFileName));
            String userCfgContents = this.getUserCfgFileContents(userCfgFileName);
            if (userCfgContents == null) {
                this.writeCfgFile(userCfgFileName, bundledFileContents);
            } else {
                this.checkUserCfgFile(userCfgFileName, userCfgContents, bundledFileContents);
            }
        }
        catch (Throwable t) {
            log.warn((Object)"problem reading config file. using default", t);
            this.createDefaultLoginConfigFile();
        }
        log.debug((Object)"finish creating login config file - internal");
    }

    private void checkUserCfgFile(String userCfgFileName, String userCfgContents, String bundledFileContents) throws JAXRException {
        String bundledLoginName;
        String userLoginName = this.getLoginName(userCfgContents);
        if (userLoginName.equalsIgnoreCase(bundledLoginName = this.getLoginName(bundledFileContents))) {
            Configuration config = ConfigFile.getConfiguration();
            String appName = this.getApplicationName();
            String tmpAppName = appName + ".tmp";
            AppConfigurationEntry[] bundledAppConfigEntries = this.getReloadedAppConfigurationEntries(config, userCfgFileName + ".tmp", bundledFileContents, appName);
            AppConfigurationEntry[] userAppConfigEntries = config.getAppConfigurationEntry(appName);
            boolean isCorrect = this.areUserCfgFileAttributesCorrect(userAppConfigEntries, bundledAppConfigEntries);
            if (!isCorrect) {
                log.warn((Object)"User login config file is not correct. Using bundled config file instead");
                this.renameCfgFile(userCfgFileName, userCfgFileName + ".bak");
                log.info((Object)("Renamed " + userCfgFileName + " to .bak file"));
                this.writeCfgFile(userCfgFileName, bundledFileContents);
                ConfigFile.getConfiguration().refresh();
                log.info((Object)("created new login file: " + userCfgFileName));
            } else {
                this.updateUserCfgContents(userAppConfigEntries, userCfgContents, userCfgFileName);
            }
        } else {
            this.renameCfgFile(userCfgFileName, userCfgFileName + ".bak");
            this.writeCfgFile(userCfgFileName, bundledFileContents);
        }
    }

    private void renameCfgFile(String fileName, String renamedFileName) throws JAXRException {
        block4: {
            try {
                File file = new File(fileName);
                File renamedFile = new File(renamedFileName);
                if (renamedFile.exists()) {
                    for (int i = 2; i <= 10; ++i) {
                        String tempFileName = renamedFileName + i;
                        File tempFile = new File(tempFileName);
                        if (tempFile.exists()) continue;
                        file.renameTo(tempFile);
                        log.debug((Object)("renaming config file " + fileName + " to " + renamedFileName));
                        break block4;
                    }
                    break block4;
                }
                file.renameTo(renamedFile);
            }
            catch (SecurityException ex) {
                throw new JAXRException(ex);
            }
        }
    }

    private boolean areUserCfgFileAttributesCorrect(AppConfigurationEntry[] userAppConfigEntries, AppConfigurationEntry[] bundledAppConfigEntries) throws JAXRException {
        boolean isCorrect = false;
        isCorrect = this.checkLoginModules(userAppConfigEntries, bundledAppConfigEntries);
        if (!isCorrect) {
            return isCorrect;
        }
        isCorrect = this.checkControlFlag(userAppConfigEntries, bundledAppConfigEntries);
        if (!isCorrect) {
            return isCorrect;
        }
        isCorrect = this.checkLoginModuleOptions(userAppConfigEntries, bundledAppConfigEntries);
        return isCorrect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AppConfigurationEntry[] getReloadedAppConfigurationEntries(Configuration config, String cfgFileName, String cfgFileContents, String appConfigName) throws JAXRException {
        AppConfigurationEntry[] appConfigEntries;
        block13: {
            String userCfgFileName;
            block11: {
                appConfigEntries = null;
                try {
                    File file = new File(cfgFileName);
                    this.writeCfgFile(file, cfgFileContents);
                }
                catch (Throwable t) {
                    throw new JAXRException("This application does not have permission to write to the local filesystem. Please provide this permission in your java.policy file. Go to http://java.sun.com and search for 'java.policy' for details on setting permissions", t);
                }
                String javaSecLoginCfg = System.getProperty("java.security.auth.login.config");
                userCfgFileName = this.getUserCfgFileName();
                System.setProperty("java.security.auth.login.config", cfgFileName);
                config.refresh();
                appConfigEntries = config.getAppConfigurationEntry(appConfigName);
                try {
                    try {
                        this.deleteCfgFile(cfgFileName);
                    }
                    catch (Throwable t) {
                        log.warn((Object)"problem deleting config file: ", t);
                        Object var10_10 = null;
                        if (javaSecLoginCfg != null) {
                            System.setProperty("java.security.auth.login.config", javaSecLoginCfg);
                        } else {
                            System.setProperty("java.security.auth.login.config", userCfgFileName);
                        }
                        config.refresh();
                        return appConfigEntries;
                    }
                    Object var10_9 = null;
                    if (javaSecLoginCfg == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (javaSecLoginCfg != null) {
                        System.setProperty("java.security.auth.login.config", javaSecLoginCfg);
                    } else {
                        System.setProperty("java.security.auth.login.config", userCfgFileName);
                    }
                    config.refresh();
                    throw throwable;
                }
                System.setProperty("java.security.auth.login.config", javaSecLoginCfg);
                break block13;
            }
            System.setProperty("java.security.auth.login.config", userCfgFileName);
        }
        config.refresh();
        return appConfigEntries;
    }

    private boolean checkLoginModules(AppConfigurationEntry[] userAppConfigEntries, AppConfigurationEntry[] bundledAppConfigEntries) {
        boolean isCorrect = false;
        for (int i = 0; i < bundledAppConfigEntries.length; ++i) {
            isCorrect = true;
            try {
                String bundledLoginModuleName = bundledAppConfigEntries[i].getLoginModuleName();
                String userLoginModuleName = userAppConfigEntries[i].getLoginModuleName();
                if (bundledLoginModuleName.equals(userLoginModuleName)) continue;
                isCorrect = false;
            }
            catch (Throwable t) {
                isCorrect = false;
            }
            break;
        }
        if (isCorrect) {
            log.debug((Object)"login module(s) in the existing login config file are ok");
        } else {
            log.warn((Object)"The login module(s) contained in the existing login config file do not appear in the same order as the modules in the bundled config file");
        }
        return isCorrect;
    }

    private boolean checkControlFlag(AppConfigurationEntry[] userAppConfigEntries, AppConfigurationEntry[] bundledAppConfigEntries) {
        boolean isCorrect = true;
        for (int i = 0; i < bundledAppConfigEntries.length; ++i) {
            try {
                AppConfigurationEntry.LoginModuleControlFlag bundledFlag = bundledAppConfigEntries[i].getControlFlag();
                String bundledFlagStr = bundledFlag.toString();
                AppConfigurationEntry.LoginModuleControlFlag userFlag = userAppConfigEntries[i].getControlFlag();
                String userFlagStr = userFlag.toString();
                if (bundledFlagStr.equals(userFlagStr)) continue;
                isCorrect = false;
            }
            catch (Throwable t) {
                isCorrect = false;
            }
            break;
        }
        if (isCorrect) {
            log.debug((Object)"control flag(s) in the existing login config file are ok");
        } else {
            log.warn((Object)"The control flags contained in the existing login config file do not match those in the bundled config file");
        }
        return isCorrect;
    }

    private boolean checkLoginModuleOptions(AppConfigurationEntry[] userAppConfigEntries, AppConfigurationEntry[] bundledAppConfigEntries) {
        String loginModuleName;
        Map<String, ?> bundledOptions;
        Map<String, ?> userOptions;
        boolean isCorrect = true;
        for (int i = 0; i < bundledAppConfigEntries.length && (isCorrect = this.doAllUserOptionExist(userOptions = userAppConfigEntries[i].getOptions(), bundledOptions = bundledAppConfigEntries[i].getOptions())) && (isCorrect = this.areAllUserOptionsSetToCorrectValues(userOptions, loginModuleName = bundledAppConfigEntries[i].getLoginModuleName())); ++i) {
        }
        return isCorrect;
    }

    private boolean doAllUserOptionExist(Map userOptions, Map bundledOptions) {
        boolean isCorrect = true;
        Iterator bundledOptionsIter = bundledOptions.keySet().iterator();
        while (bundledOptionsIter.hasNext()) {
            String bundledOption = (String)bundledOptionsIter.next();
            String userOption = (String)userOptions.get(bundledOption);
            if (userOption != null) continue;
            log.warn((Object)("The following option is missing in the existing login config file: " + userOption));
            isCorrect = false;
            break;
        }
        if (isCorrect) {
            log.debug((Object)"All options exist in the existing login config file");
        }
        return isCorrect;
    }

    private boolean areAllUserOptionsSetToCorrectValues(Map userOptions, String loginModuleFullName) {
        boolean isCorrect = true;
        int lastPeriodIndex = loginModuleFullName.lastIndexOf(46);
        String loginModuleName = loginModuleFullName.substring(lastPeriodIndex + 1, loginModuleFullName.length());
        Properties properties = this.getBundledProperties();
        if (properties == null) {
            return isCorrect;
        }
        String partialAttributeKey = this._propertiesName + ".security.jaas." + loginModuleName + ".attribute.";
        String partialFixedKey = this._propertiesName + ".security.jaas." + loginModuleName + ".fixedValue.";
        for (int j = 1; j <= 25; ++j) {
            String optionValue;
            String attributeKey = partialAttributeKey + j;
            String attributeValue = null;
            try {
                attributeValue = properties.getProperty(attributeKey);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
            if (attributeValue == null) continue;
            String fixedKey = partialFixedKey + j;
            String fixedValue = null;
            try {
                fixedValue = properties.getProperty(fixedKey);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
            if (fixedValue == null || (optionValue = (String)userOptions.get(attributeValue)) != null && optionValue.equalsIgnoreCase(fixedValue)) continue;
            log.warn((Object)("The following option is not set properly: " + attributeValue));
            log.warn((Object)("It is set to: " + optionValue));
            log.warn((Object)("It should be set to: " + fixedValue));
            isCorrect = false;
            break;
        }
        if (isCorrect) {
            log.debug((Object)"all user config file options are set properly");
        }
        return isCorrect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Properties getSecurityProperties() {
        block12: {
            if (this._securityProps == null) {
                this._securityProps = new Properties();
                BufferedInputStream bis = null;
                String fileName = null;
                String javaHome = System.getProperty("java.home");
                String dirSep = System.getProperty("file.separator");
                StringBuffer sb = new StringBuffer(javaHome);
                sb.append(dirSep).append("lib").append(dirSep);
                sb.append("security").append(dirSep);
                sb.append("java.security");
                fileName = sb.toString();
                log.info((Object)("Found java.security properties: " + fileName));
                File file = new File(fileName);
                bis = new BufferedInputStream(new FileInputStream(file));
                this._securityProps.load(bis);
                Object var8_8 = null;
                try {
                    if (bis != null) {
                        bis.close();
                    }
                    break block12;
                }
                catch (IOException ex2) {}
                break block12;
                {
                    catch (IOException ex) {
                        log.warn((Object)"could not open java.security properties file. Ignore.", (Throwable)ex);
                        Object var8_9 = null;
                        try {
                            if (bis != null) {
                                bis.close();
                            }
                            break block12;
                        }
                        catch (IOException ex2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return this._securityProps;
    }

    private String getLoginName(String cfgFileContents) {
        int firstSpaceIndex = cfgFileContents.indexOf(32);
        return cfgFileContents.substring(0, firstSpaceIndex);
    }

    private void deleteCfgFile(String cfgFile) throws JAXRException {
        try {
            File file = new File(cfgFile);
            boolean isDeleted = file.delete();
            if (!isDeleted) {
                System.out.println("warning: could not delete tmp file");
            }
        }
        catch (Throwable t) {
            throw new JAXRException(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeCfgFile(File configFile, String cfgFileContents) throws JAXRException {
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(configFile));
                writer.write(cfgFileContents, 0, cfgFileContents.length());
                writer.flush();
            }
            catch (IOException ex) {
                throw new JAXRException(ex);
            }
            Object var6_4 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        writer.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeCfgFile(String userCfgFileName, String fileContents) throws JAXRException {
        BufferedWriter writer = null;
        try {
            try {
                File file = new File(userCfgFileName);
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(fileContents, 0, fileContents.length());
                writer.flush();
            }
            catch (IOException ex) {
                throw new JAXRException(ex);
            }
            Object var6_6 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        writer.close();
        return;
    }

    private String getUserCfgFileName() {
        String userCfgFileName = null;
        try {
            Properties securityProps = this.getSecurityProperties();
            userCfgFileName = System.getProperty("java.security.auth.login.config");
            if (userCfgFileName == null || userCfgFileName.equals("")) {
                userCfgFileName = this.getDefaultUserCfgFileName();
            }
        }
        catch (Throwable t) {
            log.warn((Object)"problem getting user config file: ", t);
            userCfgFileName = this.getDefaultUserCfgFileName();
        }
        return userCfgFileName;
    }

    private String getDefaultUserCfgFileName() {
        StringBuffer sb = new StringBuffer(System.getProperty("user.home"));
        sb.append(System.getProperty("file.separator"));
        sb.append(".java.login.config");
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getUserCfgFileContents(String userHomeFileName) throws JAXRException {
        String string;
        String fileContents = null;
        BufferedReader in = null;
        try {
            try {
                File configFile = new File(userHomeFileName);
                if (configFile.exists()) {
                    StringBuffer sb2 = new StringBuffer();
                    String line = null;
                    in = new BufferedReader(new FileReader(configFile));
                    while ((line = in.readLine()) != null) {
                        sb2.append(line).append(LINE_SEPARATOR);
                    }
                    fileContents = sb2.toString();
                }
                log.debug((Object)("user config file contents: " + fileContents));
                string = fileContents;
                Object var8_8 = null;
            }
            catch (IOException ex) {
                throw new JAXRException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ex2) {
            // empty catch block
            return string;
        }
        if (in == null) return string;
        in.close();
        return string;
    }

    private String getDefaultConfigFileContents() {
        return this.getDefaultConfigFileContents(DEFAULT_APPLICATION_NAME);
    }

    private String getDefaultConfigFileContents(String appName) {
        String defaultConfigFileContents = null;
        if (appName == null) {
            appName = DEFAULT_APPLICATION_NAME;
        }
        String keystoreFileName = DEFAULT_KEYSTORE_FILENAME;
        try {
            File keystoreFile = KeystoreUtil.getKeystoreFile();
            KeystoreUtil.canReadKeystoreFile(keystoreFile);
            keystoreFileName = keystoreFile.toURL().getFile();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer(appName);
        sb.append(" { " + LINE_SEPARATOR);
        sb.append("    com.sun.security.auth.module.KeyStoreLoginModule ");
        sb.append("required ").append(LINE_SEPARATOR);
        sb.append("    debug=true keyStoreURL=\"file:");
        sb.append(keystoreFileName).append("\";");
        sb.append(LINE_SEPARATOR).append("};").append(LINE_SEPARATOR);
        defaultConfigFileContents = sb.toString();
        log.debug((Object)("Default config file contents: " + defaultConfigFileContents));
        return defaultConfigFileContents;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            try {
                String argFlag = args[i];
                if (argFlag.equals("-d")) {
                    _createDefaultLoginFile = true;
                    continue;
                }
                if (argFlag.equals("-l")) {
                    _createLoginFile = true;
                    continue;
                }
                if (argFlag.equals("-c")) {
                    _getCallbackHandler = true;
                    continue;
                }
                _createDefaultLoginFile = true;
                _createLoginFile = true;
                _getCallbackHandler = true;
                continue;
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
        }
        if (args.length == 0) {
            _createLoginFile = true;
        }
        LoginModuleManager loginModuleMgr = new LoginModuleManager();
        try {
            if (_createDefaultLoginFile) {
                log.info((Object)"starting createDefaultLoginConfigFile");
                loginModuleMgr.createDefaultLoginConfigFile();
            }
            if (_createLoginFile) {
                log.info((Object)"starting createLoginConfigFile");
                loginModuleMgr.createLoginConfigFile();
            }
            if (_getCallbackHandler) {
                log.info((Object)"starting getCallbackHandler");
                loginModuleMgr.getCallbackHandler();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void updateUserCfgContents(AppConfigurationEntry[] userAppConfigEntries, String userCfgContents, String cfgFileName) {
        for (int i = 0; i < userAppConfigEntries.length; ++i) {
            Map<String, ?> userOptions = userAppConfigEntries[i].getOptions();
            String userKeystoreFile = (String)userOptions.get("keyStoreURL");
            if (userKeystoreFile == null) continue;
            try {
                File keystoreFile = KeystoreUtil.getKeystoreFile();
                KeystoreUtil.canReadKeystoreFile(keystoreFile);
                String keystoreFileInPropFile = keystoreFile.toURL().getFile();
                if (keystoreFileInPropFile == null || userKeystoreFile.equals(keystoreFileInPropFile)) continue;
                String keyStoreURL = new String("keyStoreURL=\"file:");
                int keyStartIndex = userCfgContents.indexOf(keyStoreURL);
                int keyEndIndex = userCfgContents.indexOf("\";", keyStartIndex += keyStoreURL.length());
                String firstPart = userCfgContents.substring(0, keyStartIndex);
                String lastPart = userCfgContents.substring(keyEndIndex);
                StringBuffer sb = new StringBuffer(firstPart);
                sb.append(keystoreFileInPropFile).append(lastPart);
                userCfgContents = sb.toString();
                this.writeCfgFile(cfgFileName, userCfgContents);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    private void checkKeystoreOption() {
        String keyStoreURL = new String("keyStoreURL=\"file:");
        int keyStartIndex = this._bundledCfgFileContents.indexOf(keyStoreURL);
        int keyEndIndex = this._bundledCfgFileContents.indexOf("\";", keyStartIndex += keyStoreURL.length());
        try {
            File keystoreFile = KeystoreUtil.getKeystoreFile();
            KeystoreUtil.canReadKeystoreFile(keystoreFile);
            String firstPart = this._bundledCfgFileContents.substring(0, keyStartIndex);
            String keystoreFileName = keystoreFile.toURL().getFile();
            String lastPart = this._bundledCfgFileContents.substring(keyEndIndex);
            StringBuffer sb = new StringBuffer(firstPart);
            sb.append(keystoreFileName).append(lastPart);
            this._bundledCfgFileContents = sb.toString();
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

