/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.util;

import com.sun.xml.registry.ebxml.util.KeystoreUtil;
import com.sun.xml.registry.ebxml.util.ProviderProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.registry.JAXRException;

public class SecurityUtil {
    private static final SecurityUtil INSTANCE = new SecurityUtil();
    private Properties aliasTable;
    private KeyStore keyStore;

    public static SecurityUtil getInstance() {
        return INSTANCE;
    }

    private Properties loadAliasTable() throws JAXRException {
        String jaxrHome = ProviderProperties.getInstance().getProperty("jaxr-ebxml.home");
        if (jaxrHome == null || jaxrHome.length() == 0) {
            throw new JAXRException("Property jaxr-ebxml.home is undefined");
        }
        Properties aliasTable = new Properties();
        File aliasFile = new File(jaxrHome, "security/alias.properties");
        if (aliasFile.exists()) {
            try {
                aliasTable.load(new BufferedInputStream(new FileInputStream(aliasFile)));
            }
            catch (IOException x) {
                throw new JAXRException("Caught unexpected IOException", x);
            }
        }
        return aliasTable;
    }

    private KeyStore loadKeyStore() throws JAXRException {
        String storepass = ProviderProperties.getInstance().getProperty("jaxr-ebxml.security.storepass");
        try {
            this.keyStore = KeyStore.getInstance(ProviderProperties.getInstance().getProperty("jaxr-ebxml.security.storetype"));
        }
        catch (KeyStoreException x) {
            throw new JAXRException(x);
        }
        File keyStoreFile = KeystoreUtil.getKeystoreFile();
        if (!keyStoreFile.exists()) {
            throw new JAXRException("KeyStore file not found \"" + keyStoreFile.toString() + "\".  Please create one.");
        }
        try {
            BufferedInputStream keyIS = new BufferedInputStream(new FileInputStream(keyStoreFile));
            this.keyStore.load(keyIS, storepass.toCharArray());
        }
        catch (IOException x) {
            throw new JAXRException(x);
        }
        catch (GeneralSecurityException x) {
            throw new JAXRException(x);
        }
        return this.keyStore;
    }

    public String aliasToObjectId(String alias) throws JAXRException {
        if (this.aliasTable == null) {
            this.aliasTable = this.loadAliasTable();
        }
        return this.aliasTable.getProperty(alias);
    }

    public KeyStore getKeyStore() throws JAXRException {
        if (this.keyStore == null) {
            this.keyStore = this.loadKeyStore();
        }
        return this.keyStore;
    }

    public X500PrivateCredential aliasToX500PrivateCredential(String alias) throws JAXRException {
        this.getKeyStore();
        try {
            X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(alias);
            if (cert == null) {
                throw new JAXRException("Unknown alias in keystore");
            }
            String keypass = ProviderProperties.getInstance().getProperty("jaxr-ebxml.security.keypass");
            PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(alias, keypass.toCharArray());
            return new X500PrivateCredential(cert, privateKey, alias);
        }
        catch (GeneralSecurityException x) {
            throw new JAXRException(x);
        }
    }

    public Certificate[] getCertificateChain(X509Certificate cert) throws JAXRException {
        Certificate[] certChain = null;
        this.getKeyStore();
        try {
            String alias = this.keyStore.getCertificateAlias(cert);
            certChain = this.keyStore.getCertificateChain(alias);
            if (certChain == null) {
                certChain = new Certificate[]{cert};
            }
        }
        catch (KeyStoreException x) {
            throw new JAXRException(x);
        }
        return certChain;
    }

    public void addAlias(String alias, String objId) {
        this.aliasTable.setProperty(alias, objId);
    }
}

