/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.LoaderRepository;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoaderRepositoryFactory {
    public static ObjectName DEFAULT_LOADER_REPOSITORY;
    private static Logger log;
    private static HashMap referenceCountMap;
    static /* synthetic */ Class class$org$jboss$mx$loading$LoaderRepositoryFactory;
    static /* synthetic */ Class class$javax$management$MBeanServer;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public static LoaderRepositoryConfig parseRepositoryConfig(Element config) throws MalformedObjectNameException {
        NodeList children;
        int count;
        LoaderRepositoryConfig repositoryConfig = new LoaderRepositoryConfig();
        repositoryConfig.repositoryClassName = config.getAttribute("loaderRepositoryClass");
        if (repositoryConfig.repositoryClassName.length() == 0) {
            repositoryConfig.repositoryClassName = "org.jboss.mx.loading.HeirarchicalLoaderRepository3";
        }
        if ((count = (children = config.getChildNodes()).getLength()) > 0) {
            for (int n = 0; n < count; ++n) {
                Node node = children.item(n);
                short type = node.getNodeType();
                if (type != 3 && type != 4) continue;
                String objectName = node.getNodeValue().trim();
                repositoryConfig.repositoryName = new ObjectName(objectName);
                break;
            }
            if ((count = (children = config.getElementsByTagName("loader-repository-config")).getLength()) > 0) {
                Element loaderRepositoryConfig = (Element)children.item(0);
                children = loaderRepositoryConfig.getChildNodes();
                count = children.getLength();
                repositoryConfig.configParserClassName = loaderRepositoryConfig.getAttribute("configParserClass");
                if (repositoryConfig.configParserClassName.length() == 0) {
                    repositoryConfig.configParserClassName = "org.jboss.mx.loading.HeirarchicalLoaderRepository3ConfigParser";
                }
                StringBuffer configData = new StringBuffer();
                for (int n = 0; n < count; ++n) {
                    Node node = children.item(n);
                    short type = node.getNodeType();
                    if (type != 3 && type != 4) continue;
                    configData.append(node.getNodeValue());
                }
                repositoryConfig.repositoryConfig = configData.toString().trim();
            }
        }
        return repositoryConfig;
    }

    public static synchronized void createLoaderRepository(MBeanServer server, String repositoryClassName, ObjectName repositoryName) throws JMException {
        LoaderRepositoryConfig config = new LoaderRepositoryConfig();
        config.repositoryClassName = repositoryClassName;
        config.repositoryName = repositoryName;
        LoaderRepositoryFactory.createLoaderRepository(server, config);
    }

    public static synchronized void createLoaderRepository(MBeanServer server, LoaderRepositoryConfig config) throws JMException {
        if (config == null) {
            config = new LoaderRepositoryConfig();
        }
        String repositoryClassName = config.repositoryClassName;
        ObjectName repositoryName = config.repositoryName;
        try {
            ObjectInstance oi = server.getObjectInstance(repositoryName);
            if (repositoryClassName != null && !oi.getClassName().equals(repositoryClassName)) {
                throw new JMException("Inconsistent LoaderRepository class specification in repository: " + repositoryName);
            }
        }
        catch (InstanceNotFoundException e) {
            if (repositoryClassName == null) {
                repositoryClassName = "org.jboss.mx.loading.HeirarchicalLoaderRepository3";
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            LoaderRepository repository = null;
            try {
                Class<?> repositoryClass = loader.loadClass(repositoryClassName);
                Class[] ctorSig = new Class[]{class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = LoaderRepositoryFactory.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer, class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = LoaderRepositoryFactory.class$("javax.management.ObjectName")) : class$javax$management$ObjectName};
                Constructor<?> ctor = repositoryClass.getConstructor(ctorSig);
                Object[] args = new Object[]{server, DEFAULT_LOADER_REPOSITORY};
                repository = (LoaderRepository)ctor.newInstance(args);
                server.registerMBean(repository, repositoryName);
            }
            catch (Exception e2) {
                log.debug("Failed to create loader repository: ", e2);
                throw new JMException("Failed to create loader repository:" + e2);
            }
            try {
                if (config.configParserClassName != null && config.repositoryConfig != null) {
                    Class<?> parserClass = loader.loadClass(config.configParserClassName);
                    LoaderRepositoryConfigParser parser2 = (LoaderRepositoryConfigParser)parserClass.newInstance();
                    parser2.configure(repository, config.repositoryConfig);
                }
            }
            catch (Exception e2) {
                log.debug("Failed to configure loader repository: ", e2);
                throw new JMException("Failed to configure loader repository: " + e2);
            }
        }
        Integer activeCount = (Integer)referenceCountMap.get(repositoryName);
        activeCount = activeCount == null ? new Integer(1) : new Integer(activeCount + 1);
        referenceCountMap.put(repositoryName, activeCount);
    }

    public static synchronized void destroyLoaderRepository(MBeanServer server, ObjectName repositoryName) {
        if (!repositoryName.equals(DEFAULT_LOADER_REPOSITORY)) {
            try {
                Integer activeCount = (Integer)referenceCountMap.get(repositoryName);
                if (activeCount != null) {
                    if (activeCount == 1) {
                        server.unregisterMBean(repositoryName);
                        referenceCountMap.remove(repositoryName);
                        log.debug("Unregistered repository: " + repositoryName);
                    } else {
                        activeCount = new Integer(activeCount - 1);
                        referenceCountMap.put(repositoryName, activeCount);
                    }
                }
            }
            catch (Exception e) {
                log.warn("Failed to unregister ear loader repository", e);
            }
        }
    }

    private LoaderRepositoryFactory() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = Logger.getLogger(class$org$jboss$mx$loading$LoaderRepositoryFactory == null ? (class$org$jboss$mx$loading$LoaderRepositoryFactory = LoaderRepositoryFactory.class$("org.jboss.mx.loading.LoaderRepositoryFactory")) : class$org$jboss$mx$loading$LoaderRepositoryFactory);
        referenceCountMap = new HashMap();
        try {
            DEFAULT_LOADER_REPOSITORY = new ObjectName("JMImplementation:service=LoaderRepository,name=Default");
        }
        catch (Exception e) {
            log.error("Failed to init DEFAULT_LOADER_REPOSITORY name", e);
        }
    }

    public static interface LoaderRepositoryConfigParser {
        public void configure(LoaderRepository var1, String var2) throws Exception;
    }

    public static class LoaderRepositoryConfig
    implements Serializable {
        public ObjectName repositoryName = DEFAULT_LOADER_REPOSITORY;
        public String repositoryClassName;
        public String configParserClassName;
        public String repositoryConfig;

        public String toString() {
            StringBuffer tmp = new StringBuffer("LoaderRepositoryConfig(");
            tmp.append("repositoryName: ");
            tmp.append(this.repositoryName);
            tmp.append(", repositoryClassName: ");
            tmp.append(this.repositoryClassName);
            tmp.append(", configParserClassName: ");
            tmp.append(this.configParserClassName);
            tmp.append(", repositoryConfig: ");
            tmp.append(this.repositoryConfig);
            tmp.append(")");
            return tmp.toString();
        }
    }
}

