/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.iiop;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import org.jboss.proxy.ejb.ForeignTransaction;
import org.jboss.tm.GlobalId;
import org.jboss.tm.TransactionPropagationContextImporter;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.otid_t;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class TxServerInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final int txContextId = 0;
    private static int slotId;
    private static Codec codec;
    private static Current piCurrent;
    private static TransactionPropagationContextImporter tpcImporter;

    static void init(int slotId, Codec codec, Current piCurrent) {
        TxServerInterceptor.slotId = slotId;
        TxServerInterceptor.codec = codec;
        TxServerInterceptor.piCurrent = piCurrent;
    }

    public static Transaction getCurrentTransaction() {
        Object tx = null;
        if (piCurrent != null) {
            try {
                Any any = piCurrent.get_slot(slotId);
                if (any.type().kind().value() != 0) {
                    PropagationContext pc = PropagationContextHelper.extract((Any)any);
                    if (pc.current.coord == null) {
                        tx = ForeignTransaction.instance;
                    }
                    otid_t otid = pc.current.otid;
                    GlobalId globalId = new GlobalId(otid.formatID, otid.bqual_length, otid.tid);
                    tx = TxServerInterceptor.getTPCImporter().importTransactionPropagationContext(globalId);
                    if (tx == null) {
                        tx = ForeignTransaction.instance;
                    }
                }
            }
            catch (InvalidSlot e) {
                throw new RuntimeException("Exception getting slot in TxServerInterceptor: " + (Object)((Object)e));
            }
        }
        return tx;
    }

    private static TransactionPropagationContextImporter getTPCImporter() {
        if (tpcImporter == null) {
            try {
                InitialContext ctx = new InitialContext();
                tpcImporter = (TransactionPropagationContextImporter)ctx.lookup("java:/TransactionPropagationContextImporter");
            }
            catch (NamingException e) {
                throw new RuntimeException("java:/TransactionPropagationContextImporter lookup failed", e);
            }
        }
        return tpcImporter;
    }

    public String name() {
        return "TxServerInterceptor";
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) {
        try {
            ServiceContext sc = ri.get_request_service_context(0);
            Any any = codec.decode_value(sc.context_data, PropagationContextHelper.type());
            ri.set_slot(slotId, any);
        }
        catch (BAD_PARAM e) {
        }
        catch (FormatMismatch e) {
            throw new RuntimeException("Exception decoding context data in TxServerInterceptor: " + (Object)((Object)e));
        }
        catch (TypeMismatch e) {
            throw new RuntimeException("Exception decoding context data in TxServerInterceptor: " + (Object)((Object)e));
        }
        catch (InvalidSlot e) {
            throw new RuntimeException("Exception setting slot in TxServerInterceptor: " + (Object)((Object)e));
        }
    }

    public void receive_request(ServerRequestInfo ri) {
    }

    public void send_reply(ServerRequestInfo ri) {
    }

    public void send_exception(ServerRequestInfo ri) {
    }

    public void send_other(ServerRequestInfo ri) {
    }

    static {
        piCurrent = null;
        tpcImporter = null;
    }
}

