/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.cache;

import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;

public class DeployedTreeCache
implements Cache {
    private static final String ITEM = "item";
    private final TreeCache cache;
    private final String regionName;

    public DeployedTreeCache(String regionName, TreeCache cache) {
        this.regionName = '/' + regionName.replace('.', '/');
        this.cache = cache;
    }

    public Object get(Object key) throws CacheException {
        try {
            return this.cache.get(this.constructEntityFqn(key), (Object)ITEM);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void put(Object key, Object value) throws CacheException {
        try {
            this.cache.put(this.constructEntityFqn(key), (Object)ITEM, value);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            this.cache.remove(this.constructEntityFqn(key));
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.remove(this.constructRegionFqn());
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void destroy() throws CacheException {
        this.clear();
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return -1L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    private Fqn constructRegionFqn() {
        return new Fqn((Object)this.regionName);
    }

    private Fqn constructEntityFqn(Object entityKey) {
        return new Fqn(new Object[]{this.regionName, entityKey});
    }
}

