/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.cache;

import java.util.Properties;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CacheProvider;
import org.jboss.cache.TreeCache;
import org.jboss.hibernate.cache.DeployedTreeCache;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

public class DeployedTreeCacheProvider
implements CacheProvider {
    public static final String NAMESPACE_PROP_NAME = "hibernate.treecache.jndiName";
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$hibernate$cache$DeployedTreeCacheProvider == null ? (class$org$jboss$hibernate$cache$DeployedTreeCacheProvider = DeployedTreeCacheProvider.class$("org.jboss.hibernate.cache.DeployedTreeCacheProvider")) : class$org$jboss$hibernate$cache$DeployedTreeCacheProvider));
    private TreeCache deployedTreeCache;
    static /* synthetic */ Class class$org$jboss$hibernate$cache$DeployedTreeCacheProvider;
    static /* synthetic */ Class class$org$jboss$cache$TreeCache;

    public Cache buildCache(String name, Properties properties) throws CacheException {
        return new DeployedTreeCache(name, this.getOrLookupDeployedTreeCache(properties));
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeCache getOrLookupDeployedTreeCache(Properties properties) throws CacheException {
        try {
            Class clazz = class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = DeployedTreeCacheProvider.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache;
            synchronized (clazz) {
                if (this.deployedTreeCache == null) {
                    String jndiName = properties.getProperty(NAMESPACE_PROP_NAME);
                    if (jndiName == null || "".equals(jndiName)) {
                        throw new CacheException("Must specify jndi location of deployed TreeCache");
                    }
                    log.debug((Object)("TreeCache not previously looked up; obtaining from [" + jndiName + "]"));
                    this.deployedTreeCache = this.lookupDeployedTreeCache(jndiName);
                }
            }
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        return this.deployedTreeCache;
    }

    private TreeCache lookupDeployedTreeCache(String jndiName) throws Exception {
        try {
            return (TreeCache)Util.lookup((String)jndiName, (Class)(class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = DeployedTreeCacheProvider.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache));
        }
        catch (Exception e) {
            log.warn((Object)("Unable to locate TreeCache at specified namespace [" + jndiName + "]"), (Throwable)e);
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

