/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;

public class FaultableHandler
extends BasicHandler {
    private static Logger log = Logger.getLogger((String)FaultableHandler.class.getName());
    protected Handler workHandler;

    public FaultableHandler(Handler workHandler) {
        this.workHandler = workHandler;
    }

    public void init() {
        this.workHandler.init();
    }

    public void cleanup() {
        this.workHandler.cleanup();
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        log.debug((Object)"Enter: FaultableHandler::invoke");
        try {
            this.workHandler.invoke(msgContext);
        }
        catch (Exception e) {
            log.info((Object)Messages.getMessage("toAxisFault00"), (Throwable)e);
            AxisFault fault = AxisFault.makeFault(e);
            Handler faultHandler = null;
            Hashtable options = this.getOptions();
            if (options != null) {
                Enumeration enumeration = options.keys();
                while (enumeration.hasMoreElements()) {
                    String s = (String)enumeration.nextElement();
                    if (!s.equals("fault-" + fault.getFaultCode().getLocalPart())) continue;
                    faultHandler = (Handler)options.get(s);
                }
            }
            if (faultHandler != null) {
                faultHandler.invoke(msgContext);
            }
            throw fault;
        }
        log.debug((Object)"Exit: FaultableHandler::invoke");
    }

    public void onFault(MessageContext msgContext) {
        log.debug((Object)"Enter: FaultableHandler::onFault");
        this.workHandler.onFault(msgContext);
        log.debug((Object)"Exit: FaultableHandler::onFault");
    }

    public boolean canHandleBlock(QName qname) {
        return this.workHandler.canHandleBlock(qname);
    }
}

