/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.net;

import java.util.Hashtable;
import org.apache.axis.AxisProperties;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.axis.components.net.SocketFactory;
import org.jboss.logging.Logger;

public class SocketFactoryFactory {
    private static Logger log = Logger.getLogger((String)SocketFactoryFactory.class.getName());
    private static Hashtable factories = new Hashtable();
    private static final Class[] classes = new Class[]{Hashtable.class};

    public static synchronized SocketFactory getFactory(String protocol, Hashtable attributes) {
        SocketFactory theFactory = (SocketFactory)factories.get(protocol);
        if (theFactory == null) {
            Object[] objects = new Object[]{attributes};
            if (protocol.equalsIgnoreCase("http")) {
                theFactory = (SocketFactory)AxisProperties.newInstance(SocketFactory.class, classes, objects);
            } else if (protocol.equalsIgnoreCase("https")) {
                theFactory = (SecureSocketFactory)AxisProperties.newInstance(SecureSocketFactory.class, classes, objects);
            }
            if (theFactory != null) {
                factories.put(protocol, theFactory);
            }
        }
        return theFactory;
    }

    static {
        AxisProperties.setClassOverrideProperty(SocketFactory.class, "axis.socketFactory");
        AxisProperties.setClassDefault(SocketFactory.class, "org.apache.axis.components.net.DefaultSocketFactory");
        AxisProperties.setClassOverrideProperty(SecureSocketFactory.class, "axis.socketSecureFactory");
        AxisProperties.setClassDefault(SecureSocketFactory.class, "org.apache.axis.components.net.JSSESocketFactory");
    }
}

