/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.enum.Style;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCElementHandler;
import org.apache.axis.message.RPCHandler;
import org.apache.axis.message.SOAPBodyAxisImpl;
import org.apache.axis.message.SOAPBodyElementAxisImpl;
import org.apache.axis.message.SOAPElementAxisImpl;
import org.apache.axis.message.SOAPEnvelopeAxisImpl;
import org.apache.axis.message.SOAPFaultBuilder;
import org.apache.axis.message.SOAPFaultImpl;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BodyBuilder
extends SOAPHandler {
    private static Logger log = Logger.getLogger((String)BodyBuilder.class.getName());
    boolean gotRPCElement = false;
    private SOAPEnvelopeAxisImpl envelope;

    BodyBuilder(SOAPEnvelopeAxisImpl envelope) {
        this.envelope = envelope;
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
        if (context.getMessageContext() != null) {
            soapConstants = context.getMessageContext().getSOAPConstants();
        }
        if (soapConstants == SOAPConstants.SOAP12_CONSTANTS && attributes.getValue("http://www.w3.org/2002/12/soap-envelope", "encodingStyle") != null) {
            AxisFault fault = new AxisFault(Constants.FAULT_SOAP12_SENDER, null, Messages.getMessage("noEncodingStyleAttrAppear", "Body"), null, null, null);
            throw new SAXException(fault);
        }
        if (!context.isDoneParsing()) {
            if (!context.isProcessingRef()) {
                if (this.myElement == null) {
                    try {
                        this.myElement = new SOAPBodyAxisImpl(namespace, localName, prefix, attributes, context, this.envelope.getSOAPConstants());
                    }
                    catch (AxisFault axisFault) {
                        throw new SAXException(axisFault);
                    }
                }
                context.pushNewElement(this.myElement);
            }
            this.envelope.setBody((SOAPBodyAxisImpl)this.myElement);
        }
    }

    public SOAPElementAxisImpl makeNewElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws AxisFault {
        SOAP11Constants soapConstants = context.getMessageContext() == null ? SOAPConstants.SOAP11_CONSTANTS : context.getMessageContext().getSOAPConstants();
        return new SOAPBodyAxisImpl(namespace, localName, prefix, attributes, context, soapConstants);
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        SOAPConstants soapConstants;
        SOAPBodyElementAxisImpl element = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: BodyBuilder::onStartChild()");
        }
        QName qname = new QName(namespace, localName);
        SOAPHandler handler = null;
        boolean isRoot = true;
        String root = attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "root");
        if (root != null && root.equals("0")) {
            isRoot = false;
        }
        MessageContext msgContext = context.getMessageContext();
        OperationDesc[] operations = null;
        try {
            if (msgContext != null) {
                operations = msgContext.getPossibleOperationsByQName(qname);
            }
            if (operations != null && operations.length == 1) {
                msgContext.setOperation(operations[0]);
            }
        }
        catch (AxisFault e) {
            throw new SAXException(e);
        }
        Style style = operations == null ? Style.RPC : operations[0].getStyle();
        MessageContext messageContext = context.getMessageContext();
        SOAPConstants sOAPConstants = soapConstants = messageContext == null ? SOAPConstants.SOAP11_CONSTANTS : messageContext.getSOAPConstants();
        if ("Fault".equals(localName) && namespace.equals(soapConstants.getEnvelopeURI())) {
            try {
                element = new SOAPFaultImpl(namespace, localName, prefix, attributes, context);
            }
            catch (AxisFault axisFault) {
                throw new SAXException(axisFault);
            }
            element.setEnvelope(context.getEnvelope());
            handler = new SOAPFaultBuilder((SOAPFaultImpl)element, context);
        } else if (!this.gotRPCElement && isRoot && style != Style.MESSAGE) {
            this.gotRPCElement = true;
            try {
                element = new RPCElement(namespace, localName, prefix, attributes, context, operations);
            }
            catch (AxisFault e) {
                throw new SAXException(e);
            }
            if (operations == null && msgContext != null && !msgContext.isClient() && msgContext.getProperty("NoOperationOK") == null && soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                AxisFault fault = new AxisFault(Constants.FAULT_SOAP12_SENDER, "No such procedure", null, null);
                fault.addFaultSubCode(Constants.FAULT_SUBCODE_PROC_NOT_PRESENT);
                throw new SAXException(fault);
            }
            if (!(msgContext == null || msgContext.isHighFidelity() || operations != null && operations.length != 1)) {
                ((RPCElement)element).setNeedDeser(false);
                handler = new RPCHandler((RPCElement)element, false);
                if (operations != null) {
                    ((RPCHandler)handler).setOperation(operations[0]);
                    msgContext.setOperation(operations[0]);
                }
            }
            if (handler == null) {
                handler = new RPCElementHandler();
            }
        }
        if (element == null) {
            if (style == Style.RPC && soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                throw new SAXException(Messages.getMessage("onlyOneBodyFor12"));
            }
            try {
                element = new SOAPBodyElementAxisImpl(namespace, localName, prefix, attributes, context);
            }
            catch (AxisFault axisFault) {
                throw new SAXException(axisFault);
            }
            if (element.getFixupDeserializer() != null) {
                handler = (SOAPHandler)((Object)element.getFixupDeserializer());
            }
        }
        if (handler == null) {
            handler = new SOAPHandler();
        }
        handler.myElement = element;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: BodyBuilder::onStartChild()");
        }
        return handler;
    }

    public void onEndChild(String namespace, String localName, DeserializationContext context) {
    }
}

