/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.apache.axis.enum.Style;
import org.apache.axis.enum.Use;
import org.apache.axis.utils.LinkedHashMap;
import org.apache.axis.wsdl.symbolTable.MimeInfo;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;

public class BindingEntry
extends SymTabEntry {
    public static final int TYPE_SOAP = 0;
    public static final int TYPE_HTTP_GET = 1;
    public static final int TYPE_HTTP_POST = 2;
    public static final int TYPE_UNKNOWN = 3;
    public static final int USE_ENCODED = 0;
    public static final int USE_LITERAL = 1;
    public static final int NO_HEADER = 0;
    public static final int IN_HEADER = 1;
    public static final int OUT_HEADER = 2;
    private Binding binding;
    private int bindingType;
    private Style bindingStyle;
    private boolean hasLiteral;
    private Map attributes;
    private LinkedHashMap parameters = new LinkedHashMap();
    private Map faults = new LinkedHashMap();
    private Map mimeTypes;
    private Map headerParts;
    private ArrayList dimeOps = new ArrayList();

    public BindingEntry(Binding binding, int bindingType, Style bindingStyle, boolean hasLiteral, HashMap attributes, Map mimeTypes, Map headerParts) {
        super(binding.getQName());
        this.binding = binding;
        this.bindingType = bindingType;
        this.bindingStyle = bindingStyle;
        this.hasLiteral = hasLiteral;
        this.attributes = attributes == null ? new LinkedHashMap() : attributes;
        this.mimeTypes = mimeTypes == null ? new LinkedHashMap() : mimeTypes;
        this.headerParts = headerParts == null ? new LinkedHashMap() : headerParts;
    }

    public BindingEntry(Binding binding) {
        super(binding.getQName());
        this.binding = binding;
        this.bindingType = 3;
        this.bindingStyle = Style.DOCUMENT;
        this.hasLiteral = false;
        this.attributes = new LinkedHashMap();
        this.mimeTypes = new LinkedHashMap();
        this.headerParts = new LinkedHashMap();
    }

    public Parameters getParameters(Operation operation) {
        return (Parameters)this.parameters.get(operation);
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void setParameters(LinkedHashMap parameters) {
        this.parameters = parameters;
    }

    public MimeInfo getMIMEInfo(String operationName, String parameterName) {
        Map opMap = (Map)this.mimeTypes.get(operationName);
        if (opMap == null) {
            return null;
        }
        return (MimeInfo)opMap.get(parameterName);
    }

    public Map getMIMETypes() {
        return this.mimeTypes;
    }

    public void setMIMEInfo(String operationName, String parameterName, String type, String dims) {
        Map opMap = (Map)this.mimeTypes.get(operationName);
        if (opMap == null) {
            opMap = new LinkedHashMap();
            this.mimeTypes.put(operationName, opMap);
        }
        opMap.put(parameterName, new MimeInfo(type, dims));
    }

    public void setOperationDIME(String operationName) {
        if (this.dimeOps.indexOf(operationName) == -1) {
            this.dimeOps.add(operationName);
        }
    }

    public boolean isOperationDIME(String operationName) {
        return this.dimeOps.indexOf(operationName) >= 0;
    }

    public boolean isInHeaderPart(String operationName, String partName) {
        return (this.headerPart(operationName, partName) & 1) > 0;
    }

    public boolean isOutHeaderPart(String operationName, String partName) {
        return (this.headerPart(operationName, partName) & 2) > 0;
    }

    private int headerPart(String operationName, String partName) {
        Map opMap = (Map)this.headerParts.get(operationName);
        if (opMap == null) {
            return 0;
        }
        HeaderPart headerPart = (HeaderPart)opMap.get(partName);
        return headerPart == null ? 0 : headerPart.getFlags();
    }

    public Map getHeaderParts() {
        return this.headerParts;
    }

    public void setHeaderPart(String operationName, String partName, SOAPHeader soapHeader, int headerFlags) {
        Map opMap = (Map)this.headerParts.get(operationName);
        if (opMap == null) {
            opMap = new LinkedHashMap();
            this.headerParts.put(operationName, opMap);
        }
        QName message = soapHeader != null ? soapHeader.getMessage() : null;
        HeaderPart headerPart = (HeaderPart)opMap.get(partName);
        headerPart = headerPart == null ? new HeaderPart(partName, message, headerFlags) : new HeaderPart(partName, message, headerFlags | headerPart.getFlags());
        opMap.put(partName, headerPart);
    }

    public Binding getBinding() {
        return this.binding;
    }

    public int getBindingType() {
        return this.bindingType;
    }

    protected void setBindingType(int bindingType) {
        if (bindingType < 0 || bindingType <= 3) {
            // empty if block
        }
        this.bindingType = bindingType;
    }

    public Style getBindingStyle() {
        return this.bindingStyle;
    }

    protected void setBindingStyle(Style bindingStyle) {
        this.bindingStyle = bindingStyle;
    }

    public boolean hasLiteral() {
        return this.hasLiteral;
    }

    protected void setHasLiteral(boolean hasLiteral) {
        this.hasLiteral = hasLiteral;
    }

    public Use getInputBodyType(Operation operation) {
        OperationAttr attr = (OperationAttr)this.attributes.get(operation);
        if (attr == null) {
            return Use.ENCODED;
        }
        return attr.getInputBodyType();
    }

    protected void setInputBodyType(Operation operation, Use inputBodyType) {
        OperationAttr attr = (OperationAttr)this.attributes.get(operation);
        if (attr == null) {
            attr = new OperationAttr();
            this.attributes.put(operation, attr);
        }
        attr.setInputBodyType(inputBodyType);
        if (inputBodyType == Use.LITERAL) {
            this.setHasLiteral(true);
        }
    }

    public Use getOutputBodyType(Operation operation) {
        OperationAttr attr = (OperationAttr)this.attributes.get(operation);
        if (attr == null) {
            return Use.ENCODED;
        }
        return attr.getOutputBodyType();
    }

    protected void setOutputBodyType(Operation operation, Use outputBodyType) {
        OperationAttr attr = (OperationAttr)this.attributes.get(operation);
        if (attr == null) {
            attr = new OperationAttr();
            this.attributes.put(operation, attr);
        }
        attr.setOutputBodyType(outputBodyType);
        if (outputBodyType == Use.LITERAL) {
            this.setHasLiteral(true);
        }
    }

    protected void setBodyType(Operation operation, Use bodyType, boolean input) {
        if (input) {
            this.setInputBodyType(operation, bodyType);
        } else {
            this.setOutputBodyType(operation, bodyType);
        }
    }

    public Use getFaultBodyType(Operation operation, String faultName) {
        OperationAttr attr = (OperationAttr)this.attributes.get(operation);
        if (attr == null) {
            return Use.ENCODED;
        }
        Map m = attr.getFaultBodyTypeMap();
        SOAPFault soapFault = (SOAPFault)m.get(faultName);
        if (soapFault == null) {
            return Use.ENCODED;
        }
        String use = soapFault.getUse();
        if ("literal".equals(use)) {
            return Use.LITERAL;
        }
        return Use.ENCODED;
    }

    public Map getFaults() {
        return this.faults;
    }

    public void setFaults(Map faults) {
        this.faults = faults;
    }

    public Set getOperations() {
        return this.attributes.keySet();
    }

    protected void setFaultBodyTypeMap(Operation operation, Map faultBodyTypeMap) {
        OperationAttr attr = (OperationAttr)this.attributes.get(operation);
        if (attr == null) {
            attr = new OperationAttr();
            this.attributes.put(operation, attr);
        }
        attr.setFaultBodyTypeMap(faultBodyTypeMap);
    }

    protected static class HeaderPart {
        private String part;
        private QName message;
        private int flags;

        public HeaderPart(String part, QName message, int type) {
            this.part = part;
            this.message = message;
            this.flags = type;
        }

        public String getPartName() {
            return this.part;
        }

        public QName getMessageQName() {
            return this.message;
        }

        public int getFlags() {
            return this.flags;
        }

        public String toString() {
            return "[part=" + this.part + ",message=" + this.message + ",flags=" + this.flags + "]";
        }
    }

    protected static class OperationAttr {
        private Use inputBodyType;
        private Use outputBodyType;
        private Map faultBodyTypeMap;

        public OperationAttr(Use inputBodyType, Use outputBodyType, Map faultBodyTypeMap) {
            this.inputBodyType = inputBodyType;
            this.outputBodyType = outputBodyType;
            this.faultBodyTypeMap = faultBodyTypeMap;
        }

        public OperationAttr() {
            this.inputBodyType = Use.ENCODED;
            this.outputBodyType = Use.ENCODED;
            this.faultBodyTypeMap = null;
        }

        public Use getInputBodyType() {
            return this.inputBodyType;
        }

        protected void setInputBodyType(Use inputBodyType) {
            this.inputBodyType = inputBodyType;
        }

        public Use getOutputBodyType() {
            return this.outputBodyType;
        }

        protected void setOutputBodyType(Use outputBodyType) {
            this.outputBodyType = outputBodyType;
        }

        public Map getFaultBodyTypeMap() {
            return this.faultBodyTypeMap;
        }

        protected void setFaultBodyTypeMap(Map faultBodyTypeMap) {
            this.faultBodyTypeMap = faultBodyTypeMap;
        }
    }
}

