/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.BaseCertLoginModule;
import org.jboss.security.auth.spi.UsersRolesLoginModule;

public class CertRolesLoginModule
extends BaseCertLoginModule {
    private String rolesRsrcName = "roles.properties";
    private Properties roles;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"enter: initialize(Subject, CallbackHandler, Map, Map)");
        }
        try {
            String option = (String)options.get("rolesProperties");
            if (option != null) {
                this.rolesRsrcName = option;
            }
            this.loadRoles();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to load users/passwords/role files", (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"exit: initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"enter: login()");
        }
        if (this.roles == null) {
            throw new LoginException("Missing roles.properties file.");
        }
        boolean wasSuccessful = super.login();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"exit: login()");
        }
        return wasSuccessful;
    }

    protected Group[] getRoleSets() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"enter: getRoleSets()");
        }
        String targetUser = this.getUsername();
        Enumeration<?> users = this.roles.propertyNames();
        SimpleGroup rolesGroup = new SimpleGroup("Roles");
        ArrayList<SimpleGroup> groups = new ArrayList<SimpleGroup>();
        groups.add(rolesGroup);
        while (users.hasMoreElements() && targetUser != null) {
            String user = (String)users.nextElement();
            String value = this.roles.getProperty(user);
            boolean userMatch = targetUser.equals(user);
            if (!userMatch) continue;
            this.parseGroupMembers(rolesGroup, value);
        }
        Group[] roleSets = new Group[groups.size()];
        groups.toArray(roleSets);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"exit: getRoleSets()");
        }
        return roleSets;
    }

    private void parseGroupMembers(Group group, String roles) {
        StringTokenizer tokenizer = new StringTokenizer(roles, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                Principal p = this.createIdentity(token);
                group.addMember(p);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to create principal for: " + token), (Throwable)e);
            }
        }
    }

    private void loadRoles() throws IOException {
        this.roles = UsersRolesLoginModule.loadProperties(this.rolesRsrcName, this.log);
    }
}

