/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jacc;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import org.jboss.logging.Logger;
import org.jboss.security.jacc.SubjectPolicyContextHandler;

public class SecurityService {
    private static final String JACC_POLICY_PROVIDER = "javax.security.jacc.policy.provider";
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$security$jacc$SecurityService == null ? (class$org$jboss$security$jacc$SecurityService = SecurityService.class$("org.jboss.security.jacc.SecurityService")) : class$org$jboss$security$jacc$SecurityService));
    private Policy oldPolicy;
    private Policy jaccPolicy;
    private ObjectName policyName;
    private String policyAttributeName = "Policy";
    private MBeanServer server;
    static /* synthetic */ Class class$org$jboss$security$jacc$SecurityService;
    static /* synthetic */ Class class$java$security$Policy;

    public ObjectName getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(ObjectName policyName) {
        this.policyName = policyName;
    }

    public String getPolicyAttributeName() {
        return this.policyAttributeName;
    }

    public void setPolicyAttributeName(String policyAttributeName) {
        this.policyAttributeName = policyAttributeName;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public void start() throws Exception {
        this.oldPolicy = Policy.getPolicy();
        if (this.server != null && this.policyName != null && this.server.isRegistered(this.policyName)) {
            try {
                this.jaccPolicy = (Policy)this.server.getAttribute(this.policyName, this.policyAttributeName);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to get " + this.policyAttributeName + " attribute from: " + this.policyName), (Throwable)e);
            }
        }
        if (this.jaccPolicy == null) {
            String provider = SecurityService.getProperty(JACC_POLICY_PROVIDER, "org.jboss.security.jacc.DelegatingPolicy");
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> providerClass = loader.loadClass(provider);
            try {
                Class[] ctorSig = new Class[]{class$java$security$Policy == null ? (class$java$security$Policy = SecurityService.class$("java.security.Policy")) : class$java$security$Policy};
                Constructor<?> ctor = providerClass.getConstructor(ctorSig);
                Object[] ctorArgs = new Object[]{this.oldPolicy};
                this.jaccPolicy = (Policy)ctor.newInstance(ctorArgs);
            }
            catch (NoSuchMethodException e) {
                log.debug((Object)"Provider does not support ctor(Policy)");
                this.jaccPolicy = (Policy)providerClass.newInstance();
            }
        }
        Policy.setPolicy(this.jaccPolicy);
        this.jaccPolicy.refresh();
        SubjectPolicyContextHandler handler = new SubjectPolicyContextHandler();
        PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)handler, (boolean)false);
    }

    public void stop() throws Exception {
        if (this.jaccPolicy != null) {
            Policy.setPolicy(this.oldPolicy);
        }
    }

    static String getProperty(String name) {
        return SecurityService.getProperty(name, null);
    }

    static String getProperty(String name, String defaultValue) {
        PropertyAccessAction action = new PropertyAccessAction(name, defaultValue);
        String property = (String)AccessController.doPrivileged(action);
        return property;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;
        private String defaultValue;

        PropertyAccessAction(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public Object run() {
            return System.getProperty(this.name, this.defaultValue);
        }
    }
}

