/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.SecurityAssociation;

class SubjectActions {
    SubjectActions() {
    }

    static Subject getActiveSubject() {
        Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    static void setActiveSubject(Subject subject) {
        SetSubjectAction action = new SetSubjectAction(subject);
        AccessController.doPrivileged(action);
    }

    static void copySubject(Subject fromSubject, Subject toSubject) {
        SubjectActions.copySubject(fromSubject, toSubject, false);
    }

    static void copySubject(Subject fromSubject, Subject toSubject, boolean setReadOnly) {
        CopySubjectAction action = new CopySubjectAction(fromSubject, toSubject, setReadOnly);
        AccessController.doPrivileged(action);
    }

    static LoginContext createLoginContext(String securityDomain, Subject subject, CallbackHandler handler) throws LoginException {
        LoginContextAction action = new LoginContextAction(securityDomain, subject, handler);
        try {
            LoginContext lc = (LoginContext)AccessController.doPrivileged(action);
            return lc;
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw new LoginException(ex.getMessage());
        }
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(GetTCLAction.ACTION);
        return loader;
    }

    static Object setContextInfo(Object key, Object value) {
        SetContextInfoAction action = new SetContextInfoAction(key, value);
        Object prevInfo = AccessController.doPrivileged(action);
        return prevInfo;
    }

    private static class SetContextInfoAction
    implements PrivilegedAction {
        Object key;
        Object value;

        SetContextInfoAction(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object run() {
            return SecurityAssociation.setContextInfo(this.key, this.value);
        }
    }

    private static class GetTCLAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        public Object run() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader;
        }
    }

    private static class LoginContextAction
    implements PrivilegedExceptionAction {
        String securityDomain;
        Subject subject;
        CallbackHandler handler;

        LoginContextAction(String securityDomain, Subject subject, CallbackHandler handler) {
            this.securityDomain = securityDomain;
            this.subject = subject;
            this.handler = handler;
        }

        public Object run() throws Exception {
            LoginContext lc = new LoginContext(this.securityDomain, this.subject, this.handler);
            return lc;
        }
    }

    private static class CopySubjectAction
    implements PrivilegedAction {
        Subject fromSubject;
        Subject toSubject;
        boolean setReadOnly;

        CopySubjectAction(Subject fromSubject, Subject toSubject, boolean setReadOnly) {
            this.fromSubject = fromSubject;
            this.toSubject = toSubject;
            this.setReadOnly = setReadOnly;
        }

        public Object run() {
            Set<Principal> principals = this.fromSubject.getPrincipals();
            Set<Principal> principals2 = this.toSubject.getPrincipals();
            Iterator<Object> iter = principals.iterator();
            while (iter.hasNext()) {
                principals2.add(iter.next());
            }
            Set<Object> privateCreds = this.fromSubject.getPrivateCredentials();
            Set<Object> privateCreds2 = this.toSubject.getPrivateCredentials();
            iter = privateCreds.iterator();
            while (iter.hasNext()) {
                privateCreds2.add(iter.next());
            }
            Set<Object> publicCreds = this.fromSubject.getPublicCredentials();
            Set<Object> publicCreds2 = this.toSubject.getPublicCredentials();
            iter = publicCreds.iterator();
            while (iter.hasNext()) {
                publicCreds2.add(iter.next());
            }
            if (this.setReadOnly) {
                this.toSubject.setReadOnly();
            }
            return null;
        }
    }

    private static class SetSubjectAction
    implements PrivilegedAction {
        Subject subject;

        SetSubjectAction(Subject subject) {
            this.subject = subject;
        }

        public Object run() {
            SecurityAssociation.setSubject(this.subject);
            return null;
        }
    }

    private static class GetSubjectAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        public Object run() {
            Subject subject = SecurityAssociation.getSubject();
            return subject;
        }
    }
}

