/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityDomain;

class Context {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$ssl$Context == null ? (class$org$jboss$security$ssl$Context = Context.class$("org.jboss.security.ssl.Context")) : class$org$jboss$security$ssl$Context));
    static /* synthetic */ Class class$org$jboss$security$ssl$Context;

    Context() {
    }

    static SSLContext forDomain(SecurityDomain securityDomain) throws IOException {
        SSLContext sslCtx = null;
        try {
            sslCtx = SSLContext.getInstance("TLS");
            KeyManagerFactory keyMgr = securityDomain.getKeyManagerFactory();
            if (keyMgr == null) {
                throw new IOException("KeyManagerFactory is null for security domain: " + securityDomain.getSecurityDomain());
            }
            TrustManagerFactory trustMgr = securityDomain.getTrustManagerFactory();
            TrustManager[] trustMgrs = null;
            if (trustMgr != null) {
                trustMgrs = trustMgr.getTrustManagers();
            }
            sslCtx.init(keyMgr.getKeyManagers(), trustMgrs, null);
            return sslCtx;
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Failed to get SSLContext for TLS algorithm", (Throwable)e);
            throw new IOException("Failed to get SSLContext for TLS algorithm");
        }
        catch (KeyManagementException e) {
            log.error((Object)"Failed to init SSLContext", (Throwable)e);
            throw new IOException("Failed to init SSLContext");
        }
        catch (SecurityException e) {
            log.error((Object)"Failed to init SSLContext", (Throwable)e);
            throw new IOException("Failed to init SSLContext");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

