/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerRegistry;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.handlers.HandlerChainImpl;
import org.apache.axis.handlers.HandlerInfoChainFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;

public class AxisClient
extends AxisEngine {
    private static Logger log = Logger.getLogger((String)AxisClient.class.getName());

    public AxisClient(EngineConfiguration config) {
        super(config);
    }

    public AxisClient() {
        this(EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig());
    }

    public AxisEngine getClientEngine() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: AxisClient::invoke");
        }
        String hName = null;
        Handler h = null;
        MessageContext previousContext = AxisClient.getCurrentMessageContext();
        try {
            AxisClient.setCurrentMessageContext(msgContext);
            hName = msgContext.getStrProp("engine.handler");
            if (log.isDebugEnabled()) {
                log.debug((Object)("EngineHandler: " + hName));
            }
            if (hName != null) {
                h = this.getHandler(hName);
                if (h == null) throw new AxisFault("Client.error", Messages.getMessage("noHandler00", hName), null, null);
                h.invoke(msgContext);
            } else {
                SOAPService service = null;
                msgContext.setPastPivot(false);
                service = msgContext.getService();
                if (service != null && (h = service.getRequestHandler()) != null) {
                    h.invoke(msgContext);
                }
                if ((h = this.getGlobalRequest()) != null) {
                    h.invoke(msgContext);
                }
                this.invokeJAXRPCHandlers(msgContext);
                hName = msgContext.getTransportName();
                if (hName == null || (h = this.getTransport(hName)) == null) {
                    throw new AxisFault(Messages.getMessage("noTransport00", hName));
                }
                h.invoke(msgContext);
                this.invokeJAXRPCHandlers(msgContext);
                h = this.getGlobalResponse();
                if (h != null) {
                    h.invoke(msgContext);
                }
                if (service != null && (h = service.getResponseHandler()) != null) {
                    h.invoke(msgContext);
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)Messages.getMessage("exception00"), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        finally {
            AxisClient.setCurrentMessageContext(previousContext);
        }
        if (!log.isDebugEnabled()) return;
        log.debug((Object)"Exit: AxisClient::invoke");
    }

    protected void invokeJAXRPCHandlers(MessageContext context) {
        SOAPService soapService;
        List chain = null;
        HandlerInfoChainFactory hiChainFactory = null;
        boolean clientSpecified = false;
        Service service = (Service)context.getProperty("wsdl.service");
        if (service == null) {
            return;
        }
        QName portName = (QName)context.getProperty("wsdl.portName");
        if (portName == null) {
            return;
        }
        HandlerRegistry registry = service.getHandlerRegistry();
        if (registry != null && (chain = registry.getHandlerChain(portName)) != null && !chain.isEmpty()) {
            hiChainFactory = new HandlerInfoChainFactory(chain);
            clientSpecified = true;
        }
        if (!clientSpecified && (soapService = context.getService()) != null) {
            hiChainFactory = (HandlerInfoChainFactory)soapService.getOption("handlerInfoChain");
        }
        if (hiChainFactory == null) {
            return;
        }
        HandlerChainImpl impl = (HandlerChainImpl)hiChainFactory.createHandlerChain();
        if (!context.getPastPivot()) {
            impl.handleRequest((javax.xml.rpc.handler.MessageContext)context);
        } else {
            impl.handleResponse((javax.xml.rpc.handler.MessageContext)context);
        }
        impl.destroy();
    }
}

