/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.MessagePart;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.DeserializationContextImpl;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.enum.Style;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.NameImpl;
import org.apache.axis.message.NamedNodeMapImpl;
import org.apache.axis.message.NodeImpl;
import org.apache.axis.message.NodeListImpl;
import org.apache.axis.message.NullAttributes;
import org.apache.axis.message.SAX2EventRecorder;
import org.apache.axis.message.SAXOutputter;
import org.apache.axis.message.SOAPElementImpl;
import org.apache.axis.message.SOAPEnvelopeAxisImpl;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.message.TextImpl;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.jboss.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SOAPElementAxisImpl
extends SOAPElementImpl
implements SOAPElement,
Serializable,
Cloneable {
    private static Logger log = Logger.getLogger((String)SOAPElementAxisImpl.class.getName());
    protected String name;
    protected String prefix;
    protected String namespaceURI;
    protected transient Attributes attributes = NullAttributes.singleton;
    protected String id;
    protected String href;
    protected boolean _isRoot = true;
    protected SOAPEnvelopeAxisImpl message;
    protected transient DeserializationContext context;
    protected transient QName typeQName;
    protected Vector qNameAttrs;
    protected transient SAX2EventRecorder recorder;
    protected int startEventIndex;
    protected int startContentsIndex;
    protected int endEventIndex = -1;
    protected Element elementRep;
    private SOAPElementAxisImpl parent;
    public ArrayList namespaces;
    protected String encodingStyle;
    private Object objectValue;
    private ChildElementList children = new ChildElementList();
    protected MessagePart soapPart;
    private boolean immutable;
    Deserializer fixupDeserializer;
    private boolean isDirty;

    public SOAPElementAxisImpl() {
        super("unqualified-element");
    }

    public SOAPElementAxisImpl(String localPart) {
        super(localPart);
        this.namespaceURI = "";
        this.name = localPart;
    }

    public SOAPElementAxisImpl(String namespace, String localPart) {
        super(localPart, null, namespace);
        this.namespaceURI = namespace;
        this.name = localPart;
    }

    public SOAPElementAxisImpl(String localPart, String prefix, String namespace) {
        super(localPart, prefix, namespace);
        this.namespaceURI = namespace;
        this.name = localPart;
        this.prefix = prefix;
        if (prefix != null && prefix.length() > 0) {
            this.addMapping(new Mapping(namespace, prefix));
        }
    }

    public SOAPElementAxisImpl(Name eltName) {
        super(eltName);
        this.namespaceURI = eltName.getURI();
        this.name = eltName.getLocalName();
        this.prefix = eltName.getPrefix();
        if (this.prefix != null && this.prefix.length() > 0) {
            this.addMapping(new Mapping(this.namespaceURI, this.prefix));
        }
    }

    public SOAPElementAxisImpl(String namespace, String localPart, Object value) {
        super(localPart, "", namespace);
        this.namespaceURI = namespace;
        this.name = localPart;
        this.objectValue = value;
    }

    public SOAPElementAxisImpl(QName name, Object value) {
        super(name.getLocalPart(), name.getPrefix(), name.getNamespaceURI());
        this.namespaceURI = name.getNamespaceURI();
        this.prefix = name.getPrefix();
        this.name = name.getLocalPart();
        this.objectValue = value;
    }

    public SOAPElementAxisImpl(Element elem) {
        super(elem);
        this.namespaceURI = elem.getNamespaceURI();
        this.prefix = elem.getPrefix();
        this.name = elem.getLocalName();
        this.elementRep = elem;
    }

    public SOAPElementAxisImpl(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context) throws AxisFault {
        super(localPart, prefix, namespace);
        this.namespaceURI = namespace;
        this.name = localPart;
        this.prefix = prefix;
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("newElem00", super.toString(), "{" + prefix + "}" + localPart));
            for (int i = 0; attributes != null && i < attributes.getLength(); ++i) {
                log.debug((Object)("  " + attributes.getQName(i) + " = '" + attributes.getValue(i) + "'"));
            }
        }
        this.context = context;
        this.startEventIndex = context.getStartOfMappingsPos();
        this.setNSMappings(context.getCurrentNSMappings());
        this.recorder = context.getRecorder();
        if (attributes != null && attributes.getLength() > 0) {
            TypeMapping tm;
            MessageContext mc;
            this.attributes = attributes;
            this.typeQName = context.getTypeFromAttributes(namespace, localPart, attributes);
            String rootVal = attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "root");
            if (rootVal != null) {
                this._isRoot = rootVal.equals("1");
            }
            this.id = attributes.getValue("id");
            if (this.id != null) {
                context.registerElementByID(this.id, this);
                if (this.recorder == null) {
                    this.recorder = new SAX2EventRecorder();
                    context.setRecorder(this.recorder);
                }
            }
            SOAPConstants sc = (mc = context.getMessageContext()) != null ? mc.getSOAPConstants() : SOAPConstants.SOAP11_CONSTANTS;
            this.href = attributes.getValue(sc.getAttrHref());
            if (attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "arrayType") != null) {
                this.typeQName = Constants.SOAP_ARRAY;
            }
            this.encodingStyle = attributes.getValue(sc.getEncodingURI(), "encodingStyle");
            if ("http://www.w3.org/2002/12/soap-envelope/encoding/none".equals(this.encodingStyle)) {
                this.encodingStyle = null;
            }
            if (this.encodingStyle != null && sc.equals(SOAPConstants.SOAP12_CONSTANTS) && mc.getOperationStyle() != Style.MESSAGE && ((tm = mc.getTypeMappingRegistry().getTypeMapping(this.encodingStyle)) == null || tm.equals(mc.getTypeMappingRegistry().getDefaultTypeMapping()))) {
                AxisFault badEncodingFault = new AxisFault(Constants.FAULT_SOAP12_DATAENCODINGUNKNOWN, "bad encoding style", null, null);
                throw badEncodingFault;
            }
        }
    }

    public void setFixupDeserializer(Deserializer dser) {
        this.fixupDeserializer = dser;
    }

    public Deserializer getFixupDeserializer() {
        return this.fixupDeserializer;
    }

    public void setEndIndex(int endIndex) {
        this.endEventIndex = endIndex;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public boolean isRoot() {
        return this._isRoot;
    }

    public String getID() {
        return this.id;
    }

    public String getHref() {
        return this.href;
    }

    public Attributes getAttributesEx() {
        return this.attributes;
    }

    public Node getFirstChild() {
        if (this.children != null && !this.children.isEmpty()) {
            return this.children.get(0);
        }
        return null;
    }

    public Node getLastChild() {
        List children = this.getChildren();
        if (children != null) {
            return (Node)children.get(children.size() - 1);
        }
        return null;
    }

    public Node getNextSibling() {
        SOAPElement parent = this.getParentElement();
        if (parent == null) {
            return null;
        }
        Iterator iter = parent.getChildElements();
        Node nextSibling = null;
        while (iter.hasNext()) {
            if (!iter.next().equals(this)) continue;
            if (iter.hasNext()) {
                return (Node)iter.next();
            }
            return null;
        }
        return nextSibling;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public Node getPreviousSibling() {
        SOAPElement parent = this.getParentElement();
        Iterator iter = parent.getChildElements();
        Node previousSibling = null;
        while (iter.hasNext()) {
            if (!iter.next().equals(this)) continue;
            return previousSibling;
        }
        return previousSibling;
    }

    public Node cloneNode(boolean deep) {
        try {
            SOAPElementAxisImpl clonedSelf = (SOAPElementAxisImpl)this.clonning();
            if (deep && this.children != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    SOAPElementAxisImpl child = (SOAPElementAxisImpl)((Object)this.children.get(i));
                    if (child == null) continue;
                    SOAPElementAxisImpl clonedChild = (SOAPElementAxisImpl)((Object)child.cloneNode(deep));
                    clonedChild.setParent(clonedSelf);
                    clonedChild.setOwnerDocument(this.soapPart);
                }
            }
            return clonedSelf;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Object clonning() throws CloneNotSupportedException {
        try {
            SOAPElementAxisImpl clonedME = null;
            clonedME = (SOAPElementAxisImpl)this.clone();
            clonedME.setName(this.name);
            clonedME.setNamespaceURI(this.namespaceURI);
            clonedME.setPrefix(this.prefix);
            clonedME.setAllAttributes(new AttributesImpl(this.attributes));
            clonedME.namespaces = new ArrayList();
            if (this.namespaces != null) {
                for (int i = 0; i < this.namespaces.size(); ++i) {
                    Mapping namespace = (Mapping)this.namespaces.get(i);
                    clonedME.addNamespaceDeclaration(namespace.getPrefix(), namespace.getNamespaceURI());
                }
            }
            clonedME.detachAllChildren();
            clonedME.setParent(null);
            clonedME.setDirty(this.isDirty());
            if (this.encodingStyle != null) {
                clonedME.setEncodingStyle(new String(this.encodingStyle));
            }
            clonedME.setRecorder(this.recorder);
            return clonedME;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setAllAttributes(Attributes attrs) {
        this.attributes = attrs;
    }

    public void detachAllChildren() {
        this.children.clear();
    }

    public NodeList getChildNodes() {
        NodeListImpl nodeList = new NodeListImpl();
        for (int i = 0; i < this.children.size(); ++i) {
            Node node = this.children.get(i);
            nodeList.addNode(node);
        }
        return nodeList;
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public Node appendChild(Node newChild) throws DOMException {
        super.appendChild(newChild);
        this.children.add(newChild);
        return newChild;
    }

    public void addChild(SOAPElementAxisImpl el) throws SOAPException {
        this.assertImmutable();
        el.parent = this;
        this.children.add((Node)((Object)el));
    }

    private void assertImmutable() {
        SOAPEnvelopeAxisImpl env = this.getSOAPEnvelope();
        if (env != null && env.isProcessingRPCInvocation() && this.immutable) {
            throw new JAXRPCException("Cannot modify an immutable element");
        }
    }

    public Node removeChild(Node oldChild) throws DOMException {
        int position = this.children.indexOf(oldChild);
        if (position < 0) {
            throw new DOMException(8, "MessageElement Not found");
        }
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!node.equals(oldChild)) continue;
            log.debug((Object)("Remove child node: " + node.getNodeName()));
            it.remove();
        }
        this.setDirty(true);
        return oldChild;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        int position = this.children.indexOf(refChild);
        if (position < 0) {
            position = 0;
        }
        this.children.add(position, newChild);
        this.setDirty(true);
        return newChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        int position = this.children.indexOf(oldChild);
        if (position < 0) {
            throw new DOMException(8, "MessageElement Not found");
        }
        this.children.remove(position);
        this.children.add(position, newChild);
        this.setDirty(true);
        return oldChild;
    }

    public Attributes getCompleteAttributes() {
        if (this.namespaces == null) {
            return this.attributes;
        }
        AttributesImpl attrs = null;
        attrs = this.attributes == NullAttributes.singleton ? new AttributesImpl() : new AttributesImpl(this.attributes);
        Iterator iterator = this.namespaces.iterator();
        while (iterator.hasNext()) {
            Mapping mapping = (Mapping)iterator.next();
            String prefix = mapping.getPrefix();
            String nsURI = mapping.getNamespaceURI();
            attrs.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, nsURI, "CDATA");
        }
        return attrs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QName getQName() {
        return new QName(this.namespaceURI, this.name);
    }

    public void setQName(QName qName) {
        this.name = qName.getLocalPart();
        this.namespaceURI = qName.getNamespaceURI();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Document getOwnerDocument() {
        return this.soapPart;
    }

    public NamedNodeMap getAttributes() {
        this.makeAttributesEditable();
        return this.convertAttrSAXtoDOM(this.attributes);
    }

    private NamedNodeMap convertAttrSAXtoDOM(Attributes saxAttr) {
        try {
            Document doc = XMLUtils.newDocument();
            AttributesImpl saxAttrs = (AttributesImpl)saxAttr;
            NamedNodeMapImpl domAttributes = new NamedNodeMapImpl();
            for (int i = 0; i < saxAttrs.getLength(); ++i) {
                Attr attr;
                String uri = saxAttrs.getURI(i);
                String qname = saxAttrs.getQName(i);
                String value = saxAttrs.getValue(i);
                if (uri != null && uri.trim().length() > 0) {
                    if (uri.equals("intentionalNullURI")) {
                        uri = null;
                    }
                    attr = doc.createAttributeNS(uri, qname);
                    attr.setValue(value);
                    domAttributes.setNamedItemNS(attr);
                    continue;
                }
                attr = doc.createAttribute(qname);
                attr.setValue(value);
                domAttributes.setNamedItem(attr);
            }
            return domAttributes;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public short getNodeType() {
        return 1;
    }

    public void normalize() {
    }

    public boolean hasAttributes() {
        return this.attributes.getLength() > 0;
    }

    public boolean hasChildNodes() {
        return this.children.size() > 0;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getNodeValue() throws DOMException {
        throw new DOMException(6, "Cannot use TextNode.get in " + this);
    }

    public void setNamespaceURI(String nsURI) {
        this.namespaceURI = nsURI;
    }

    public QName getType() {
        SOAPElementAxisImpl referent;
        if (this.typeQName == null && this.href != null && this.context != null && (referent = this.context.getElementByID(this.href)) != null) {
            this.typeQName = referent.getType();
        }
        return this.typeQName;
    }

    public void setType(QName qname) {
        this.typeQName = qname;
    }

    public SAX2EventRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(SAX2EventRecorder rec) {
        this.recorder = rec;
    }

    public String getEncodingStyle() {
        if (this.encodingStyle == null) {
            if (this.parent == null) {
                return "";
            }
            return this.parent.getEncodingStyle();
        }
        return this.encodingStyle;
    }

    public void removeContents() {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                try {
                    ((SOAPElementAxisImpl)((Object)this.children.get(i))).setParent(null);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.children.clear();
        }
    }

    public Iterator getVisibleNamespacePrefixes() {
        Iterator mine;
        Iterator parentsPrefixes;
        Vector prefixes = new Vector();
        if (this.parent != null && (parentsPrefixes = this.parent.getVisibleNamespacePrefixes()) != null) {
            while (parentsPrefixes.hasNext()) {
                prefixes.add(parentsPrefixes.next());
            }
        }
        if ((mine = this.getNamespacePrefixes()) != null) {
            while (mine.hasNext()) {
                prefixes.add(mine.next());
            }
        }
        return prefixes.iterator();
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (encodingStyle == null) {
            encodingStyle = "";
        }
        this.encodingStyle = encodingStyle;
        if (!encodingStyle.equals("")) {
            SOAP11Constants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
            this.addAttribute(this.getPrefix(soapConstants.getEnvelopeURI()), soapConstants.getEnvelopeURI(), "encodingStyle", encodingStyle);
        }
    }

    private SOAPElementAxisImpl getParent() {
        return this.parent;
    }

    private void setParent(SOAPElementAxisImpl parent) throws SOAPException {
        this.parent = parent;
        if (parent != null && !parent.children.contains((Node)((Object)this))) {
            parent.addChild(this);
        }
    }

    void removeChildren() {
        while (!this.children.isEmpty()) {
            this.removeChild((Node)((Object)((SOAPElementAxisImpl)((Object)this.children.get(0)))));
        }
    }

    public void setContentsIndex(int index) {
        this.startContentsIndex = index;
    }

    public void setNSMappings(ArrayList namespaces) {
        this.namespaces = namespaces;
    }

    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null || namespaceURI.equals("")) {
            return null;
        }
        if (this.href != null && this.getRealElement() != null) {
            return this.getRealElement().getPrefix(namespaceURI);
        }
        for (int i = 0; this.namespaces != null && i < this.namespaces.size(); ++i) {
            Mapping map = (Mapping)this.namespaces.get(i);
            if (!map.getNamespaceURI().equals(namespaceURI)) continue;
            return map.getPrefix();
        }
        if (this.parent != null) {
            return this.parent.getPrefix(namespaceURI);
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (this.href != null && this.getRealElement() != null) {
            return this.getRealElement().getNamespaceURI(prefix);
        }
        for (int i = 0; this.namespaces != null && i < this.namespaces.size(); ++i) {
            Mapping map = (Mapping)this.namespaces.get(i);
            if (!map.getPrefix().equals(prefix)) continue;
            return map.getNamespaceURI();
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("noPrefix00", "" + this, prefix));
        }
        return null;
    }

    public Object getObjectValue() {
        Object obj = null;
        try {
            obj = this.getObjectValue(null);
        }
        catch (Exception e) {
            log.debug((Object)"getValue()", (Throwable)e);
        }
        return obj;
    }

    public Object getObjectValue(Class cls) throws Exception {
        if (this.objectValue == null) {
            this.objectValue = this.getValueAsType(this.getType(), cls);
        }
        return this.objectValue;
    }

    public void setObjectValue(Object newValue) throws SOAPException {
        if (this.children != null && !this.children.isEmpty()) {
            SOAPException exc = new SOAPException(Messages.getMessage("childPresent"));
            log.error((Object)Messages.getMessage("childPresent"), (Throwable)exc);
            throw exc;
        }
        if (this.elementRep != null) {
            SOAPException exc = new SOAPException(Messages.getMessage("xmlPresent"));
            log.error((Object)Messages.getMessage("xmlPresent"), (Throwable)exc);
            throw exc;
        }
        this.objectValue = newValue;
    }

    public Object getValueAsType(QName type) throws Exception {
        return this.getValueAsType(type, null);
    }

    public Object getValueAsType(QName type, Class cls) throws Exception {
        if (this.context == null) {
            throw new Exception(Messages.getMessage("noContext00"));
        }
        Deserializer dser = null;
        dser = cls == null ? this.context.getDeserializerForType(type) : this.context.getDeserializerForClass(cls);
        if (dser == null) {
            throw new Exception(Messages.getMessage("noDeser00", "" + type));
        }
        boolean oldVal = this.context.isDoneParsing();
        ((DeserializationContextImpl)this.context).deserializing(true);
        this.context.pushElementHandler(new EnvelopeHandler((SOAPHandler)((Object)dser)));
        this.publishToHandler((ContentHandler)((Object)this.context));
        ((DeserializationContextImpl)this.context).deserializing(oldVal);
        return dser.getValue();
    }

    public void addAttribute(String namespace, String localName, QName value) {
        if (this.qNameAttrs == null) {
            this.qNameAttrs = new Vector();
        }
        QNameAttr attr = new QNameAttr();
        attr.name = new QName(namespace, localName);
        attr.value = value;
        this.qNameAttrs.addElement(attr);
    }

    protected AttributesImpl makeAttributesEditable() {
        if (this.attributes == null || this.attributes instanceof NullAttributes) {
            this.attributes = new AttributesImpl();
        } else if (!(this.attributes instanceof AttributesImpl)) {
            this.attributes = new AttributesImpl(this.attributes);
        }
        return (AttributesImpl)this.attributes;
    }

    public void addAttribute(String namespace, String localName, String value) {
        AttributesImpl attributes = this.makeAttributesEditable();
        attributes.addAttribute(namespace, localName, localName, "CDATA", value);
    }

    public void addAttribute(String prefix, String namespace, String localName, String value) {
        AttributesImpl attributes = this.makeAttributesEditable();
        String attrName = localName;
        if (prefix != null && prefix.length() > 0) {
            attrName = prefix + ":" + localName;
        }
        attributes.addAttribute(namespace, localName, attrName, "CDATA", value);
    }

    public void setAttribute(String namespace, String localName, String value) {
        AttributesImpl attributes = this.makeAttributesEditable();
        int idx = attributes.getIndex(namespace, localName);
        if (idx > -1) {
            if (value != null) {
                attributes.setValue(idx, value);
            } else {
                attributes.removeAttribute(idx);
            }
            return;
        }
        this.addAttribute(namespace, localName, value);
    }

    public String getAttributeValue(String localName) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getValue(localName);
    }

    public void setEnvelope(SOAPEnvelopeAxisImpl env) {
        env.setDirty(true);
        this.message = env;
    }

    public SOAPEnvelopeAxisImpl getEnvelope() {
        return this.message;
    }

    public SOAPElementAxisImpl getRealElement() {
        if (this.href == null) {
            return this;
        }
        Object obj = this.context.getObjectByRef(this.href);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof SOAPElementAxisImpl)) {
            return null;
        }
        return (SOAPElementAxisImpl)obj;
    }

    public Element getAsDOM() {
        try {
            return this.getAsDocument().getDocumentElement();
        }
        catch (Exception e) {
            log.error((Object)("Cannot get element as DOM: " + this.getElementName()), (Throwable)e);
            return null;
        }
    }

    public Document getAsDocument() {
        Document doc = null;
        try {
            String elementString = this.getAsString();
            StringReader reader = new StringReader(elementString);
            doc = XMLUtils.newDocument(new InputSource(reader));
        }
        catch (Exception e) {
            log.error((Object)"Cannot serialize element", (Throwable)e);
            throw new IllegalStateException(e.toString());
        }
        return doc;
    }

    public String getAsString() {
        SerializationContextImpl serializeContext = null;
        StringWriter writer = new StringWriter();
        try {
            MessageContext msgContext = this.context != null ? this.context.getMessageContext() : MessageContext.getCurrentContext();
            serializeContext = new SerializationContextImpl(writer, msgContext);
            serializeContext.setSendDecl(false);
            this.output(serializeContext);
            writer.close();
        }
        catch (Exception e) {
            log.error((Object)"Cannot serialize element", (Throwable)e);
            throw new IllegalStateException(e.toString());
        }
        return writer.getBuffer().toString();
    }

    public String getAsStringFromInternal() {
        try {
            StringWriter sw = new StringWriter(1024);
            SOAPElementAxisImpl.printFromInternal(new PrintWriter(sw), this);
            return sw.toString();
        }
        catch (Exception e) {
            log.error((Object)"Cannot parser internal element representation", (Throwable)e);
            return null;
        }
    }

    public static void printFromInternal(PrintWriter out, NodeImpl node) throws Exception {
        if (node instanceof Text) {
            out.print(node.getNodeValue());
            return;
        }
        SOAPElementAxisImpl el = (SOAPElementAxisImpl)node;
        if (el.getChildren().size() == 0) {
            SOAPElementAxisImpl.printStartElement(out, el);
            SOAPElementAxisImpl.printEndElement(out, el);
            return;
        }
        if (el.getChildren().size() == 1 && el.getFirstChild() instanceof Text) {
            SOAPElementAxisImpl.printStartElement(out, el);
            out.print(el.getValue());
            SOAPElementAxisImpl.printEndElement(out, el);
            return;
        }
        SOAPElementAxisImpl.printStartElement(out, el);
        Iterator it = el.getChildren().iterator();
        while (it.hasNext()) {
            NodeImpl child = (NodeImpl)it.next();
            SOAPElementAxisImpl.printFromInternal(out, child);
        }
        SOAPElementAxisImpl.printEndElement(out, el);
    }

    private static void printStartElement(PrintWriter out, SOAPElementAxisImpl el) {
        if (el.prefix != null && el.prefix.length() > 0) {
            out.print("<" + el.prefix + ":" + el.name);
        } else {
            out.print("<" + el.name);
        }
        for (int i = 0; i < el.attributes.getLength(); ++i) {
            out.print(" " + el.attributes.getQName(i) + "='" + el.attributes.getValue(i) + "'");
        }
        if (el.namespaces != null) {
            Iterator i = el.namespaces.iterator();
            while (i.hasNext()) {
                Mapping mapping = (Mapping)i.next();
                out.print(" xmlns:" + mapping.getPrefix() + "='" + mapping.getNamespaceURI() + "'");
            }
        }
        if (el.getChildren().size() > 0) {
            out.print(">");
        } else {
            out.print("/>");
        }
    }

    private static void printEndElement(PrintWriter out, SOAPElementAxisImpl el) {
        if (el.getChildren().size() > 0) {
            if (el.prefix != null && el.prefix.length() > 0) {
                out.print("</" + el.prefix + ":" + el.name + ">");
            } else {
                out.print("</" + el.name + ">");
            }
        }
    }

    public void publishToHandler(ContentHandler handler) throws SAXException {
        if (this.recorder == null) {
            throw new SAXException(Messages.getMessage("noRecorder00"));
        }
        this.recorder.replay(this.startEventIndex, this.endEventIndex, handler);
    }

    public void publishContents(ContentHandler handler) throws SAXException {
        if (this.recorder == null) {
            throw new SAXException(Messages.getMessage("noRecorder00"));
        }
        this.recorder.replay(this.startContentsIndex, this.endEventIndex - 1, handler);
    }

    public final void output(SerializationContext context) throws Exception {
        if (this.recorder != null && !this.isDirty()) {
            this.recorder.replay(this.startEventIndex, this.endEventIndex, new SAXOutputter(context));
            return;
        }
        if (this.qNameAttrs != null) {
            for (int i = 0; i < this.qNameAttrs.size(); ++i) {
                QNameAttr attr = (QNameAttr)this.qNameAttrs.get(i);
                QName attrName = attr.name;
                this.setAttribute(attrName.getNamespaceURI(), attrName.getLocalPart(), context.qName2String(attr.value));
            }
        }
        if (this.encodingStyle != null) {
            SOAPConstants soapConstants;
            MessageContext mc = context.getMessageContext();
            SOAPConstants sOAPConstants = soapConstants = mc != null ? mc.getSOAPConstants() : SOAPConstants.SOAP11_CONSTANTS;
            if (this.parent == null) {
                if (!this.encodingStyle.equals("")) {
                    this.setAttribute(soapConstants.getEnvelopeURI(), "encodingStyle", this.encodingStyle);
                }
            } else if (!this.encodingStyle.equals(this.parent.getEncodingStyle())) {
                this.setAttribute(soapConstants.getEnvelopeURI(), "encodingStyle", this.encodingStyle);
            }
        }
        this.outputImpl(context);
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        if (this.elementRep != null) {
            boolean oldPretty = context.getPretty();
            context.setPretty(false);
            context.writeDOMElement(this.elementRep);
            context.setPretty(oldPretty);
            return;
        }
        if (this.prefix != null && this.prefix.length() > 0) {
            context.registerPrefixForURI(this.prefix, this.namespaceURI);
        }
        if (this.namespaces != null) {
            Iterator i = this.namespaces.iterator();
            while (i.hasNext()) {
                Mapping mapping = (Mapping)i.next();
                context.registerPrefixForURI(mapping.getPrefix(), mapping.getNamespaceURI());
            }
        }
        if (this.objectValue != null) {
            context.serialize(new QName(this.namespaceURI, this.name), this.attributes, this.objectValue, null, false, null);
            return;
        }
        context.startElement(new QName(this.namespaceURI, this.name), this.attributes);
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            Node childNode = (Node)it.next();
            if (childNode instanceof SOAPElementAxisImpl) {
                ((SOAPElementAxisImpl)((Object)childNode)).output(context);
                continue;
            }
            if (!(childNode instanceof TextImpl)) continue;
            context.writeString(childNode.getNodeValue());
        }
        context.endElement();
    }

    public void addMapping(Mapping map) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        this.namespaces.add(map);
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        try {
            this.setParent((SOAPElementAxisImpl)parent);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
    }

    public SOAPElement getParentElement() {
        return this.getParent();
    }

    public void detachNode() {
        this.assertImmutable();
        super.detachNode();
        if (this.parent != null) {
            this.parent.removeChild((Node)((Object)this));
            this.parent = null;
        }
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    public void setAllImmutable(boolean immutable) {
        this.immutable = immutable;
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!(node instanceof SOAPElementAxisImpl)) continue;
            ((SOAPElementAxisImpl)((Object)node)).setAllImmutable(true);
        }
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        SOAPElementAxisImpl child = new SOAPElementAxisImpl(name.getLocalName(), name.getPrefix(), name.getURI());
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        SOAPElementAxisImpl child = new SOAPElementAxisImpl(this.getNamespaceURI(), localName);
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        SOAPElementAxisImpl child = new SOAPElementAxisImpl(this.getNamespaceURI(prefix), localName);
        child.setPrefix(prefix);
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        SOAPElementAxisImpl child = new SOAPElementAxisImpl(uri, localName);
        child.setPrefix(prefix);
        child.addNamespaceDeclaration(prefix, uri);
        this.addChild(child);
        return child;
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        try {
            this.addChild((SOAPElementAxisImpl)element);
            return element;
        }
        catch (ClassCastException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public SOAPElement addTextNode(String value) throws SOAPException {
        Text domText = this.domNode.getOwnerDocument().createTextNode(value);
        TextImpl soapText = new TextImpl(domText);
        this.appendChild((Node)((Object)soapText));
        return this;
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        try {
            this.addAttribute(name.getPrefix(), name.getURI(), name.getLocalName(), value);
        }
        catch (RuntimeException t) {
            throw new SOAPException((Throwable)t);
        }
        return this;
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        try {
            Mapping map = new Mapping(uri, prefix);
            this.addMapping(map);
        }
        catch (RuntimeException t) {
            throw new SOAPException((Throwable)t);
        }
        return this;
    }

    public String getAttributeValue(Name name) {
        return this.attributes.getValue(name.getURI(), name.getLocalName());
    }

    public Iterator getAllAttributes() {
        int num = this.attributes.getLength();
        Vector<NameImpl> attrs = new Vector<NameImpl>(num);
        for (int i = 0; i < num; ++i) {
            String q = this.attributes.getQName(i);
            String prefix = "";
            if (q != null) {
                int idx = q.indexOf(":");
                prefix = idx > 0 ? q.substring(0, idx) : "";
            }
            attrs.add(new NameImpl(this.attributes.getLocalName(i), prefix, this.attributes.getURI(i)));
        }
        return attrs.iterator();
    }

    public Iterator getNamespacePrefixes() {
        Vector<String> prefixes = new Vector<String>();
        for (int i = 0; this.namespaces != null && i < this.namespaces.size(); ++i) {
            prefixes.add(((Mapping)this.namespaces.get(i)).getPrefix());
        }
        return prefixes.iterator();
    }

    public Name getElementName() {
        return new NameImpl(this.getName(), this.getPrefix(), this.getNamespaceURI());
    }

    public boolean removeAttribute(Name name) {
        AttributesImpl attributes = this.makeAttributesEditable();
        boolean removed = false;
        for (int i = 0; i < attributes.getLength() && !removed; ++i) {
            if (!attributes.getURI(i).equals(name.getURI()) || !attributes.getLocalName(i).equals(name.getLocalName())) continue;
            attributes.removeAttribute(i);
            removed = true;
        }
        return removed;
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        this.makeAttributesEditable();
        boolean removed = false;
        for (int i = 0; this.namespaces != null && i < this.namespaces.size() && !removed; ++i) {
            if (!((Mapping)this.namespaces.get(i)).getPrefix().equals(prefix)) continue;
            this.namespaces.remove(i);
            removed = true;
        }
        return removed;
    }

    public Iterator getChildElements() {
        return this.children.iterator();
    }

    public Iterator getChildElements(Name name) {
        ArrayList<Node> list = new ArrayList<Node>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!name.getURI().equals(node.getNamespaceURI()) || !name.getLocalName().equals(node.getLocalName())) continue;
            list.add(node);
        }
        return list.iterator();
    }

    public String getTagName() {
        return this.prefix == null ? this.name : this.prefix + ":" + this.name;
    }

    public void removeAttribute(String name) throws DOMException {
        AttributesImpl impl = (AttributesImpl)this.attributes;
        int index = impl.getIndex(name);
        if (index >= 0) {
            AttributesImpl newAttrs = new AttributesImpl();
            for (int i = 0; i < impl.getLength(); ++i) {
                if (i == index) continue;
                String uri = impl.getURI(i);
                String local = impl.getLocalName(i);
                String qname = impl.getQName(i);
                String type = impl.getType(i);
                String value = impl.getValue(i);
                newAttrs.addAttribute(uri, local, qname, type, value);
            }
            this.attributes = newAttrs;
        }
    }

    public boolean hasAttribute(String name) {
        if (name == null) {
            name = "";
        }
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            if (!name.equals(this.attributes.getQName(i))) continue;
            return true;
        }
        return false;
    }

    public String getAttribute(String name) {
        return this.attributes.getValue(name);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.makeAttributesEditable();
        NameImpl name = new NameImpl(localName, null, namespaceURI);
        this.removeAttribute(name);
    }

    public void setAttribute(String name, String value) throws DOMException {
        if (value == null) {
            throw new IllegalArgumentException("Cannot set null attribute");
        }
        AttributesImpl impl = this.makeAttributesEditable();
        int index = impl.getIndex(name);
        if (index < 0) {
            String uri = "";
            String localname = name;
            String qname = name;
            String type = "CDDATA";
            impl.addAttribute(uri, localname, qname, type, value);
        } else {
            impl.setLocalName(index, value);
        }
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (localName == null) {
            localName = "";
        }
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            if (!namespaceURI.equals(this.attributes.getURI(i)) || !localName.equals(this.attributes.getLocalName(i))) continue;
            return true;
        }
        return false;
    }

    public Attr getAttributeNode(String name) {
        return null;
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        this.makeAttributesEditable();
        NameImpl name = new NameImpl(oldAttr.getLocalName(), oldAttr.getPrefix(), oldAttr.getNamespaceURI());
        this.removeAttribute(name);
        return oldAttr;
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return newAttr;
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        AttributesImpl attributes = this.makeAttributesEditable();
        attributes.addAttribute(newAttr.getNamespaceURI(), newAttr.getLocalName(), newAttr.getLocalName(), "CDATA", newAttr.getValue());
        return null;
    }

    public NodeList getElementsByTagName(String name) {
        NodeListImpl nodelist = new NodeListImpl();
        if (this.children != null) {
            int i;
            for (i = 0; i < this.children.size(); ++i) {
                nodelist.addNode((Node)((Object)((SOAPElementAxisImpl)((Object)this.children.get(i)))));
            }
            for (i = 0; i < this.children.size(); ++i) {
                SOAPElementAxisImpl child = (SOAPElementAxisImpl)((Object)this.children.get(i));
                NodeList grandsons = child.getElementsByTagName(name);
                for (int j = 0; j < this.children.size(); ++j) {
                    nodelist.addNode((Node)((Object)((SOAPElementAxisImpl)((Object)grandsons.item(j)))));
                }
            }
        }
        return nodelist;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            if (!this.attributes.getURI(i).equals(namespaceURI) || !this.attributes.getLocalName(i).equals(localName)) continue;
            return this.attributes.getValue(i);
        }
        return null;
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        AttributesImpl attributes = this.makeAttributesEditable();
        String localName = qualifiedName.substring(qualifiedName.indexOf(":") + 1, qualifiedName.length());
        if (namespaceURI == null) {
            namespaceURI = "intentionalNullURI";
        }
        attributes.addAttribute(namespaceURI, localName, qualifiedName, "CDATA", value);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return null;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getElementsNS((Element)((Object)this), namespaceURI, localName);
    }

    protected NodeList getElementsNS(Element parent, String namespaceURI, String localName) {
        NodeList children = parent.getChildNodes();
        NodeListImpl matches = new NodeListImpl();
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            if (!(c instanceof Element)) continue;
            Element child = (Element)c;
            if (namespaceURI.equals(child.getNamespaceURI()) && localName.equals(child.getLocalName())) {
                matches.addNode(child);
            }
            matches.addNodeList(child.getElementsByTagNameNS(namespaceURI, localName));
        }
        return matches;
    }

    public void setOwnerDocument(MessagePart sp) {
        this.soapPart = sp;
    }

    private void setElementAsModified() {
        SOAPEnvelopeAxisImpl env = this.getSOAPEnvelope();
        if (env != null) {
            env.setModified(true);
        }
    }

    private SOAPEnvelopeAxisImpl getSOAPEnvelope() {
        SOAPEnvelopeAxisImpl env = null;
        for (SOAPElementAxisImpl el = this; env == null && el != null; el = el.getParent()) {
            if (!(el instanceof SOAPEnvelopeAxisImpl)) continue;
            env = (SOAPEnvelopeAxisImpl)el;
        }
        return env;
    }

    public List getChildren() {
        return this.children.getUnmodifieableList();
    }

    class ChildElementList
    implements Serializable {
        private ArrayList children = new ArrayList();

        ChildElementList() {
        }

        public void clear() {
            log.debug((Object)"Clear the child list");
            this.children.clear();
            SOAPElementAxisImpl.this.setElementAsModified();
        }

        public void add(Node child) {
            log.debug((Object)("Adding child: " + this.getDebugStr(child)));
            this.children.add(child);
            SOAPElementAxisImpl.this.setElementAsModified();
        }

        public void add(int pos, Node child) {
            log.debug((Object)("Adding child at position: " + pos + "," + this.getDebugStr(child)));
            this.children.add(pos, child);
            SOAPElementAxisImpl.this.setElementAsModified();
        }

        public void remove(int pos) {
            log.debug((Object)("Remove child at position: " + pos));
            this.children.remove(pos);
            SOAPElementAxisImpl.this.setElementAsModified();
        }

        public List getUnmodifieableList() {
            return Collections.unmodifiableList(this.children);
        }

        public boolean contains(Node child) {
            return this.children.contains(child);
        }

        public boolean isEmpty() {
            return this.children.isEmpty();
        }

        public Node get(int pos) {
            return (NodeImpl)this.children.get(pos);
        }

        public int size() {
            return this.children.size();
        }

        public int indexOf(Node child) {
            return this.children.indexOf(child);
        }

        public Iterator iterator() {
            return this.children.iterator();
        }

        private String getDebugStr(Node child) {
            String nodeStr = child.getNodeName();
            if (child.getNodeType() == 3) {
                nodeStr = nodeStr + " [" + child.getNodeValue() + "]";
            }
            return nodeStr;
        }
    }

    protected static class QNameAttr {
        QName name;
        QName value;

        protected QNameAttr() {
        }
    }
}

