/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.MessagePart;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisHttpSession;
import org.apache.axis.transport.http.AxisServletBase;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.ServletEndpointContextImpl;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AxisServlet
extends AxisServletBase {
    private static Logger log = Logger.getLogger((String)AxisServlet.class.getName());
    private static Logger tlog = Logger.getLogger((String)"org.apache.axis.TIME");
    public static final String INIT_PROPERTY_TRANSPORT_NAME = "transport.name";
    public static final String INIT_PROPERTY_USE_SECURITY = "use-servlet-security";
    public static final String INIT_PROPERTY_ENABLE_LIST = "axis.enableListQuery";
    public static final String INIT_PROPERTY_JWS_CLASS_DIR = "axis.jws.servletClassDir";
    private String transportName;
    private ServletSecurityProvider securityProvider = null;
    private boolean enableList = false;
    private String jwsClassDir = null;

    protected String getJWSClassDir() {
        return this.jwsClassDir;
    }

    public void init() {
        super.init();
        ServletContext context = this.getServletConfig().getServletContext();
        log.debug((Object)"In servlet init");
        this.transportName = this.getOption(context, INIT_PROPERTY_TRANSPORT_NAME, "http");
        if (JavaUtils.isTrueExplicitly(this.getOption(context, INIT_PROPERTY_USE_SECURITY, null))) {
            this.securityProvider = new ServletSecurityProvider();
        }
        this.enableList = JavaUtils.isTrueExplicitly(this.getOption(context, INIT_PROPERTY_ENABLE_LIST, null));
        this.jwsClassDir = this.getOption(context, INIT_PROPERTY_JWS_CLASS_DIR, null);
        if (this.jwsClassDir != null) {
            if (this.getHomeDir() != null) {
                this.jwsClassDir = this.getHomeDir() + this.jwsClassDir;
            }
        } else {
            this.jwsClassDir = this.getDefaultJWSClassDir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)"Enter: doGet()");
        PrintWriter writer = response.getWriter();
        try {
            try {
                boolean hasNoPath;
                String queryString;
                AxisServer engine = this.getEngine();
                ServletContext servletContext = this.getServletConfig().getServletContext();
                String pathInfo = request.getPathInfo();
                String realpath = servletContext.getRealPath(request.getServletPath());
                if (realpath == null) {
                    realpath = request.getServletPath();
                }
                boolean wsdlRequested = false;
                boolean listRequested = false;
                boolean hasParameters = request.getParameterNames().hasMoreElements();
                boolean isJWSPage = request.getRequestURI().endsWith(".jws");
                if (isJWSPage) {
                    pathInfo = request.getServletPath();
                }
                if ((queryString = request.getQueryString()) != null) {
                    if (queryString.equalsIgnoreCase("wsdl")) {
                        wsdlRequested = true;
                    } else if (queryString.equalsIgnoreCase("list")) {
                        listRequested = true;
                    }
                }
                boolean bl = hasNoPath = pathInfo == null || pathInfo.equals("");
                if (!wsdlRequested && !listRequested && hasNoPath) {
                    this.reportAvailableServices(response, writer, request);
                }
                if (realpath != null) {
                    MessageContext msgContext = this.createMessageContext(engine, request, response);
                    String url = request.getRequestURL().toString();
                    msgContext.setProperty("transport.url", url);
                    if (wsdlRequested) {
                        this.processWsdlRequest(msgContext, response, writer);
                    }
                    if (listRequested) {
                        this.processListRequest(response, writer);
                    }
                    if (hasParameters) {
                        this.processMethodRequest(msgContext, request, response, writer);
                    }
                    String serviceName = pathInfo.startsWith("/") ? pathInfo.substring(1) : pathInfo;
                    SOAPService s = engine.getService(serviceName);
                    if (s == null) {
                        if (isJWSPage) {
                            this.reportCantGetJWSService(request, response, writer);
                        }
                        this.reportCantGetAxisService(request, response, writer);
                    }
                    this.reportServiceInfo(response, writer, s, serviceName);
                }
                response.setContentType("text/html");
                writer.println("<html><h1>Axis HTTP Servlet</h1>");
                writer.println(Messages.getMessage("reachedServlet00"));
                writer.println("<p>" + Messages.getMessage("transportName00", "<b>" + this.transportName + "</b>"));
                writer.println("</html>");
            }
            catch (AxisFault fault) {
                this.reportTrouble(fault, response, writer);
                Object var19_21 = null;
                AxisEngine.setCurrentMessageContext(null);
                writer.close();
                log.debug((Object)"Exit: doGet()");
                return;
            }
            catch (Exception e) {
                this.reportTrouble(e, response, writer);
                Object var19_22 = null;
                AxisEngine.setCurrentMessageContext(null);
                writer.close();
                log.debug((Object)"Exit: doGet()");
                return;
            }
            Object var19_20 = null;
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            AxisEngine.setCurrentMessageContext(null);
            writer.close();
            log.debug((Object)"Exit: doGet()");
            throw throwable;
        }
        AxisEngine.setCurrentMessageContext(null);
        writer.close();
        log.debug((Object)"Exit: doGet()");
    }

    protected void reportTrouble(Exception exception, HttpServletResponse response, PrintWriter writer) {
        response.setContentType("text/html");
        response.setStatus(500);
        this.setupHTMLResponseHeader(response, writer);
        writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        writer.println("<p>" + Messages.getMessage("somethingWrong00") + "</p>");
        if (exception instanceof AxisFault) {
            AxisFault fault = (AxisFault)exception;
            this.processAxisFault(fault);
            this.writeFault(writer, fault);
        } else {
            this.logException(exception);
            writer.println("<pre>" + exception + "<br>");
            if (this.isDevelopment()) {
                writer.println(JavaUtils.stackToString(exception));
            }
            writer.println("</pre>");
        }
    }

    protected void setupHTMLResponseHeader(HttpServletResponse response, PrintWriter writer) {
    }

    protected void processAxisFault(AxisFault fault) {
        Element runtimeException = fault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        if (runtimeException != null) {
            fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        }
        if (!this.isDevelopment()) {
            fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE);
        }
        log.info((Object)(fault.detail != null ? fault.detail : fault));
    }

    protected void logException(Exception e) {
        log.info((Object)Messages.getMessage("exception00"), (Throwable)e);
    }

    private void writeFault(PrintWriter writer, AxisFault axisFault) {
        String localizedMessage = XMLUtils.xmlEncodeString(axisFault.getLocalizedMessage());
        writer.println("<pre>Fault - " + localizedMessage + "<br>");
        writer.println(axisFault.dumpToString());
        writer.println("</pre>");
    }

    protected void processMethodRequest(MessageContext msgContext, HttpServletRequest request, HttpServletResponse response, PrintWriter writer) throws AxisFault {
        Enumeration enumeration = request.getParameterNames();
        String method = null;
        String args = "";
        while (enumeration.hasMoreElements()) {
            String param = (String)enumeration.nextElement();
            if (param.equalsIgnoreCase("method")) {
                method = request.getParameter(param);
                continue;
            }
            args = args + "<" + param + ">" + request.getParameter(param) + "</" + param + ">";
        }
        if (method == null) {
            response.setContentType("text/html");
            response.setStatus(400);
            writer.println("<h2>" + Messages.getMessage("error00") + ":  " + Messages.getMessage("invokeGet00") + "</h2>");
            writer.println("<p>" + Messages.getMessage("noMethod01") + "</p>");
        } else {
            this.invokeEndpointFromGet(msgContext, response, writer, method, args);
        }
    }

    protected void processWsdlRequest(MessageContext msgContext, HttpServletResponse response, PrintWriter writer) throws AxisFault {
        AxisServer engine = this.getEngine();
        try {
            ((BasicHandler)engine).generateWSDL(msgContext);
            Document doc = (Document)msgContext.getProperty("WSDL");
            if (doc != null) {
                response.setContentType("text/xml");
                XMLUtils.DocumentToWriter(doc, writer);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"processWsdlRequest: failed to create WSDL");
                }
                this.reportNoWSDL(response, writer, "noWSDL02", null);
            }
        }
        catch (AxisFault axisFault) {
            if (axisFault.getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                this.processAxisFault(axisFault);
                response.setStatus(404);
                this.reportNoWSDL(response, writer, "noWSDL01", axisFault);
            }
            throw axisFault;
        }
    }

    protected void invokeEndpointFromGet(MessageContext msgContext, HttpServletResponse response, PrintWriter writer, String method, String args) throws AxisFault {
        String body = "<" + method + ">" + args + "</" + method + ">";
        String msgtxt = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>" + body + "</SOAP-ENV:Body>" + "</SOAP-ENV:Envelope>";
        Message responseMsg = null;
        try {
            ByteArrayInputStream istream = new ByteArrayInputStream(msgtxt.getBytes("ISO-8859-1"));
            AxisServer engine = this.getEngine();
            Message msg = new Message((Object)istream, false);
            msgContext.setRequestMessage(msg);
            ((BasicHandler)engine).invoke(msgContext);
            responseMsg = msgContext.getResponseMessage();
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            if (responseMsg == null) {
                throw new Exception(Messages.getMessage("noResponse01"));
            }
        }
        catch (AxisFault fault) {
            this.processAxisFault(fault);
            this.configureResponseFromAxisFault(response, fault);
            if (responseMsg == null) {
                responseMsg = new Message(fault);
                msgContext.setResponseMessage(responseMsg);
            }
        }
        catch (Exception e) {
            response.setStatus(500);
            responseMsg = this.convertExceptionToAxisFault(e, responseMsg);
        }
        response.setContentType("text/xml");
        writer.println(responseMsg.getSOAPPartAsString());
    }

    protected void reportServiceInfo(HttpServletResponse response, PrintWriter writer, SOAPService service, String serviceName) {
        response.setContentType("text/html");
        writer.println("<h1>" + service.getName() + "</h1>");
        writer.println("<p>" + Messages.getMessage("axisService00") + "</p>");
        writer.println("<i>" + Messages.getMessage("perhaps00") + "</i>");
    }

    protected void processListRequest(HttpServletResponse response, PrintWriter writer) throws AxisFault {
        AxisServer engine = this.getEngine();
        if (this.enableList) {
            Document doc = Admin.listConfig(engine);
            if (doc != null) {
                response.setContentType("text/xml");
                XMLUtils.DocumentToWriter(doc, writer);
            } else {
                response.setStatus(404);
                response.setContentType("text/html");
                writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                writer.println("<p>" + Messages.getMessage("noDeploy00") + "</p>");
            }
        } else {
            response.setStatus(403);
            response.setContentType("text/html");
            writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
            writer.println("<p><i>?list</i> " + Messages.getMessage("disabled00") + "</p>");
        }
    }

    protected void reportNoWSDL(HttpServletResponse res, PrintWriter writer, String moreDetailCode, AxisFault axisFault) {
        res.setStatus(404);
        res.setContentType("text/html");
        writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        writer.println("<p>" + Messages.getMessage("noWSDL00") + "</p>");
        if (moreDetailCode != null) {
            writer.println("<p>" + Messages.getMessage(moreDetailCode) + "</p>");
        }
        if (axisFault != null && this.isDevelopment()) {
            this.writeFault(writer, axisFault);
        }
    }

    protected void reportAvailableServices(HttpServletResponse response, PrintWriter writer, HttpServletRequest request) throws ConfigurationException, AxisFault {
        Iterator i;
        AxisServer engine = this.getEngine();
        response.setContentType("text/html");
        writer.println("<h2>And now... Some Services</h2>");
        try {
            i = engine.getConfig().getDeployedServices();
        }
        catch (ConfigurationException configException) {
            if (configException.getContainedException() instanceof AxisFault) {
                throw (AxisFault)configException.getContainedException();
            }
            throw configException;
        }
        String baseURL = this.getWebappBase(request) + "/services/";
        writer.println("<ul>");
        while (i.hasNext()) {
            ServiceDesc sd = (ServiceDesc)i.next();
            StringBuffer sb = new StringBuffer();
            sb.append("<li>");
            String name = sd.getName();
            sb.append(name);
            sb.append(" <a href=\"");
            sb.append(baseURL);
            sb.append(name);
            sb.append("?wsdl\"><i>(wsdl)</i></a></li>");
            writer.println(sb.toString());
            ArrayList operations = sd.getOperations();
            if (operations.isEmpty()) continue;
            writer.println("<ul>");
            Iterator it = operations.iterator();
            while (it.hasNext()) {
                OperationDesc desc = (OperationDesc)it.next();
                writer.println("<li>" + desc.getName());
            }
            writer.println("</ul>");
        }
        writer.println("</ul>");
    }

    protected void reportCantGetAxisService(HttpServletRequest request, HttpServletResponse response, PrintWriter writer) {
        response.setStatus(404);
        response.setContentType("text/html");
        writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        writer.println("<p>" + Messages.getMessage("noService06") + "</p>");
    }

    protected void reportCantGetJWSService(HttpServletRequest request, HttpServletResponse response, PrintWriter writer) {
        String realpath = this.getServletConfig().getServletContext().getRealPath(request.getServletPath());
        boolean foundJWSFile = new File(realpath).exists() && realpath.endsWith(".jws");
        response.setContentType("text/html");
        if (foundJWSFile) {
            response.setStatus(200);
            writer.println(Messages.getMessage("foundJWS00") + "<p>");
            String url = request.getRequestURI();
            String urltext = Messages.getMessage("foundJWS01");
            writer.println("<a href='" + url + "?wsdl'>" + urltext + "</a>");
        } else {
            response.setStatus(404);
            writer.println(Messages.getMessage("noService06"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        String soapAction = null;
        MessageContext msgContext = null;
        log.debug((Object)"Enter: doPost()");
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        Message responseMsg = null;
        String contentType = null;
        try {
            SOAPService service;
            AxisServer engine = this.getEngine();
            if (engine == null) {
                ServletException se = new ServletException(Messages.getMessage("noEngine00"));
                log.debug((Object)"No Engine!", (Throwable)se);
                throw se;
            }
            res.setBufferSize(8192);
            msgContext = this.createMessageContext(engine, req, res);
            String serviceName = this.getServiceName(req);
            log.debug((Object)("serviceName: " + serviceName));
            SOAPService sOAPService = service = serviceName != null ? engine.getService(serviceName) : null;
            if (service != null) {
                msgContext.setTargetService(serviceName);
            }
            if (this.securityProvider != null) {
                log.debug((Object)("securityProvider:" + this.securityProvider));
                msgContext.setProperty("securityProvider", this.securityProvider);
            }
            ServletInputStream inputStream = req.getInputStream();
            Message requestMsg = new Message(inputStream, false, req.getHeader("Content-Type"), req.getHeader("Content-Location"));
            if (log.isDebugEnabled()) {
                log.debug((Object)"XML request received");
                log.debug((Object)"----------------------------------------------");
                MessagePart msgPart = (MessagePart)requestMsg.getSOAPPart();
                String xmlMessage = msgPart.getAsString();
                log.debug((Object)"----------------------------------------------");
                log.debug((Object)xmlMessage);
                log.debug((Object)"----------------------------------------------");
            }
            msgContext.setRequestMessage(requestMsg);
            String url = req.getRequestURL().toString();
            msgContext.setProperty("transport.url", url);
            try {
                OperationDesc opDesc;
                soapAction = this.getSoapAction(req);
                if (soapAction != null) {
                    msgContext.setUseSOAPAction(true);
                    msgContext.setSOAPActionURI(soapAction);
                }
                msgContext.setSession(new AxisHttpSession(req));
                if (tlog.isDebugEnabled()) {
                    t1 = System.currentTimeMillis();
                }
                log.debug((Object)"Invoking Axis Engine.");
                ((BasicHandler)engine).invoke(msgContext);
                log.debug((Object)"Return from Axis Engine.");
                if (tlog.isDebugEnabled()) {
                    t2 = System.currentTimeMillis();
                }
                boolean isOneWay = (opDesc = msgContext.getOperation()) != null && opDesc.isOneWay();
                responseMsg = msgContext.getResponseMessage();
                if (responseMsg == null && !isOneWay) {
                    throw new Exception(Messages.getMessage("noResponse01"));
                }
            }
            catch (AxisFault fault) {
                this.processAxisFault(fault);
                this.configureResponseFromAxisFault(res, fault);
                responseMsg = msgContext.getResponseMessage();
                if (responseMsg == null) {
                    responseMsg = new Message(fault);
                    msgContext.setResponseMessage(responseMsg);
                }
            }
            catch (Exception e) {
                responseMsg = msgContext.getResponseMessage();
                res.setStatus(500);
                responseMsg = this.convertExceptionToAxisFault(e, responseMsg);
            }
        }
        catch (AxisFault fault) {
            this.processAxisFault(fault);
            this.configureResponseFromAxisFault(res, fault);
            responseMsg = msgContext.getResponseMessage();
            if (responseMsg == null) {
                responseMsg = new Message(fault);
                msgContext.setResponseMessage(responseMsg);
            }
        }
        finally {
            AxisEngine.setCurrentMessageContext(null);
        }
        if (tlog.isDebugEnabled()) {
            t3 = System.currentTimeMillis();
        }
        if (responseMsg != null) {
            contentType = responseMsg.getContentType(msgContext.getSOAPConstants());
            this.sendResponse(this.getProtocolVersion(req), contentType, res, responseMsg);
        }
        log.debug((Object)"Response sent.");
        log.debug((Object)"Exit: doPost()");
        if (tlog.isDebugEnabled()) {
            t4 = System.currentTimeMillis();
            tlog.debug((Object)("axisServlet.doPost: " + soapAction + " pre=" + (t1 - t0) + " invoke=" + (t2 - t1) + " post=" + (t3 - t2) + " send=" + (t4 - t3) + " " + msgContext.getTargetService() + "." + (msgContext.getOperation() == null ? "" : msgContext.getOperation().getName())));
        }
    }

    protected String getServiceName(HttpServletRequest request) {
        StringTokenizer st;
        String path = request.getPathInfo();
        if (path != null && (st = new StringTokenizer(path, "/")).hasMoreTokens()) {
            return st.nextToken();
        }
        return null;
    }

    private void configureResponseFromAxisFault(HttpServletResponse response, AxisFault fault) {
        int status = this.getHttpServletResponseStatus(fault);
        if (status == 401) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"AXIS\"");
        }
        response.setStatus(status);
    }

    private Message convertExceptionToAxisFault(Exception exception, Message responseMsg) {
        this.logException(exception);
        if (responseMsg == null) {
            AxisFault fault = AxisFault.makeFault(exception);
            this.processAxisFault(fault);
            responseMsg = new Message(fault);
        }
        return responseMsg;
    }

    protected int getHttpServletResponseStatus(AxisFault af) {
        return af.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    private void sendResponse(String clientVersion, String contentType, HttpServletResponse res, Message responseMsg) throws AxisFault, IOException {
        if (responseMsg == null) {
            res.setStatus(204);
            log.debug((Object)"NO AXIS MESSAGE TO RETURN!");
        } else {
            log.debug((Object)("Returned Content-Type:" + contentType));
            try {
                res.setContentType(contentType);
                responseMsg.writeTo((OutputStream)res.getOutputStream());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"XML response sent");
                    log.debug((Object)"----------------------------------------------");
                    MessagePart msgPart = (MessagePart)responseMsg.getSOAPPart();
                    String xmlMessage = msgPart.getAsString();
                    log.debug((Object)"----------------------------------------------");
                    log.debug((Object)xmlMessage);
                    log.debug((Object)"----------------------------------------------");
                }
            }
            catch (SOAPException e) {
                this.logException((Exception)((Object)e));
            }
        }
        if (!res.isCommitted()) {
            res.flushBuffer();
        }
    }

    protected MessageContext createMessageContext(AxisEngine engine, HttpServletRequest req, HttpServletResponse res) {
        MessageContext msgContext = new MessageContext(engine);
        AxisEngine.setCurrentMessageContext(msgContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("MessageContext:" + msgContext));
            log.debug((Object)("HEADER_CONTENT_TYPE:" + req.getHeader("Content-Type")));
            log.debug((Object)("HEADER_CONTENT_LOCATION:" + req.getHeader("Content-Location")));
            log.debug((Object)("Constants.MC_HOME_DIR:" + String.valueOf(this.getHomeDir())));
            log.debug((Object)("Constants.MC_RELATIVE_PATH:" + req.getServletPath()));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETLOCATION:" + String.valueOf(this.getWebInfPath())));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + req.getPathInfo()));
            log.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + req.getHeader("Authorization")));
            log.debug((Object)("Constants.MC_REMOTE_ADDR:" + req.getRemoteAddr()));
            log.debug((Object)("configPath:" + String.valueOf(this.getWebInfPath())));
        }
        msgContext.setTransportName(this.transportName);
        msgContext.setProperty("jws.classDir", this.jwsClassDir);
        msgContext.setProperty("home.dir", this.getHomeDir());
        msgContext.setProperty("path", req.getServletPath());
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, req);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, res);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, this.getWebInfPath());
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, req.getPathInfo());
        msgContext.setProperty("Authorization", req.getHeader("Authorization"));
        msgContext.setProperty("remoteaddr", req.getRemoteAddr());
        ServletEndpointContextImpl sec = new ServletEndpointContextImpl();
        msgContext.setProperty("servletEndpointContext", sec);
        String realpath = this.getServletConfig().getServletContext().getRealPath(req.getServletPath());
        if (realpath != null) {
            msgContext.setProperty("realpath", realpath);
        }
        msgContext.setProperty("configPath", this.getWebInfPath());
        return msgContext;
    }

    private String getSoapAction(HttpServletRequest req) throws AxisFault {
        String soapAction = req.getHeader("SOAPAction");
        log.debug((Object)("HEADER_SOAP_ACTION:" + soapAction));
        if (soapAction == null) {
            AxisFault af = new AxisFault("Client.NoSOAPAction", Messages.getMessage("noHeader00", "SOAPAction"), null, null);
            log.error((Object)Messages.getMessage("genFault00"), (Throwable)af);
            throw af;
        }
        if (soapAction.length() == 0) {
            soapAction = req.getContextPath();
        }
        return soapAction;
    }

    protected String getDefaultJWSClassDir() {
        return this.getWebInfPath() == null ? null : this.getWebInfPath() + File.separator + "jwsClasses";
    }

    protected String getProtocolVersion(HttpServletRequest req) {
        String ver;
        int sindex;
        String ret = HTTPConstants.HEADER_PROTOCOL_V10;
        String prot = req.getProtocol();
        if (prot != null && -1 != (sindex = prot.indexOf(47)) && HTTPConstants.HEADER_PROTOCOL_V11.equals((ver = prot.substring(sindex + 1)).trim())) {
            ret = HTTPConstants.HEADER_PROTOCOL_V11;
        }
        return ret;
    }
}

