/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.jms.JMSEndpoint;
import org.apache.axis.transport.jms.SimpleJMSListener;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;

public class SimpleJMSWorker
implements Runnable {
    protected static Logger log = Logger.getLogger((Class)SimpleJMSWorker.class);
    SimpleJMSListener listener;
    BytesMessage message;

    public SimpleJMSWorker(SimpleJMSListener listener, BytesMessage message) {
        this.listener = listener;
        this.message = message;
    }

    public void run() {
        ByteArrayInputStream in = null;
        try {
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int bytesRead = this.message.readBytes(buffer);
            while (bytesRead != -1) {
                out.write(buffer, 0, bytesRead);
                bytesRead = this.message.readBytes(buffer);
            }
            in = new ByteArrayInputStream(out.toByteArray());
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            e.printStackTrace();
            return;
        }
        SimpleJMSWorker simpleJMSWorker = this;
        AxisServer server = simpleJMSWorker.listener.getAxisServer();
        Message msg = new Message(in);
        MessageContext msgContext = new MessageContext(server);
        msgContext.setRequestMessage(msg);
        try {
            server.invoke(msgContext);
            msg = msgContext.getResponseMessage();
        }
        catch (AxisFault af) {
            msg = new Message(af);
            msg.setMessageContext(msgContext);
        }
        catch (Exception e) {
            msg = new Message(new AxisFault(e.toString()));
            msg.setMessageContext(msgContext);
        }
        try {
            Destination destination = this.message.getJMSReplyTo();
            if (destination == null) {
                return;
            }
            JMSEndpoint replyTo = this.listener.getConnector().createEndpoint(destination);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            msg.writeTo(out);
            replyTo.send(out.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (msgContext.getProperty("quit.requested") != null) {
            try {
                this.listener.shutdown();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

