/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.VisitorException;
import org.omg.CORBA.TCKind;

public class AndOperator
extends AbstractTCLNode {
    static final String NAME = "AndOperator";

    public AndOperator(Token token) {
        super(token);
        this.setKind(TCKind.tk_boolean);
    }

    public String toString() {
        return "and";
    }

    public EvaluationResult evaluate(EvaluationContext evaluationContext) throws EvaluationException {
        boolean bl = this.left().evaluate(evaluationContext).getBool();
        if (!bl) {
            return EvaluationResult.BOOL_FALSE;
        }
        boolean bl2 = this.right().evaluate(evaluationContext).getBool();
        return bl2 ? EvaluationResult.BOOL_TRUE : EvaluationResult.BOOL_FALSE;
    }

    public boolean isStatic() {
        return this.left().isStatic() && this.right().isStatic();
    }

    public void acceptInOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        this.left().acceptInOrder(abstractTCLVisitor);
        abstractTCLVisitor.visitAnd(this);
        this.right().acceptInOrder(abstractTCLVisitor);
    }

    public void acceptPreOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        abstractTCLVisitor.visitAnd(this);
        this.left().acceptPreOrder(abstractTCLVisitor);
        this.right().acceptPreOrder(abstractTCLVisitor);
    }

    public void acceptPostOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        this.left().acceptPostOrder(abstractTCLVisitor);
        this.right().acceptPostOrder(abstractTCLVisitor);
        abstractTCLVisitor.visitAnd(this);
    }

    public String getName() {
        return NAME;
    }
}

