/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.BoundedDeadlineEventQueue;
import org.jacorb.notification.queue.BoundedFifoEventQueue;
import org.jacorb.notification.queue.BoundedPriorityEventQueue;
import org.jacorb.notification.queue.EventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CosNotification.UnsupportedQoS;

public class EventQueueFactory
implements Configurable {
    private static final short UNKNOWN_POLICY = Short.MIN_VALUE;
    private static final Map mapOrderPolicyNameToValue = new HashMap();
    private static final Map mapDiscardPolicyNameToValue = new HashMap();
    private static final String[] mapOrderPolicyValueToName;
    private static final String[] mapDiscardPolicyValueToName;
    private String orderPolicy_;
    private String discardPolicy_;

    public void configure(Configuration configuration) {
        this.orderPolicy_ = configuration.getAttribute("jacorb.notification.order_policy", "PriorityOrder");
        this.discardPolicy_ = configuration.getAttribute("jacorb.notification.discard_policy", "PriorityOrder");
    }

    public EventQueue newEventQueue(QoSPropertySet qoSPropertySet) throws UnsupportedQoS {
        AbstractBoundedEventQueue abstractBoundedEventQueue;
        short s = EventQueueFactory.orderPolicyNameToValue(this.orderPolicy_);
        short s2 = EventQueueFactory.discardPolicyNameToValue(this.discardPolicy_);
        int n = qoSPropertySet.get("MaxEventsPerConsumer").extract_long();
        if (qoSPropertySet.containsKey("OrderPolicy")) {
            s = qoSPropertySet.get("OrderPolicy").extract_short();
        }
        if (qoSPropertySet.containsKey("DiscardPolicy")) {
            s2 = qoSPropertySet.get("DiscardPolicy").extract_short();
        }
        switch (s) {
            case 0: 
            case 1: {
                abstractBoundedEventQueue = new BoundedFifoEventQueue(n);
                break;
            }
            case 2: {
                abstractBoundedEventQueue = new BoundedPriorityEventQueue(n);
                break;
            }
            case 3: {
                abstractBoundedEventQueue = new BoundedDeadlineEventQueue(n);
                break;
            }
            default: {
                throw new IllegalArgumentException("Orderpolicy: " + this.orderPolicy_ + " OrderPolicyValue: " + s + " unknown");
            }
        }
        switch (s2) {
            case 0: 
            case 1: {
                abstractBoundedEventQueue.setOverflowStrategy(EventQueueOverflowStrategy.FIFO);
                break;
            }
            case 4: {
                abstractBoundedEventQueue.setOverflowStrategy(EventQueueOverflowStrategy.LIFO);
                break;
            }
            case 2: {
                abstractBoundedEventQueue.setOverflowStrategy(EventQueueOverflowStrategy.LEAST_PRIORITY);
                break;
            }
            case 3: {
                abstractBoundedEventQueue.setOverflowStrategy(EventQueueOverflowStrategy.EARLIEST_TIMEOUT);
                break;
            }
            default: {
                throw new IllegalArgumentException("Discardpolicy: " + this.discardPolicy_ + "DiscardPolicyValue: " + s2 + " unknown");
            }
        }
        return abstractBoundedEventQueue;
    }

    public static short orderPolicyNameToValue(String string) {
        if (mapOrderPolicyNameToValue.containsKey(string)) {
            return (Short)mapOrderPolicyNameToValue.get(string);
        }
        return Short.MIN_VALUE;
    }

    public static short discardPolicyNameToValue(String string) {
        if (mapDiscardPolicyNameToValue.containsKey(string)) {
            return (Short)mapDiscardPolicyNameToValue.get(string);
        }
        return Short.MIN_VALUE;
    }

    static {
        mapOrderPolicyNameToValue.put("AnyOrder", new Short(0));
        mapOrderPolicyNameToValue.put("FifoOrder", new Short(1));
        mapOrderPolicyNameToValue.put("PriorityOrder", new Short(2));
        mapOrderPolicyNameToValue.put("DeadlineOrder", new Short(3));
        mapOrderPolicyValueToName = new String[]{"AnyOrder", "FifoOrder", "PriorityOrder", "DeadlineOrder"};
        mapDiscardPolicyNameToValue.put("AnyOrder", new Short(0));
        mapDiscardPolicyNameToValue.put("FifoOrder", new Short(1));
        mapDiscardPolicyNameToValue.put("LifoOrder", new Short(4));
        mapDiscardPolicyNameToValue.put("PriorityOrder", new Short(2));
        mapDiscardPolicyNameToValue.put("DeadlineOrder", new Short(3));
        mapDiscardPolicyValueToName = new String[]{"AnyOrder", "FifoOrder", "PriorityOrder", "DeadlineOrder", "LifoOrder"};
    }
}

