/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.factory.SSLServerSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirServerReplyListener;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.ServerRequestListener;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPListener;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.ETF.Connection;
import org.omg.ETF.Factories;
import org.omg.ETF.Listener;
import org.omg.ETF.Profile;
import org.omg.ETF._HandleLocalBase;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class BasicAdapter
extends _HandleLocalBase
implements Configurable {
    public SSLServerSocketFactory ssl_socket_factory = null;
    private ServerSocketFactory socket_factory = null;
    private ORB orb;
    private POA rootPOA;
    private List listeners = new ArrayList();
    private MessageReceptorPool receptor_pool = null;
    private ServerRequestListener request_listener = null;
    private ReplyListener reply_listener = null;
    private TransportManager transport_manager = null;
    private GIOPConnectionManager giop_connection_manager = null;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    static /* synthetic */ Class class$org$jacorb$orb$ORB;

    BasicAdapter(ORB oRB, POA pOA, TransportManager transportManager, GIOPConnectionManager gIOPConnectionManager) {
        this.orb = oRB;
        this.rootPOA = pOA;
        this.transport_manager = transportManager;
        this.giop_connection_manager = gIOPConnectionManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Object object;
        Serializable serializable;
        Object object2;
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb.basic");
        this.socket_factory = this.transport_manager.getSocketFactoryManager().getServerSocketFactory();
        if (this.configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on") && this.ssl_socket_factory == null) {
            object2 = this.configuration.getAttribute("jacorb.ssl.server_socket_factory", "");
            if (((String)object2).length() == 0) {
                throw new INITIALIZE("SSL support is on, but the property \"jacorb.ssl.server_socket_factory\" is not set!");
            }
            try {
                serializable = ObjectUtil.classForName((String)object2);
                object = ((Class)serializable).getConstructor(class$org$jacorb$orb$ORB == null ? (class$org$jacorb$orb$ORB = BasicAdapter.class$("org.jacorb.orb.ORB")) : class$org$jacorb$orb$ORB);
                this.ssl_socket_factory = (SSLServerSocketFactory)((Constructor)object).newInstance(this.orb);
                ((Configurable)this.ssl_socket_factory).configure((Configuration)this.configuration);
            }
            catch (Exception exception) {
                this.logger.warn("Exception", (Throwable)exception);
                throw new INITIALIZE("SSL support is on, but the ssl server socket factory can't be instanciated (see trace)!");
            }
        }
        this.receptor_pool = MessageReceptorPool.getInstance();
        this.request_listener = new ServerRequestListener(this.orb, this.rootPOA);
        this.request_listener.configure((Configuration)this.configuration);
        this.reply_listener = new NoBiDirServerReplyListener();
        object2 = this.getListenerFactories().iterator();
        while (object2.hasNext()) {
            serializable = (Factories)object2.next();
            object = serializable.create_listener(null, 0, (short)0);
            object.set_handle(this);
            this.listeners.add(object);
        }
        object2 = this.listeners.iterator();
        while (object2.hasNext()) {
            ((Listener)object2.next()).listen();
        }
    }

    public SSLServerSocketFactory getSSLSocketFactory() {
        return this.ssl_socket_factory;
    }

    private List getListenerFactories() throws ConfigurationException {
        ArrayList<Factories> arrayList = new ArrayList<Factories>();
        List list = this.configuration.getAttributeList("jacorb.transport.server.listeners");
        if (list.isEmpty()) {
            arrayList.addAll(this.transport_manager.getFactoriesList());
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = -1;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException("could not parse profile tag for listener: " + string + " (should have been a number)");
                }
                Factories factories = this.transport_manager.getFactories(n);
                if (factories == null) {
                    throw new RuntimeException("could not find Factories for profile tag: " + n);
                }
                arrayList.add(factories);
            }
        }
        return arrayList;
    }

    public RequestListener getRequestListener() {
        return this.request_listener;
    }

    public List getEndpointProfiles() {
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Listener listener = (Listener)iterator.next();
            arrayList.add(listener.endpoint());
        }
        return arrayList;
    }

    private IIOPListener getIIOPListener() {
        if (this.listeners.size() == 1) {
            Listener listener = (Listener)this.listeners.get(0);
            if (listener instanceof IIOPListener) {
                return (IIOPListener)listener;
            }
            return null;
        }
        return null;
    }

    public int getPort() {
        IIOPListener iIOPListener = this.getIIOPListener();
        if (iIOPListener != null) {
            IIOPProfile iIOPProfile = (IIOPProfile)iIOPListener.endpoint();
            return iIOPProfile.getAddress().getPort();
        }
        throw new RuntimeException("Cannot find server port for non-IIOP transport");
    }

    public int getSSLPort() {
        IIOPListener iIOPListener = this.getIIOPListener();
        if (iIOPListener != null) {
            IIOPProfile iIOPProfile = (IIOPProfile)iIOPListener.endpoint();
            return iIOPProfile.getSSLPort();
        }
        throw new RuntimeException("Non-IIOP transport does not have an SSL port");
    }

    public boolean hasSSLListener() {
        return this.getSSLPort() != -1;
    }

    public String getAddress() {
        IIOPListener iIOPListener = this.getIIOPListener();
        if (iIOPListener != null) {
            IIOPProfile iIOPProfile = (IIOPProfile)iIOPListener.endpoint();
            String string = this.configuration.getAttribute("jacorb.dns.enable", "off");
            if (string.equals("on")) {
                return iIOPProfile.getAddress().getHostname();
            }
            return iIOPProfile.getAddress().getIP();
        }
        throw new RuntimeException("Cannot find server address for non-IIOP transport");
    }

    public synchronized void deliverRequest(ServerRequest serverRequest, POA pOA) {
        org.jacorb.poa.POA pOA2 = (org.jacorb.poa.POA)pOA;
        String[] stringArray = serverRequest.remainingPOAName();
        try {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringArray[i].equals("")) {
                    serverRequest.setRemainingPOAName(null);
                    break;
                }
                try {
                    pOA2 = pOA2._getChildPOA(stringArray[i]);
                    continue;
                }
                catch (ParentIsHolding parentIsHolding) {
                    String[] stringArray2 = new String[stringArray.length - i];
                    for (int j = 0; j < i; ++j) {
                        stringArray2[j] = stringArray[j + i];
                    }
                    serverRequest.setRemainingPOAName(stringArray2);
                    break;
                }
            }
            if (pOA2 == null) {
                throw new INTERNAL("Request POA null!");
            }
            pOA2._invoke(serverRequest);
        }
        catch (WrongAdapter wrongAdapter) {
            serverRequest.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
            serverRequest.reply();
        }
        catch (SystemException systemException) {
            serverRequest.setSystemException(systemException);
            serverRequest.reply();
        }
        catch (Throwable throwable) {
            serverRequest.setSystemException(new UNKNOWN(throwable.toString()));
            serverRequest.reply();
            throwable.printStackTrace();
        }
    }

    public void return_result(ServerRequest serverRequest) {
        serverRequest.reply();
    }

    public void stopListeners() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((Listener)iterator.next()).destroy();
        }
    }

    public boolean add_input(Connection connection) {
        ServerGIOPConnection serverGIOPConnection = this.giop_connection_manager.createServerGIOPConnection(connection.get_server_profile(), connection, this.request_listener, this.reply_listener);
        this.receptor_pool.connectionCreated(serverGIOPConnection);
        return true;
    }

    public void closed_by_peer(Connection connection) {
        throw new NO_IMPLEMENT();
    }

    public void signal_data_available(Connection connection) {
        throw new NO_IMPLEMENT();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

