/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ebxml.registry.util;

import com.sun.ebxml.registry.RegistryException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.ParseException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.oasis.ebxml.registry.bindings.rim.ExternalLink;
import org.oasis.ebxml.registry.bindings.rim.ServiceBinding;
import org.oasis.ebxml.registry.bindings.rs.RegistryError;
import org.oasis.ebxml.registry.bindings.rs.RegistryErrorList;
import org.oasis.ebxml.registry.bindings.rs.RegistryResponse;
import org.oasis.ebxml.registry.bindings.rs.types.StatusType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Utility {
    private static Utility instance = null;
    private String ebxmlrrHome = null;
    static /* synthetic */ Class class$com$sun$ebxml$registry$util$Utility;

    protected Utility() {
    }

    public StringBuffer getStringBufferFromInputStream(InputStream is) throws IOException {
        int buflen = 1024;
        char[] chars = new char[buflen + 1];
        StringBuffer strBuf = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int charsRead = 0;
        while ((charsRead = br.read(chars, 0, buflen)) != -1) {
            strBuf.append(chars, 0, charsRead);
        }
        return strBuf;
    }

    public String getXMLDeclaration(byte[] bytes) {
        String str = new String(bytes);
        return this.removeXMLDeclaration(new StringBuffer(str));
    }

    public byte[] removeXMLDeclaration(byte[] bytes) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int declEndIndex = 0;
        if (bytes[0] == 60) {
            boolean hasDecl = false;
            for (int i = 1; i < bytes.length; ++i) {
                if (bytes[1] == 32) {
                    ++declEndIndex;
                } else if (bytes[i] == 63) {
                    hasDecl = true;
                }
                if (!hasDecl) continue;
                if (bytes[i] != 62) {
                    ++declEndIndex;
                    continue;
                }
                ++declEndIndex;
                break;
            }
        }
        for (int i = declEndIndex; i < bytes.length; ++i) {
            ++declEndIndex;
            if (bytes[i] != 32) break;
        }
        bos.write(bytes, declEndIndex, bytes.length - declEndIndex);
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    public String removeXMLDeclaration(StringBuffer str) {
        String decl = "";
        int len = str.length();
        int startIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) != '<') continue;
            decl = decl + "<";
            startIndex = i++;
            while (str.charAt(i) == ' ') {
                decl = decl + " ";
                ++i;
            }
            if (str.charAt(i) == '?') {
                while (str.charAt(i) != '>') {
                    decl = decl + str.charAt(i);
                    ++i;
                }
                decl = decl + ">";
                endIndex = i;
                break;
            }
            startIndex = -1;
            break;
        }
        if (startIndex != -1) {
            str.delete(startIndex, endIndex + 1);
        }
        return decl;
    }

    public static String getMimeBoundary() {
        Session session = null;
        String s = null;
        InternetAddress internetaddress = InternetAddress.getLocalAddress(session);
        s = internetaddress != null ? internetaddress.getAddress() : "javamailuser@localhost";
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append(stringbuffer.hashCode()).append('.').append(System.currentTimeMillis()).append('.').append("ebxmlrr.").append(s);
        return stringbuffer.toString();
    }

    public byte[] getBytesFromInputStream(InputStream is) throws IOException {
        byte[] buffer;
        int noOfBytes;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((noOfBytes = is.read(buffer = new byte[100])) != -1) {
            bos.write(buffer, 0, noOfBytes);
        }
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    public InputStream createSOAPStreamFromRequestStream(InputStream req) throws SOAPException, IOException, ParseException {
        String soapNS = "http://schemas.xmlsoap.org/soap/envelope/";
        String soapEnv = "soap-env";
        String soapEnvPrefix = soapEnv + ":";
        byte[] requestBytesWithDecl = this.getBytesFromInputStream(req);
        String decl = this.getXMLDeclaration(requestBytesWithDecl);
        byte[] requestBytes = this.removeXMLDeclaration(requestBytesWithDecl);
        requestBytesWithDecl = null;
        String partBeforeRequestStr = decl + "\n<" + soapEnvPrefix + "Envelope" + "\n\txmlns:soap-env=\"" + soapNS + "\"" + "\n\txmlns:SOAP-SEC=\"http://schemas.xmlsoap.org/soap/security/2000-12\" soap-env:actor=\"some-uri\"" + "\n\tsoap-env:mustUnderstand=\"1\">" + "\n\n\t<" + soapEnvPrefix + "Header>" + "\n\t</" + soapEnvPrefix + "Header>" + "\n\n\t<" + soapEnvPrefix + "Body SOAP-SEC:id=\"Body\">" + "\n";
        String partAfterRequestStr = "\n\t</" + soapEnvPrefix + "Body>" + "\n\n</" + soapEnvPrefix + "Envelope>";
        byte[] partBeforeRequestBytes = partBeforeRequestStr.getBytes("ISO-8859-1");
        byte[] partAfterRequestBytes = partAfterRequestStr.getBytes("ISO-8859-1");
        byte[] soapBytes = new byte[partBeforeRequestBytes.length + requestBytes.length + partAfterRequestBytes.length];
        int soapBytesIndex = 0;
        for (int a = 0; a < partBeforeRequestBytes.length; ++a) {
            soapBytes[soapBytesIndex] = partBeforeRequestBytes[a];
            ++soapBytesIndex;
        }
        for (int b = 0; b < requestBytes.length; ++b) {
            soapBytes[soapBytesIndex] = requestBytes[b];
            ++soapBytesIndex;
        }
        for (int c = 0; c < partAfterRequestBytes.length; ++c) {
            soapBytes[soapBytesIndex] = partAfterRequestBytes[c];
            ++soapBytesIndex;
        }
        return new ByteArrayInputStream(soapBytes);
    }

    public SOAPMessage createSOAPMessageFromRequestStream(InputStream reqStream) throws SOAPException, IOException, ParseException {
        InputStream is = this.createSOAPStreamFromRequestStream(reqStream);
        MimeHeaders mimeHeaders = new MimeHeaders();
        ContentType contentType = new ContentType("text/xml");
        String contentTypeStr = contentType.toString();
        mimeHeaders.addHeader("Content-Type", contentTypeStr);
        mimeHeaders.addHeader("Content-Id", "ebXML Registry SOAP request");
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage msg = factory.createMessage(mimeHeaders, is);
        msg.saveChanges();
        return msg;
    }

    public SOAPMessage createSOAPMessageFromSOAPStream(InputStream soapStream) throws SOAPException, IOException, ParseException {
        MimeHeaders mimeHeaders = new MimeHeaders();
        ContentType contentType = new ContentType("text/xml");
        String contentTypeStr = contentType.toString();
        mimeHeaders.addHeader("Content-Type", contentTypeStr);
        mimeHeaders.addHeader("Content-Id", "ebXML Registry SOAP request");
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage msg = factory.createMessage(mimeHeaders, soapStream);
        msg.saveChanges();
        return msg;
    }

    public RegistryResponse createRegistryResponseFromThrowable(Throwable t, String codeContext, String errCode) {
        RegistryResponse resp = new RegistryResponse();
        resp.setStatus(StatusType.FAILURE);
        RegistryErrorList el = new RegistryErrorList();
        RegistryError re = new RegistryError();
        el.addRegistryError(re);
        resp.setRegistryErrorList(el);
        String stackTrace = this.getStackTraceFromThrowable(t);
        System.err.println(stackTrace);
        String nestedStackTrace = null;
        if (t instanceof RegistryException) {
            Exception nestedException = ((RegistryException)t).getException();
            nestedStackTrace = this.getStackTraceFromThrowable(nestedException);
        }
        stackTrace = stackTrace + "\n\nNested exception was:\n" + nestedStackTrace;
        re.setContent(stackTrace);
        re.setCodeContext(codeContext);
        re.setErrorCode(errCode);
        return resp;
    }

    public String getStackTraceFromThrowable(Throwable t) {
        String trace = null;
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            trace = sw.toString();
        }
        return trace;
    }

    public String createTimestamp() {
        TimeZone tz = TimeZone.getDefault();
        float rawOffset = (float)(tz.getRawOffset() / 1000 / 60) / 60.0f;
        int offsetHr = (int)Math.abs(rawOffset);
        int offsetMin = (int)(rawOffset - (float)offsetHr) * 60;
        String offset = rawOffset > 0.0f ? "+" : "-";
        offset = offset + (offsetHr < 10 ? "0" : "");
        offset = offset + offsetHr;
        offset = offset + ":";
        offset = offset + (offsetMin < 10 ? "0" : "");
        offset = offset + offsetMin;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return sdf.format(new Date()) + offset;
    }

    public ArrayList validateURIs(ArrayList sourceRegistryObjects) throws RegistryException {
        ArrayList invalidURLROs = new ArrayList();
        Iterator iter = sourceRegistryObjects.iterator();
        while (iter.hasNext()) {
            Object ro = iter.next();
            String uRI = null;
            if (ro instanceof ExternalLink) {
                uRI = ((ExternalLink)ro).getExternalURI();
            } else if (ro instanceof ServiceBinding) {
                uRI = ((ServiceBinding)ro).getAccessURI();
            } else {
                throw new RegistryException("Internal Error happens, unknown RegistryObjectType");
            }
            if (this.isValidURI(uRI)) continue;
            invalidURLROs.add(ro);
        }
        return invalidURLROs;
    }

    public boolean isValidURI(String uRI) {
        URL uRL = null;
        try {
            uRL = new URL(uRI);
        }
        catch (MalformedURLException e) {
            return true;
        }
        if (uRL.getProtocol().equalsIgnoreCase("http")) {
            try {
                HttpURLConnection httpUrlConn = (HttpURLConnection)uRL.openConnection();
                int responseCode = httpUrlConn.getResponseCode();
                return responseCode >= 200 && responseCode <= 299;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public Element getSignatureElement(SOAPMessage msg) throws SOAPException, TransformerException {
        Element sigElement = null;
        Transformer xFormer = TransformerFactory.newInstance().newTransformer();
        SOAPPart msgPart = msg.getSOAPPart();
        Source msgSource = msgPart.getContent();
        DOMResult domResult = new DOMResult();
        xFormer.transform(msgSource, domResult);
        Node envelopeNode = domResult.getNode();
        while (envelopeNode.getLocalName() == null || !envelopeNode.getLocalName().equalsIgnoreCase("envelope")) {
            envelopeNode = envelopeNode.getFirstChild();
        }
        Node headerNode = envelopeNode.getFirstChild();
        while (headerNode.getLocalName() == null || !headerNode.getLocalName().equalsIgnoreCase("header")) {
            headerNode = headerNode.getNextSibling();
        }
        Node sigNode = headerNode.getFirstChild();
        if (sigNode == null) {
            return null;
        }
        while (sigNode.getLocalName() == null || !sigNode.getLocalName().equalsIgnoreCase("signature")) {
            if ((sigNode = sigNode.getNextSibling()) != null) continue;
            return null;
        }
        if (!sigNode.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
            sigNode = sigNode.getFirstChild();
            while (sigNode.getLocalName() == null || !sigNode.getLocalName().equalsIgnoreCase("signature")) {
                sigNode = sigNode.getNextSibling();
            }
        }
        if (sigNode.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && sigNode instanceof Element) {
            sigElement = (Element)sigNode;
        }
        return sigElement;
    }

    public String stripId(String id) {
        if (id != null && id.startsWith("urn:uuid:")) {
            id = id.substring(9).trim();
        }
        return id;
    }

    public static String escapeSQLChars(String stringField) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < stringField.length(); ++i) {
            char c = stringField.charAt(i);
            result.append(c);
            if (c != '\'') continue;
            result.append(c);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Utility getInstance() {
        if (instance == null) {
            Class clazz = class$com$sun$ebxml$registry$util$Utility == null ? (class$com$sun$ebxml$registry$util$Utility = Utility.class$("com.sun.ebxml.registry.util.Utility")) : class$com$sun$ebxml$registry$util$Utility;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new Utility();
                }
            }
        }
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

