/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.admin;

import com.sun.xml.registry.client.util.RegistryObjectUtil;
import com.sun.xml.registry.ebxml.util.KeystoreUtil;
import com.sun.xml.registry.ebxml.util.ProviderProperties;
import com.sun.xml.registry.ebxml.util.SecurityUtil;
import java.util.ArrayList;
import java.util.HashSet;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class UserAdmin {
    private static final SecurityUtil su = SecurityUtil.getInstance();
    BusinessQueryManager bqm;
    BusinessLifeCycleManager lcm;
    DeclarativeQueryManager dqm;

    public void init(String serverUrl, String alias) throws JAXRException {
        ConnectionFactory connFactory = ConnectionFactory.newInstance();
        ProviderProperties.getInstance().put("javax.xml.registry.queryManagerURL", serverUrl);
        Connection connection = connFactory.createConnection();
        HashSet<X500PrivateCredential> creds = new HashSet<X500PrivateCredential>();
        creds.add(su.aliasToX500PrivateCredential(alias));
        connection.setCredentials(creds);
        RegistryService service = connection.getRegistryService();
        this.bqm = service.getBusinessQueryManager();
        this.lcm = service.getBusinessLifeCycleManager();
        this.dqm = service.getDeclarativeQueryManager();
    }

    public User getUser() throws JAXRException {
        RegistryPackage pkg1 = this.lcm.createRegistryPackage("Dummy Package 1");
        ArrayList<Object> al = new ArrayList<Object>();
        al.add(pkg1);
        BulkResponse br = this.lcm.saveObjects(al);
        if (br.getExceptions() != null) {
            return null;
        }
        User user = RegistryObjectUtil.getOwner(pkg1);
        al.clear();
        al.add(pkg1.getKey());
        br = this.lcm.deleteObjects(al);
        if (br.getStatus() != 0) {
            System.err.println("Warning: unable clean up dummy objects created on server");
        }
        if (user == null) {
            throw new JAXRException("Unable to obtain User object corresponding to credentials");
        }
        return user;
    }

    private User populateUser(User user, String personName) throws JAXRException {
        InternationalString isName = this.lcm.createInternationalString(personName);
        user.setName(isName);
        user.setPersonName(this.lcm.createPersonName(personName));
        ArrayList<Object> al = new ArrayList<Object>();
        al.add(this.lcm.createEmailAddress("jaxr-discussion@yahoogroups.com"));
        user.setEmailAddresses(al);
        al.clear();
        al.add(this.lcm.createPostalAddress("1234", "Test Blvd", "Santa Clara", "CA", "USA", "95054", null));
        user.setPostalAddresses(al);
        TelephoneNumber phone = this.lcm.createTelephoneNumber();
        phone.setAreaCode("408");
        phone.setNumber("555-1212");
        al.clear();
        al.add(phone);
        user.setTelephoneNumbers(al);
        return user;
    }

    public void registerUser(String personName) throws JAXRException {
        if (this.getUser() != null) {
            System.out.println("Error: User is already registered, use -update command instead");
            return;
        }
        User newUser = this.lcm.createUser();
        this.populateUser(newUser, personName);
        ArrayList<User> al = new ArrayList<User>();
        al.add(newUser);
        BulkResponse br = this.lcm.saveObjects(al);
        RegistryObjectUtil.checkBulkResponse(br);
    }

    public void updateUser(String personName) throws JAXRException {
        User user = this.getUser();
        if (user == null) {
            System.out.println("Error: User is not registered");
            return;
        }
        this.populateUser(user, personName);
        ArrayList<User> al = new ArrayList<User>();
        al.add(user);
        BulkResponse br = this.lcm.saveObjects(al);
        RegistryObjectUtil.checkBulkResponse(br);
    }

    public void removeUser() throws JAXRException {
        User user = this.getUser();
        if (user == null) {
            System.out.println("Error: User is not registered");
            return;
        }
        ArrayList<Key> al = new ArrayList<Key>();
        al.add(user.getKey());
        BulkResponse br = this.lcm.deleteObjects(al);
        RegistryObjectUtil.checkBulkResponse(br);
    }

    private static void usage() {
        System.err.println("Usage: UserAdmin -<command> [parameters]");
        System.err.println("    -getUser                     Query the server for a User");
        System.err.println("    -register personName=<>      Register a new User");
        System.err.println("    -update personName=<>        Update an existing User");
        System.err.println("    -remove                      Remove an existing User");
        System.err.println("    alias=<keystore alias> used to link to credentials");
        System.err.println("    personName=<person name>");
        System.err.println("    url=<server url>");
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        String alias = ProviderProperties.getInstance().getProperty("UserAdmin.default.keystore.alias");
        String serverUrl = ProviderProperties.getInstance().getProperty("UserAdmin.server.url");
        String personName = null;
        String command = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-help")) {
                UserAdmin.usage();
                continue;
            }
            if (args[i].equalsIgnoreCase("-usage")) {
                UserAdmin.usage();
                continue;
            }
            if (args[i].equalsIgnoreCase("-getUser")) {
                command = "getUser";
                continue;
            }
            if (args[i].equalsIgnoreCase("-register")) {
                command = "register";
                continue;
            }
            if (args[i].equalsIgnoreCase("-update")) {
                command = "update";
                continue;
            }
            if (args[i].equalsIgnoreCase("-remove")) {
                command = "remove";
                continue;
            }
            if (args[i].startsWith("alias=")) {
                alias = args[i].substring(6);
                continue;
            }
            if (args[i].startsWith("personName=")) {
                personName = args[i].substring(11);
                continue;
            }
            if (args[i].startsWith("url=")) {
                serverUrl = args[i].substring(4);
                continue;
            }
            UserAdmin.usage();
        }
        if (alias == null) {
            throw new Exception("KeyStore alias is required");
        }
        if (!su.getKeyStore().containsAlias(alias)) {
            System.err.println("Unknown alias in KeyStore: alias=" + alias + ", KeyStore file=" + KeystoreUtil.getKeystoreFile());
            UserAdmin.usage();
        }
        if (command == null) {
            command = "getUser";
        }
        UserAdmin userAdmin = new UserAdmin();
        userAdmin.init(serverUrl, alias);
        System.out.println("Executing command: -" + command);
        if ("getUser".equals(command)) {
            System.out.println("Getting User linked to credentials with alias=" + alias + "...");
            User user = userAdmin.getUser();
            System.out.println("userId=" + RegistryObjectUtil.toId(user));
        } else if ("register".equals(command)) {
            if (personName == null) {
                UserAdmin.usage();
            }
            System.out.println("Registering new User linked to credentials with alias=" + alias + " using personName=" + personName + "...");
            userAdmin.registerUser(personName);
        } else if ("update".equals(command)) {
            if (personName == null) {
                UserAdmin.usage();
            }
            System.out.println("Updating User linked to credentials with alias=" + alias + " to personName=" + personName + "...");
            userAdmin.updateUser(personName);
        } else if ("remove".equals(command)) {
            System.out.println("Removing User linked to credentials with alias=" + alias + "...");
            userAdmin.removeUser();
        }
    }
}

