/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectPanel;
import com.sun.xml.registry.ebxml.BusinessQueryManagerImpl;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;

public class AssociationPanel
extends RegistryObjectPanel {
    JTextField sourceObjectText = null;
    JTextField targetObjectText = null;
    JCheckBox confirmedBySourceCheckBox = null;
    JCheckBox confirmedByTargetCheckBox = null;
    JCheckBox isExtramuralCheckBox = null;
    JComboBox assocTypeCombo = null;
    String[] assocTypes = new String[]{"PartnerOf"};

    public AssociationPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Association Details"));
        JLabel sourceObjectLabel = new JLabel("Source Object Id:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(sourceObjectLabel, this.c);
        this.add(sourceObjectLabel);
        this.sourceObjectText = new JTextField();
        this.sourceObjectText.setEditable(false);
        this.c.gridx = 0;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.sourceObjectText, this.c);
        this.add(this.sourceObjectText);
        JLabel targetObjectLabel = new JLabel("Target Object Id:", 2);
        this.c.gridx = 1;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(targetObjectLabel, this.c);
        this.add(targetObjectLabel);
        this.targetObjectText = new JTextField();
        this.targetObjectText.setEditable(false);
        this.c.gridx = 1;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.targetObjectText, this.c);
        this.add(this.targetObjectText);
        this.confirmedBySourceCheckBox = new JCheckBox("Confiirmed by Source Owner");
        this.confirmedBySourceCheckBox.setSelected(false);
        this.confirmedBySourceCheckBox.setEnabled(false);
        this.c.gridx = 0;
        this.c.gridy = this.row + 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.confirmedBySourceCheckBox, this.c);
        this.add(this.confirmedBySourceCheckBox);
        this.confirmedByTargetCheckBox = new JCheckBox("Confiirmed by Target Owner");
        this.confirmedByTargetCheckBox.setSelected(false);
        this.confirmedByTargetCheckBox.setEnabled(false);
        this.c.gridx = 1;
        this.c.gridy = this.row + 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.confirmedByTargetCheckBox, this.c);
        this.add(this.confirmedByTargetCheckBox);
        JLabel assocTypeLabel = new JLabel("Association Type:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(assocTypeLabel, this.c);
        this.add(assocTypeLabel);
        this.assocTypeCombo = new JComboBox<String>(AssociationPanel.getAssociationTypes());
        this.assocTypeCombo.setEditable(true);
        this.c.gridx = 0;
        this.c.gridy = this.row + 4;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.assocTypeCombo, this.c);
        this.add(this.assocTypeCombo);
        this.isExtramuralCheckBox = new JCheckBox("Is Extramural");
        this.isExtramuralCheckBox.setSelected(false);
        this.isExtramuralCheckBox.setEnabled(false);
        this.c.gridx = 1;
        this.c.gridy = this.row + 4;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.isExtramuralCheckBox, this.c);
        this.add(this.isExtramuralCheckBox);
    }

    public static String[] getAssociationTypes() {
        String[] assocTypes = null;
        try {
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            BusinessQueryManagerImpl bqm = (BusinessQueryManagerImpl)client.getBusinessQueryManager();
            Collection concepts = bqm.findConceptsByPath("/urn:uuid:6902675f-2f18-44b8-888b-c91db8b96b4d/%");
            int size = concepts.size();
            assocTypes = new String[size];
            Iterator iter = concepts.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Concept concept = (Concept)iter.next();
                assocTypes[i++] = concept.getValue();
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return assocTypes;
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof Association)) {
            throw new InvalidRequestException("Expecting a Association. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        Association ass = (Association)obj;
        try {
            if (ass != null) {
                RegistryObject src = ass.getSourceObject();
                RegistryObject target = ass.getTargetObject();
                boolean srcConfirmed = ass.isConfirmedBySourceOwner();
                boolean targetConfirmed = ass.isConfirmedByTargetOwner();
                boolean isExtramural = ass.isExtramural();
                Concept assType = ass.getAssociationType();
                if (src != null) {
                    this.sourceObjectText.setText(src.getKey().getId());
                }
                if (target != null) {
                    this.targetObjectText.setText(target.getKey().getId());
                }
                this.confirmedBySourceCheckBox.setSelected(srcConfirmed);
                this.confirmedByTargetCheckBox.setSelected(targetConfirmed);
                this.isExtramuralCheckBox.setSelected(isExtramural);
                if (assType != null) {
                    String path = assType.getPath();
                    this.assocTypeCombo.setSelectedItem(assType.getValue());
                }
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            Association ass = (Association)this.model;
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            BusinessQueryManagerImpl bqm = (BusinessQueryManagerImpl)client.getBusinessQueryManager();
            Concept assocType = bqm.findConceptByPath("/urn:uuid:6902675f-2f18-44b8-888b-c91db8b96b4d/" + (String)this.assocTypeCombo.getSelectedItem());
            ass.setAssociationType(assocType);
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        Association ass = (Association)this.model;
    }

    public void clear() throws JAXRException {
        super.clear();
        this.sourceObjectText.setText("");
        this.targetObjectText.setText("");
        this.confirmedBySourceCheckBox.setSelected(false);
        this.confirmedByTargetCheckBox.setSelected(false);
        this.isExtramuralCheckBox.setSelected(false);
    }
}

