/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ClassificationsList;
import com.sun.xml.registry.client.browser.ClassificationsListModel;
import com.sun.xml.registry.client.browser.ConceptsTreeModel;
import com.sun.xml.registry.client.browser.ExternalIdentifiersList;
import com.sun.xml.registry.client.browser.ExternalIdentifiersListModel;
import com.sun.xml.registry.client.browser.ExternalLinksList;
import com.sun.xml.registry.client.browser.ExternalLinksListModel;
import com.sun.xml.registry.client.browser.FindParamsPanel;
import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.QueryPanel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.TreeCombo;
import com.sun.xml.registry.client.browser.conf.bindings.Configuration;
import com.sun.xml.registry.ebxml.BusinessQueryManagerImpl;
import com.sun.xml.registry.ebxml.DeclarativeQueryManagerImpl;
import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import com.sun.xml.registry.ebxml.util.ProviderProperties;
import com.sun.xml.registry.ebxml.util.QueryUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.Query;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BusinessQueryPanel
extends QueryPanel
implements PropertyChangeListener {
    private GridBagConstraints c = new GridBagConstraints();
    private TreeCombo objectTypeCombo = null;
    private static ConceptsTreeModel objectTypesTreeModel = null;
    private JTextField nameText = null;
    private JTextField descText = null;
    private JCheckBox caseSensitiveCheckBox = null;
    private ClassificationsList classificationsList = null;
    private ExternalIdentifiersList extIdsList = null;
    private ExternalLinksList linksList = null;
    private Log log = LogFactory.getLog(this.getClass());
    QueryUtil qu = QueryUtil.getInstance();

    public BusinessQueryPanel(final FindParamsPanel findParamsPanel, Configuration cfg) throws JAXRException {
        super(findParamsPanel, cfg);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        JLabel objectTypeLabel = new JLabel("Object Type:", 2);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(objectTypeLabel, this.c);
        this.add(objectTypeLabel);
        ClassificationScheme objectTypeScheme = null;
        JAXRClient client = RegistryBrowser.getInstance().getClient();
        BusinessQueryManager bqm = client.getBusinessQueryManager();
        objectTypeScheme = (ClassificationScheme)bqm.getRegistryObject("urn:uuid:3188a449-18ac-41fb-be9f-99a1adca02cb", "ClassificationScheme");
        objectTypesTreeModel = new ConceptsTreeModel(true, objectTypeScheme);
        this.objectTypeCombo = new TreeCombo(objectTypesTreeModel);
        String selectedIndexStr = ProviderProperties.getInstance().getProperty("jaxr-ebxml.registryBrowser.objectTypeCombo.initialSelectionIndex", "1");
        int index = Integer.parseInt(selectedIndexStr);
        this.objectTypeCombo.setSelectedIndex(index);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        gbl.setConstraints(this.objectTypeCombo, this.c);
        this.add(this.objectTypeCombo);
        this.objectTypeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 2) {
                    return;
                }
                String objectType = BusinessQueryPanel.this.getObjectType();
            }
        });
        this.caseSensitiveCheckBox = new JCheckBox("Case Sensitive Search");
        this.caseSensitiveCheckBox.setSelected(false);
        this.caseSensitiveCheckBox.setEnabled(true);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.caseSensitiveCheckBox, this.c);
        this.add(this.caseSensitiveCheckBox);
        JLabel nameLabel = new JLabel("Name:", 2);
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(nameLabel, this.c);
        this.add(nameLabel);
        this.nameText = new JTextField();
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 13;
        this.c.insets = new Insets(4, 4, 4, 4);
        gbl.setConstraints(this.nameText, this.c);
        this.add(this.nameText);
        this.nameText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                findParamsPanel.find();
            }
        });
        JLabel descLabel = new JLabel("Description:", 2);
        this.c.gridx = 0;
        this.c.gridy = 5;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(descLabel, this.c);
        this.add(descLabel);
        this.descText = new JTextField();
        this.c.gridx = 0;
        this.c.gridy = 6;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 13;
        this.c.insets = new Insets(4, 4, 4, 4);
        gbl.setConstraints(this.descText, this.c);
        this.add(this.descText);
        this.descText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                findParamsPanel.find();
            }
        });
        JLabel classificationsLabel = new JLabel("Classifications:", 2);
        this.c.gridx = 0;
        this.c.gridy = 7;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(classificationsLabel, this.c);
        this.add(classificationsLabel);
        this.classificationsList = new ClassificationsList();
        this.classificationsList.setEditable(true);
        this.classificationsList.setVisibleRowCount(3);
        JScrollPane classificationsListScrollPane = new JScrollPane(this.classificationsList);
        classificationsListScrollPane.setMinimumSize(new Dimension(-1, 50));
        this.c.gridx = 0;
        this.c.gridy = 8;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        gbl.setConstraints(classificationsListScrollPane, this.c);
        this.add(classificationsListScrollPane);
        JLabel identifiersLabel = new JLabel("External Identifiers:", 2);
        this.c.gridx = 0;
        this.c.gridy = 9;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(identifiersLabel, this.c);
        this.add(identifiersLabel);
        this.extIdsList = new ExternalIdentifiersList();
        this.extIdsList.setEditable(true);
        this.extIdsList.setVisibleRowCount(3);
        JScrollPane extIdsListScrollPane = new JScrollPane(this.extIdsList);
        extIdsListScrollPane.setMinimumSize(new Dimension(-1, 50));
        this.c.gridx = 0;
        this.c.gridy = 10;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        gbl.setConstraints(extIdsListScrollPane, this.c);
        this.add(extIdsListScrollPane);
        JLabel linksLabel = new JLabel("External Links:", 2);
        this.c.gridx = 0;
        this.c.gridy = 11;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(linksLabel, this.c);
        this.add(linksLabel);
        this.linksList = new ExternalLinksList();
        this.linksList.setEditable(true);
        this.linksList.setVisibleRowCount(3);
        JScrollPane linksListScrollPane = new JScrollPane(this.linksList);
        linksListScrollPane.setMinimumSize(new Dimension(-1, 50));
        this.c.gridx = 0;
        this.c.gridy = 12;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        gbl.setConstraints(linksListScrollPane, this.c);
        this.add(linksListScrollPane);
    }

    protected void processConfiguration() {
    }

    public static ConceptsTreeModel getObjectTypesTreeModel() {
        return objectTypesTreeModel;
    }

    private String getObjectType() {
        Object objectType = null;
        Object selectedItem = this.objectTypeCombo.getSelectedItem();
        return selectedItem.toString();
    }

    public static String[] getObjectTypes() {
        String[] array = null;
        ArrayList<String> objectTypes = new ArrayList<String>();
        try {
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            BusinessQueryManagerImpl bqm = (BusinessQueryManagerImpl)client.getBusinessQueryManager();
            Collection concepts = bqm.findConceptsByPath("/urn:uuid:3188a449-18ac-41fb-be9f-99a1adca02cb/RegistryObject%");
            int size = concepts.size();
            Iterator iter = concepts.iterator();
            boolean i = false;
            while (iter.hasNext()) {
                Concept concept = (Concept)iter.next();
                String objectType = concept.getValue();
                if (objectType.equals("ClassificationNode")) {
                    objectType = "Concept";
                }
                objectTypes.add(objectType);
            }
            Collections.sort(objectTypes);
            array = new String[size];
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return (String[])objectTypes.toArray(array);
    }

    BulkResponse executeQuery() {
        BulkResponse resp = null;
        try {
            String nameStr = this.nameText.getText();
            String descStr = this.descText.getText();
            ArrayList classifications = ((ClassificationsListModel)this.classificationsList.getModel()).getModels();
            ArrayList extIds = ((ExternalIdentifiersListModel)this.extIdsList.getModel()).getModels();
            ArrayList extLinks = ((ExternalLinksListModel)this.linksList.getModel()).getModels();
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            RegistryBrowser.getInstance();
            Connection connection = RegistryBrowser.client.getConnection();
            RegistryService service = connection.getRegistryService();
            BusinessQueryManagerImpl bqm = (BusinessQueryManagerImpl)service.getBusinessQueryManager();
            DeclarativeQueryManagerImpl dqm = (DeclarativeQueryManagerImpl)service.getDeclarativeQueryManager();
            String objectType = this.getObjectType();
            if (this.qu.getUnsupportedObjectTypes().contains(objectType)) {
                throw new JAXRException("Search not supported for: " + objectType);
            }
            boolean isIntrinsic = BusinessQueryPanel.isIntrinsicObjectType(objectType);
            boolean caseSensitive = this.caseSensitiveCheckBox.isSelected();
            String queryStr = "SELECT * from ";
            queryStr = isIntrinsic ? queryStr + objectType + " obj " : queryStr + "ExtrinsicObject obj, ClassificationNode typeNode ";
            if (nameStr != null && nameStr.length() != 0) {
                queryStr = queryStr + ", Name name ";
            }
            if (descStr != null && descStr.length() != 0) {
                queryStr = queryStr + ", Description des ";
            }
            boolean addedPredicate = false;
            if (!isIntrinsic) {
                if (!addedPredicate) {
                    queryStr = queryStr + "WHERE ";
                    addedPredicate = true;
                } else {
                    queryStr = queryStr + "AND ";
                }
                queryStr = queryStr + "((obj.objectType = typeNode.id) AND (typeNode.path LIKE '%/" + objectType + "%')) ";
            }
            if (nameStr != null && nameStr.length() > 0) {
                if (!addedPredicate) {
                    queryStr = queryStr + "WHERE ";
                    addedPredicate = true;
                } else {
                    queryStr = queryStr + "AND ";
                }
                queryStr = queryStr + "((name.parent = obj.id) AND (" + BusinessQueryManagerImpl.caseSensitise("name.value", caseSensitive) + " LIKE " + BusinessQueryManagerImpl.caseSensitise("'" + nameStr + "'", caseSensitive) + ")) ";
            }
            if (descStr != null && descStr.length() > 0) {
                if (!addedPredicate) {
                    queryStr = queryStr + "WHERE ";
                    addedPredicate = true;
                } else {
                    queryStr = queryStr + "AND ";
                }
                queryStr = queryStr + "((des.parent = obj.id) AND (" + BusinessQueryManagerImpl.caseSensitise("des.value", caseSensitive) + " LIKE " + BusinessQueryManagerImpl.caseSensitise("'" + descStr + "'", caseSensitive) + ")) ";
            }
            if (classifications.size() > 0) {
                if (!addedPredicate) {
                    queryStr = queryStr + "WHERE ";
                    addedPredicate = true;
                } else {
                    queryStr = queryStr + "AND ";
                }
                queryStr = queryStr + this.qu.classificationsToPred(classifications, "obj.id");
            }
            if (extIds.size() > 0) {
                if (!addedPredicate) {
                    queryStr = queryStr + "WHERE ";
                    addedPredicate = true;
                } else {
                    queryStr = queryStr + "AND ";
                }
                queryStr = queryStr + this.qu.externalIdentifiersToPred(extIds, "obj.id");
            }
            if (extLinks.size() > 0) {
                if (!addedPredicate) {
                    queryStr = queryStr + "WHERE ";
                    addedPredicate = true;
                } else {
                    queryStr = queryStr + "AND ";
                }
                queryStr = queryStr + this.qu.externalLinksToPred(extLinks, "obj.id");
            }
            Query query = dqm.createQuery(0, queryStr);
            resp = dqm.executeQuery(query);
            client.checkBulkResponse(resp);
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return resp;
    }

    public static boolean isIntrinsicObjectType(String objectType) throws JAXRException {
        boolean isIntrinsic = true;
        JAXRClient client = RegistryBrowser.getInstance().getClient();
        RegistryBrowser.getInstance();
        Connection connection = RegistryBrowser.client.getConnection();
        RegistryServiceImpl service = (RegistryServiceImpl)connection.getRegistryService();
        String className = "javax.xml.registry.infomodel." + service.mapEbXMLNameToJAXRName(objectType);
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            isIntrinsic = false;
        }
        return isIntrinsic;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("selectedConcepts")) {
            try {
                RegistryBrowser.getInstance();
                Connection connection = RegistryBrowser.client.getConnection();
                RegistryService service = connection.getRegistryService();
                BusinessLifeCycleManager lcm = service.getBusinessLifeCycleManager();
                ArrayList selectedConcepts = (ArrayList)ev.getNewValue();
                ArrayList<Classification> classifications = new ArrayList<Classification>();
                Iterator iter = selectedConcepts.iterator();
                while (iter.hasNext()) {
                    Concept concept = (Concept)iter.next();
                    Classification classification = lcm.createClassification(concept);
                    classifications.add(classification);
                }
                ((ClassificationsListModel)this.classificationsList.getModel()).setModels(classifications);
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
        }
    }

    public void clear() throws JAXRException {
        this.nameText.setText("");
        this.descText.setText("");
        if (this.classificationsList != null) {
            ((ClassificationsListModel)this.classificationsList.getModel()).clear();
        }
        if (this.extIdsList != null) {
            ((ExternalIdentifiersListModel)this.extIdsList.getModel()).clear();
        }
        if (this.linksList != null) {
            ((ExternalLinksListModel)this.linksList.getModel()).clear();
        }
    }
}

