/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ConceptsTreeDialog;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectPanel;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;

public class ConceptPanel
extends RegistryObjectPanel {
    JTextField schemeText = null;
    JTextField parentText = null;
    JTextField valueText = null;
    JTextField pathText = null;

    public ConceptPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Concept"));
        JButton showSchemeButton = new JButton("Select an existing Concept...");
        showSchemeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ConceptPanel.this.getSelectedSchemeOrConcept();
            }
        });
        this.c.gridx = 1;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(showSchemeButton, this.c);
        this.add(showSchemeButton);
        JLabel schemeLabel = new JLabel("ClassificationScheme:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(schemeLabel, this.c);
        this.add(schemeLabel);
        this.schemeText = new JTextField();
        this.schemeText.setEditable(false);
        this.c.gridx = 0;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.schemeText, this.c);
        this.add(this.schemeText);
        JLabel parentLabel = new JLabel("Parent id:", 2);
        this.c.gridx = 1;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(parentLabel, this.c);
        this.add(parentLabel);
        this.parentText = new JTextField();
        this.parentText.setEditable(false);
        this.c.gridx = 1;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.parentText, this.c);
        this.add(this.parentText);
        JLabel pathLabel = new JLabel("Path:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(pathLabel, this.c);
        this.add(pathLabel);
        this.pathText = new JTextField();
        this.pathText.setEditable(false);
        this.c.gridx = 0;
        this.c.gridy = this.row + 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.pathText, this.c);
        this.add(this.pathText);
        JLabel valueLabel = new JLabel("Value:", 2);
        this.c.gridx = 1;
        this.c.gridy = this.row + 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(valueLabel, this.c);
        this.add(valueLabel);
        this.valueText = new JTextField();
        this.valueText.setEditable(this.editable);
        this.c.gridx = 1;
        this.c.gridy = this.row + 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.valueText, this.c);
        this.add(this.valueText);
    }

    private void getSelectedSchemeOrConcept() {
        ConceptsTreeDialog dialog = ConceptsTreeDialog.showSchemes(this, true, true);
        if (dialog.getStatus() == 1) {
            ArrayList selectedObjects = dialog.getSelectedConcepts();
            int selectionCount = selectedObjects.size();
            if (selectionCount == 0) {
                RegistryBrowser.displayError("Must select a Concept in ClassificationScheme dialog");
            } else {
                if (selectionCount > 1) {
                    RegistryBrowser.displayError("Only one Concept selection is allowed in ClassificationScheme dialog. Using last selection");
                }
                Object obj = selectedObjects.get(selectionCount - 1);
                try {
                    Object conceptNameStr = null;
                    Object scheme = null;
                    if (obj instanceof Concept) {
                        Concept concept = (Concept)obj;
                        this.setModel(concept);
                    }
                }
                catch (JAXRException e) {
                    RegistryBrowser.displayError(e);
                }
            }
        }
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof Concept)) {
            throw new InvalidRequestException("Expecting a Concept. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        Concept concept = (Concept)obj;
        try {
            if (concept != null) {
                ClassificationScheme scheme = concept.getClassificationScheme();
                RegistryObject parent = concept.getParent();
                String path = concept.getPath();
                String value = concept.getValue();
                if (scheme != null) {
                    String schemeName = RegistryBrowser.getName(scheme);
                    if (schemeName == null || schemeName.length() == 0) {
                        schemeName = scheme.getKey().getId();
                    }
                    this.schemeText.setText(schemeName);
                }
                if (parent != null) {
                    this.parentText.setText(parent.getKey().getId());
                }
                if (path != null) {
                    this.pathText.setText(path);
                }
                if (value != null) {
                    this.valueText.setText(value);
                }
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            Concept concept = (Concept)this.model;
            concept.setValue(this.valueText.getText());
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
    }

    public void clear() throws JAXRException {
        super.clear();
        this.schemeText.setText("");
        this.parentText.setText("");
        this.pathText.setText("");
        this.valueText.setText("");
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.valueText.setEditable(editable);
    }
}

