/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ConceptsTreeModel;
import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.JBEditorDialog;
import com.sun.xml.registry.client.browser.NodeInfo;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.graph.JBGraphPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;

public class ConceptsTree
extends JTree
implements PropertyChangeListener {
    JPopupMenu popup;
    JMenuItem editMenuItem = null;
    JMenuItem insertMenuItem = null;
    JMenuItem removeMenuItem = null;
    JMenuItem saveMenuItem = null;
    JMenuItem browseMenuItem = null;
    JMenuItem auditTrailMenuItem = null;
    JMenuItem exportMenuItem = null;
    JMenuItem retrieveMenuItem = null;
    MouseListener popupListener;
    private boolean editable = RegistryBrowser.getInstance().isAuthenticated();
    private static ConceptsTreeModel s_conceptsTreeModel = null;

    public ConceptsTree(boolean updateOnCreate) {
        if (s_conceptsTreeModel == null) {
            s_conceptsTreeModel = new ConceptsTreeModel(updateOnCreate);
        }
        this.setModel(s_conceptsTreeModel);
        this.setCellRenderer(new ConceptsTreeCellRenderer());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ConceptsTree.this.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Component c = SwingUtilities.getRoot(ConceptsTree.this);
                Cursor oldCursor = c.getCursor();
                RegistryBrowser.setWaitCursor();
                ((ConceptsTreeModel)ConceptsTree.this.getModel()).expandTree(node, 1);
                RegistryBrowser.setDefaultCursor();
            }
        });
        ((ConceptsTreeModel)this.getModel()).addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
            }

            public void treeNodesInserted(TreeModelEvent e) {
            }

            public void treeNodesRemoved(TreeModelEvent e) {
            }

            public void treeNodesStructureChanged(TreeModelEvent e) {
            }

            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        this.createPopup();
        RegistryBrowser.getInstance().addPropertyChangeListener(RegistryBrowser.PROPERTY_AUTHENTICATED, this);
        this.setToolTipText("Classification Schemes");
    }

    private void createPopup() {
        this.popup = new JPopupMenu();
        this.editMenuItem = this.editable ? new JMenuItem("Edit") : new JMenuItem("Show Details");
        this.popup.add(this.editMenuItem);
        this.insertMenuItem = new JMenuItem("Insert");
        this.popup.add(this.insertMenuItem);
        this.removeMenuItem = new JMenuItem("Remove");
        this.popup.add(this.removeMenuItem);
        this.saveMenuItem = new JMenuItem("Save");
        this.popup.add(this.saveMenuItem);
        this.browseMenuItem = new JMenuItem("Browse");
        this.popup.add(this.browseMenuItem);
        this.auditTrailMenuItem = new JMenuItem("Show Audit Trail");
        this.popup.add(this.auditTrailMenuItem);
        this.exportMenuItem = new JMenuItem("Export");
        this.popup.add(this.exportMenuItem);
        boolean authenticated = RegistryBrowser.getInstance().isAuthenticated();
        this.insertMenuItem.setVisible(authenticated);
        this.removeMenuItem.setVisible(authenticated);
        this.saveMenuItem.setVisible(authenticated);
        this.editMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConceptsTree.this.editAction();
            }
        });
        this.insertMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConceptsTree.this.insertAction();
            }
        });
        this.removeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConceptsTree.this.removeAction();
            }
        });
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConceptsTree.this.saveAction();
            }
        });
        this.browseMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConceptsTree.this.browseAction();
            }
        });
        this.auditTrailMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConceptsTree.this.auditTrailAction();
            }
        });
        this.exportMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConceptsTree.this.exportAction();
            }
        });
        this.popupListener = new PopupListener();
        this.addMouseListener(this.popupListener);
    }

    public ArrayList getSelectedConcepts() {
        ArrayList<Concept> objects = new ArrayList<Concept>();
        TreePath[] treePaths = this.getSelectionPaths();
        if (treePaths != null) {
            NodeInfo nodeInfo = null;
            for (int i = 0; i < treePaths.length; ++i) {
                nodeInfo = (NodeInfo)((DefaultMutableTreeNode)treePaths[i].getLastPathComponent()).getUserObject();
                if (!(nodeInfo.obj instanceof Concept)) continue;
                objects.add((Concept)nodeInfo.obj);
            }
        }
        return objects;
    }

    public ArrayList getSelectedClassificationSchemes() {
        ArrayList<RegistryObject> objects = new ArrayList<RegistryObject>();
        TreePath[] treePaths = this.getSelectionPaths();
        if (treePaths != null) {
            NodeInfo nodeInfo = null;
            for (int i = 0; i < treePaths.length; ++i) {
                nodeInfo = (NodeInfo)((DefaultMutableTreeNode)treePaths[i].getLastPathComponent()).getUserObject();
                if (!(nodeInfo.obj instanceof ClassificationScheme)) continue;
                objects.add(nodeInfo.obj);
            }
        }
        return objects;
    }

    public ArrayList getSelectedObjects() {
        ArrayList<RegistryObject> objects = new ArrayList<RegistryObject>();
        TreePath[] treePaths = this.getSelectionPaths();
        if (treePaths != null) {
            NodeInfo nodeInfo = null;
            for (int i = 0; i < treePaths.length; ++i) {
                nodeInfo = (NodeInfo)((DefaultMutableTreeNode)treePaths[i].getLastPathComponent()).getUserObject();
                objects.add(nodeInfo.obj);
            }
        }
        return objects;
    }

    protected void editAction() {
        RegistryBrowser.setWaitCursor();
        Object[] selectedObjects = this.getSelectedObjects().toArray();
        if (selectedObjects.length == 1) {
            RegistryObject ro = (RegistryObject)selectedObjects[0];
            JBEditorDialog.showObjectDetails(this, ro, false, this.editable);
        } else {
            RegistryBrowser.displayError("Exactly one object must be selected in list for Edit action.");
        }
        RegistryBrowser.setDefaultCursor();
    }

    protected void insertAction() {
        try {
            RegistryBrowser.setWaitCursor();
            ArrayList selectedObjects = this.getSelectedObjects();
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            BusinessLifeCycleManager lcm = client.getBusinessLifeCycleManager();
            int size = selectedObjects.size();
            if (size == 0) {
                ClassificationScheme scheme = lcm.createClassificationScheme("Scheme Name (Change me)", "Scheme description (Change me)");
                JBEditorDialog dialog = JBEditorDialog.showObjectDetails(this, scheme, true, this.editable);
                if (dialog.getStatus() != 1) {
                    return;
                }
                ((ConceptsTreeModel)this.getModel()).insertClassificationScheme(scheme);
            } else if (size == 1) {
                RegistryObject selectedObject = (RegistryObject)selectedObjects.get(0);
                Concept concept = lcm.createConcept(selectedObject, "Concept Name (Change me)", "Value (Change me)");
                JBEditorDialog dialog = JBEditorDialog.showObjectDetails(this, concept, true, this.editable);
                if (dialog.getStatus() != 1) {
                    return;
                }
                TreePath[] treePaths = this.getSelectionPaths();
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treePaths[0].getLastPathComponent();
                ((ConceptsTreeModel)this.getModel()).insertConcept(concept, parentNode);
            } else {
                RegistryBrowser.displayError("Exactly one object must be selected in list for Insert action.");
            }
            RegistryBrowser.setDefaultCursor();
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void removeAction() {
        RegistryBrowser.setWaitCursor();
        selectedObjects = this.getSelectedObjects();
        size = selectedObjects.size();
        if (size >= 1) {
            try {
                removeKeys = new ArrayList<Key>();
                for (i = size - 1; i >= 0; --i) {
                    obj = (RegistryObject)selectedObjects.get(i);
                    key = obj.getKey();
                    removeKeys.add(key);
                }
                client = RegistryBrowser.getInstance().getClient();
                lcm = client.getBusinessLifeCycleManager();
                resp = lcm.deleteObjects(removeKeys);
                client.checkBulkResponse(resp);
                if (resp.getStatus() != 0 || (currentSelection = this.getSelectionPaths()) == null) ** GOTO lbl29
                for (j = 0; j < currentSelection.length; ++j) {
                    currentNode = (DefaultMutableTreeNode)currentSelection[j].getLastPathComponent();
                    parent = (MutableTreeNode)currentNode.getParent();
                    if (parent == null) continue;
                    ((ConceptsTreeModel)this.getModel()).removeNodeFromParent(currentNode);
                }
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
        } else {
            RegistryBrowser.displayError("One or more objects must be selected in list for Remove action.");
        }
lbl29:
        // 4 sources

        RegistryBrowser.setDefaultCursor();
    }

    protected void saveAction() {
        RegistryBrowser.setWaitCursor();
        ArrayList selectedObjects = this.getSelectedObjects();
        int size = selectedObjects.size();
        if (size >= 1) {
            try {
                JAXRClient client = RegistryBrowser.getInstance().getClient();
                client.saveObjects(selectedObjects);
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
        } else {
            RegistryBrowser.displayError("One or more objects must be selected in list for Save action.");
        }
        RegistryBrowser.setDefaultCursor();
    }

    protected void browseAction() {
        RegistryBrowser.setWaitCursor();
        ArrayList selectedObjects = this.getSelectedObjects();
        int size = selectedObjects.size();
        if (size >= 1) {
            Component parent = SwingUtilities.getRoot(this);
            if (parent instanceof JFrame) {
                JBGraphPanel.browseObjects((JFrame)parent, selectedObjects, this.editable);
            } else if (parent instanceof JDialog) {
                JBGraphPanel.browseObjects((JDialog)parent, selectedObjects, this.editable);
            }
        } else {
            RegistryBrowser.displayError("One or more objects must be selected in list for Browse action.");
        }
        RegistryBrowser.setDefaultCursor();
    }

    protected void auditTrailAction() {
        RegistryBrowser.setWaitCursor();
        ArrayList selectedObjects = this.getSelectedObjects();
        int size = selectedObjects.size();
        if (size == 1) {
            RegistryObject ro = (RegistryObject)selectedObjects.get(0);
            RegistryBrowser.showAuditTrail(ro);
        } else {
            RegistryBrowser.displayError("Exactly one object must be selected in list for Show Audit Trail action.");
        }
        RegistryBrowser.setDefaultCursor();
    }

    protected void exportAction() {
        RegistryBrowser.setWaitCursor();
        ArrayList selectedObjects = this.getSelectedObjects();
        int size = selectedObjects.size();
        if (size >= 1) {
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            client.exportObjects(selectedObjects);
        } else {
            RegistryBrowser.displayError("One or more objects must be selected in list for Export action.");
        }
        RegistryBrowser.setDefaultCursor();
    }

    private void showSelectedObjectDetails() {
        ArrayList selectedObjects = this.getSelectedObjects();
        int size = selectedObjects.size();
        if (size == 1) {
            RegistryObject ro = (RegistryObject)selectedObjects.get(0);
            JBEditorDialog.showObjectDetails(this, ro, false, this.editable);
        }
    }

    public static void clearCache() {
        s_conceptsTreeModel = null;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals(RegistryBrowser.PROPERTY_AUTHENTICATED)) {
            boolean authenticated = (Boolean)ev.getNewValue();
            this.setEditable(this.editable);
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.createPopup();
    }

    public boolean isEditable() {
        return this.editable;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
            if (e.getClickCount() > 1) {
                ConceptsTree.this.showSelectedObjectDetails();
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ConceptsTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public class ConceptsTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected boolean selected;
        private boolean hasFocus;
        private boolean drawsFocusBorderAroundIcon;
        protected transient Icon closedIcon;
        protected transient Icon leafIcon;
        protected transient Icon openIcon;
        protected Color textSelectionColor;
        protected Color textNonSelectionColor;
        protected Color backgroundSelectionColor;
        protected Color backgroundNonSelectionColor;
        protected Color borderSelectionColor;
        DefaultMutableTreeNode node = null;
        Object obj = null;

        public ConceptsTreeCellRenderer() {
            this.setHorizontalAlignment(2);
            this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
            this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
            this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
            this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
            this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
            Object value = UIManager.get("Tree.drawsFocusBorderAroundIcon");
            this.drawsFocusBorderAroundIcon = value != null && (Boolean)value != false;
        }

        public Icon getDefaultOpenIcon() {
            return this.getConceptsTreeIcon();
        }

        public Icon getDefaultClosedIcon() {
            return this.getConceptsTreeIcon();
        }

        public Icon getDefaultLeafIcon() {
            return this.getConceptsTreeIcon();
        }

        public Icon getOpenIcon() {
            return this.getConceptsTreeIcon();
        }

        public Icon getClosedIcon() {
            return this.getConceptsTreeIcon();
        }

        public Icon getLeafIcon() {
            return this.getConceptsTreeIcon();
        }

        public void setTextSelectionColor(Color newColor) {
            this.textSelectionColor = newColor;
        }

        public Color getTextSelectionColor() {
            return this.textSelectionColor;
        }

        public void setTextNonSelectionColor(Color newColor) {
            this.textNonSelectionColor = newColor;
        }

        public Color getTextNonSelectionColor() {
            return this.textNonSelectionColor;
        }

        public void setBackgroundSelectionColor(Color newColor) {
            this.backgroundSelectionColor = newColor;
        }

        public Color getBackgroundSelectionColor() {
            return this.backgroundSelectionColor;
        }

        public void setBackgroundNonSelectionColor(Color newColor) {
            this.backgroundNonSelectionColor = newColor;
        }

        public Color getBackgroundNonSelectionColor() {
            return this.backgroundNonSelectionColor;
        }

        public void setBorderSelectionColor(Color newColor) {
            this.borderSelectionColor = newColor;
        }

        public Color getBorderSelectionColor() {
            return this.borderSelectionColor;
        }

        public void setFont(Font font) {
            if (font instanceof FontUIResource) {
                font = null;
            }
            super.setFont(font);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.node = (DefaultMutableTreeNode)value;
            Object icon = null;
            String text = this.node.toString();
            if (this.node == ConceptsTree.this.getModel().getRoot()) {
                this.setText(text);
                return this;
            }
            this.obj = ((NodeInfo)this.node.getUserObject()).obj;
            String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
            this.hasFocus = hasFocus;
            this.setText(stringValue);
            if (sel) {
                this.setForeground(this.getTextSelectionColor());
            } else {
                this.setForeground(this.getTextNonSelectionColor());
            }
            if (!tree.isEnabled()) {
                this.setEnabled(false);
                if (leaf) {
                    this.setDisabledIcon(this.getLeafIcon());
                } else if (expanded) {
                    this.setDisabledIcon(this.getOpenIcon());
                } else {
                    this.setDisabledIcon(this.getClosedIcon());
                }
            } else {
                this.setEnabled(true);
                if (leaf) {
                    this.setIcon(this.getLeafIcon());
                } else if (expanded) {
                    this.setIcon(this.getOpenIcon());
                } else {
                    this.setIcon(this.getClosedIcon());
                }
            }
            this.selected = sel;
            return this;
        }

        public void paint(Graphics g) {
            Color bColor;
            if (this.selected) {
                bColor = this.getBackgroundSelectionColor();
            } else {
                bColor = this.getBackgroundNonSelectionColor();
                if (bColor == null) {
                    bColor = this.getBackground();
                }
            }
            int imageOffset = -1;
            if (bColor != null) {
                Icon currentI = this.getIcon();
                imageOffset = this.getLabelStart();
                g.setColor(bColor);
                g.fillRect(imageOffset, 0, this.getWidth() - 1 - imageOffset, this.getHeight());
            }
            if (this.hasFocus) {
                if (this.drawsFocusBorderAroundIcon) {
                    imageOffset = 0;
                } else if (imageOffset == -1) {
                    imageOffset = this.getLabelStart();
                }
                Color bsColor = this.getBorderSelectionColor();
                if (bsColor != null) {
                    g.setColor(bsColor);
                    g.drawRect(imageOffset, 0, this.getWidth() - 1 - imageOffset, this.getHeight() - 1);
                }
            }
            super.paint(g);
        }

        private int getLabelStart() {
            Icon currentI = this.getIcon();
            if (currentI != null && this.getText() != null) {
                return currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
            }
            return 0;
        }

        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height);
            }
            return retDimension;
        }

        Icon getConceptsTreeIcon() {
            ImageIcon icon = null;
            URL url = null;
            url = ((NodeInfo)this.node.getUserObject()).loaded ? this.getClass().getClassLoader().getResource("icons/trfolder.gif") : this.getClass().getClassLoader().getResource("icons/trfolder.gif");
            icon = new ImageIcon(url);
            return icon;
        }
    }
}

