/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ConceptsTree;
import com.sun.xml.registry.client.browser.JBDialog;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ConceptsTreeDialog
extends JBDialog {
    private ConceptsTree conceptsTree = null;
    public static final String PROPERTY_SELECTED_CONCEPTS = "selectedConcepts";

    public ConceptsTreeDialog(JDialog parent, boolean modal) {
        super(parent, modal);
        this.ConceptsTreeDialog_initialize();
    }

    public ConceptsTreeDialog(JFrame parent, boolean modal) {
        super(parent, modal);
        this.ConceptsTreeDialog_initialize();
    }

    void ConceptsTreeDialog_initialize() {
        this.setTitle("Classification Schemes");
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gbl1 = new GridBagLayout();
        JPanel panel = this.mainPanel;
        panel.setLayout(gbl1);
        this.conceptsTree = new ConceptsTree(true);
        JScrollPane conceptsTreePane = new JScrollPane(this.conceptsTree);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(4, 4, 0, 4);
        gbl1.setConstraints(conceptsTreePane, c);
        panel.add(conceptsTreePane);
        this.pack();
    }

    ConceptsTree getModel() {
        return this.conceptsTree;
    }

    protected void okAction() {
        super.okAction();
        if (this.conceptsTree != null) {
            String test = new String();
            this.firePropertyChange(PROPERTY_SELECTED_CONCEPTS, test, this.getSelectedObjects());
        }
        this.dispose();
    }

    public ArrayList getSelectedObjects() {
        ArrayList selectedObjects = null;
        if (this.conceptsTree != null) {
            selectedObjects = this.conceptsTree.getSelectedObjects();
        }
        return selectedObjects;
    }

    public ArrayList getSelectedConcepts() {
        ArrayList selectedObjects = null;
        if (this.conceptsTree != null) {
            selectedObjects = this.conceptsTree.getSelectedConcepts();
        }
        return selectedObjects;
    }

    public ArrayList getSelectedClassificationSchemes() {
        ArrayList selectedObjects = null;
        if (this.conceptsTree != null) {
            selectedObjects = this.conceptsTree.getSelectedClassificationSchemes();
        }
        return selectedObjects;
    }

    public static ConceptsTreeDialog showSchemes(Component parent, boolean modal, boolean editable) {
        ConceptsTreeDialog dialog = null;
        RegistryBrowser.setWaitCursor();
        Window window = (Window)SwingUtilities.getRoot(parent);
        if (window instanceof JFrame) {
            dialog = new ConceptsTreeDialog((JFrame)window, modal);
        } else if (window instanceof JDialog) {
            dialog = new ConceptsTreeDialog((JDialog)window, modal);
        }
        dialog.setEditable(editable);
        dialog.setLocation((int)(window.getLocation().getX() + 30.0), (int)(window.getLocation().getY() + 30.0));
        dialog.setVisible(true);
        RegistryBrowser.setDefaultCursor();
        return dialog;
    }

    public static void clearCache() {
        ConceptsTree.clearCache();
    }

    public void setEditable(boolean editable) {
        if (this.editable != editable) {
            super.setEditable(editable);
            this.conceptsTree.setEditable(editable);
        }
    }
}

