/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.FindParamsPanel;
import com.sun.xml.registry.client.browser.JAXRResourceBundle;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectsTable;
import com.sun.xml.registry.client.browser.RegistryObjectsTableModel;
import com.sun.xml.registry.client.browser.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;

public class DiscoveryPanel
extends JPanel {
    private JAXRResourceBundle resourceBundle = JAXRResourceBundle.getInstance();
    private GridBagConstraints c = new GridBagConstraints();
    private RegistryObjectsTableModel registryObjectsTableModel = null;
    private RegistryObjectsTable registryObjectsTable = null;
    JPanel registryObjectsDetailPanel = null;
    JSplitPane splitPane2 = null;
    FindParamsPanel findParamsPanel = null;

    public DiscoveryPanel() throws JAXRException {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.findParamsPanel = new FindParamsPanel(this);
        JPanel findResultsPanel = this.createFindResultsPanel();
        JSplitPane splitPane = new JSplitPane(1, this.findParamsPanel, findResultsPanel);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 1;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 4, 4);
        gbl.setConstraints(splitPane, this.c);
        this.add(splitPane);
    }

    private JPanel createFindResultsPanel() {
        JPanel registryObjectsTablePanel = new JPanel();
        registryObjectsTablePanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("tabbedPane.discovery.searchResults")));
        registryObjectsTablePanel.setLayout(new BorderLayout());
        this.registryObjectsTableModel = new RegistryObjectsTableModel();
        TableSorter sorter = new TableSorter(this.registryObjectsTableModel);
        this.registryObjectsTable = new RegistryObjectsTable(sorter);
        sorter.addMouseListenerToHeaderInTable(this.registryObjectsTable);
        JScrollPane registryObjectsTablePane = new JScrollPane(this.registryObjectsTable);
        registryObjectsTablePanel.add((Component)registryObjectsTablePane, "Center");
        return registryObjectsTablePanel;
    }

    void find() {
        RegistryBrowser.setWaitCursor();
        if (RegistryBrowser.client.connection == null) {
            RegistryBrowser.displayError("Connect to a registry by specifying Registry Location first.");
        } else {
            BulkResponse resp = this.findParamsPanel.executeQuery();
            if (resp != null) {
                this.registryObjectsTableModel.update(resp);
            }
        }
        RegistryBrowser.setDefaultCursor();
    }

    public void clear() throws JAXRException {
        this.registryObjectsTableModel.setRegistryObjects(new ArrayList());
        this.findParamsPanel.clear();
    }
}

