/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ExternalLinksListModel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectsList;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ExternalLink;

public class ExternalLinksList
extends RegistryObjectsList {
    public ExternalLinksList() {
        this(new ExternalLinksListModel());
    }

    public ExternalLinksList(ExternalLinksListModel model) {
        super("ExternalLink", model);
        this.setCellRenderer(new ExternalLinkRenderer());
    }

    class ExternalLinkRenderer
    extends JLabel
    implements ListCellRenderer {
        public ExternalLinkRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            try {
                String externalURI;
                ExternalLinksListModel model = (ExternalLinksListModel)list.getModel();
                ExternalLink link = (ExternalLink)model.elementAt(index);
                String str = externalURI = link.getExternalURI();
                String desc = RegistryBrowser.getDescription(link);
                if (desc != null && desc.length() > 0) {
                    str = str + " ( " + desc + " )";
                }
                this.setText(str);
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
            return this;
        }
    }
}

