/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.LocalizedStringsListModel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectsList;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.LocalizedString;

public class LocalizedStringsList
extends RegistryObjectsList {
    public LocalizedStringsList() {
        this(new LocalizedStringsListModel());
    }

    public LocalizedStringsList(LocalizedStringsListModel model) {
        super("LocalizedString", model);
        this.setCellRenderer(new LocalizedStringRenderer());
    }

    public static String localizedStringToString(LocalizedString lString) throws JAXRException {
        String str = "(" + lString.getLocale() + "): " + lString.getValue();
        return str;
    }

    class LocalizedStringRenderer
    extends JLabel
    implements ListCellRenderer {
        public LocalizedStringRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            try {
                LocalizedStringsListModel model = (LocalizedStringsListModel)list.getModel();
                LocalizedString lString = (LocalizedString)model.elementAt(index);
                this.setText(LocalizedStringsList.localizedStringToString(lString));
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
            return this;
        }
    }
}

