/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.HyperLinkContainer;
import com.sun.xml.registry.client.browser.HyperLinkLabel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectPanel;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ServiceBinding;

public class ServiceBindingPanel
extends RegistryObjectPanel {
    JTextField accessURIText = null;

    public ServiceBindingPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Service Binding"));
        HyperLinkLabel accessURILabel = new HyperLinkLabel("Access URI:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(accessURILabel, this.c);
        this.add(accessURILabel);
        this.accessURIText = new JTextField();
        this.accessURIText.setEditable(this.editable);
        this.c.gridx = 0;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.accessURIText, this.c);
        this.add(this.accessURIText);
        accessURILabel.setHyperLinkContainer(new HyperLinkContainer(){

            public String getURL() {
                return ServiceBindingPanel.this.accessURIText.getText();
            }

            public void setURL(String url) {
                ServiceBindingPanel.this.accessURIText.setText(url);
            }
        });
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof ServiceBinding)) {
            throw new InvalidRequestException("Expecting a ServiceBinding. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        ServiceBinding binding = (ServiceBinding)obj;
        try {
            String accessURIStr;
            if (binding != null && (accessURIStr = binding.getAccessURI()) != null) {
                this.accessURIText.setText(accessURIStr);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            ServiceBinding serviceBinding = (ServiceBinding)this.model;
            String accessURITextStr = this.accessURIText.getText();
            serviceBinding.setAccessURI(accessURITextStr);
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        String accessURITextStr = this.accessURIText.getText();
        if (accessURITextStr.length() <= 0 || accessURITextStr.length() > 256) {
            throw new JAXRException("Error. ServiceBinding.accessURI length must be between 1 and 256");
        }
    }

    public void clear() throws JAXRException {
        super.clear();
        this.accessURIText.setText("");
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.accessURIText.setEditable(editable);
    }
}

